/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Tree
extends Test_org_eclipse_swt_widgets_Composite {
    private Tree tree;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.tree = new Tree((Composite)this.shell, 2);
        this.setWidget((Widget)this.tree);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        int[] cases;
        try {
            this.tree = new Tree(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int[] nArray = new int[2];
        nArray[1] = 2048;
        int[] nArray2 = cases = nArray;
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            int style = nArray2[n2];
            this.tree = new Tree((Composite)this.shell, style);
            ++n2;
        }
        int[] nArray3 = new int[3];
        nArray3[1] = 10;
        nArray3[2] = 100;
        nArray2 = cases = nArray3;
        n = cases.length;
        n2 = 0;
        while (n2 < n) {
            int count = nArray2[n2];
            int i = 0;
            while (i < count) {
                new TreeItem(this.tree, 0);
                ++i;
            }
            Assert.assertEquals((long)count, (long)this.tree.getItemCount());
            this.tree.removeAll();
            ++n2;
        }
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
    }

    @Test
    public void test_deselectAll() {
        int number = 15;
        TreeItem[] items = new TreeItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TreeItem(this.tree, 0);
            ++i;
        }
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(new TreeItem[]{items[2], items[4], items[5], items[10]});
        Assert.assertEquals((long)4L, (long)this.tree.getSelectionCount());
        this.tree.deselectAll();
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
        this.tree.selectAll();
        Assert.assertEquals((long)number, (long)this.tree.getSelectionCount());
        this.tree.deselectAll();
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
    }

    @Test
    public void test_getColumnCount() {
        Assert.assertEquals((long)0L, (long)this.tree.getColumnCount());
        TreeColumn column0 = new TreeColumn(this.tree, 0);
        Assert.assertEquals((long)1L, (long)this.tree.getColumnCount());
        TreeColumn column1 = new TreeColumn(this.tree, 0);
        Assert.assertEquals((long)2L, (long)this.tree.getColumnCount());
        TreeColumn column2 = new TreeColumn(this.tree, 0);
        Assert.assertEquals((long)3L, (long)this.tree.getColumnCount());
        column0.dispose();
        Assert.assertEquals((long)2L, (long)this.tree.getColumnCount());
        column1.dispose();
        Assert.assertEquals((long)1L, (long)this.tree.getColumnCount());
        column2.dispose();
        Assert.assertEquals((long)0L, (long)this.tree.getColumnCount());
    }

    @Test
    public void test_getColumnI() {
        try {
            this.tree.getColumn(0);
            Assert.fail((String)"No exception thrown for index out of range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        TreeColumn column0 = new TreeColumn(this.tree, 16384);
        try {
            this.tree.getColumn(1);
            Assert.fail((String)"No exception thrown for index out of range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((Object)column0, (Object)this.tree.getColumn(0));
        TreeColumn column1 = new TreeColumn(this.tree, 16384);
        Assert.assertEquals((Object)column1, (Object)this.tree.getColumn(1));
        column1.dispose();
        try {
            this.tree.getColumn(1);
            Assert.fail((String)"No exception thrown for index out of range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        column0.dispose();
        try {
            this.tree.getColumn(0);
            Assert.fail((String)"No exception thrown for index out of range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_getColumns() {
        Assert.assertEquals((long)0L, (long)this.tree.getColumns().length);
        TreeColumn column0 = new TreeColumn(this.tree, 16384);
        TreeColumn[] columns = this.tree.getColumns();
        Assert.assertEquals((long)1L, (long)columns.length);
        Assert.assertEquals((Object)column0, (Object)columns[0]);
        column0.dispose();
        Assert.assertEquals((long)0L, (long)this.tree.getColumns().length);
        column0 = new TreeColumn(this.tree, 16384);
        TreeColumn column1 = new TreeColumn(this.tree, 131072, 1);
        columns = this.tree.getColumns();
        Assert.assertEquals((long)2L, (long)columns.length);
        Assert.assertEquals((Object)column0, (Object)columns[0]);
        Assert.assertEquals((Object)column1, (Object)columns[1]);
        column0.dispose();
        columns = this.tree.getColumns();
        Assert.assertEquals((long)1L, (long)columns.length);
        Assert.assertEquals((Object)column1, (Object)columns[0]);
        column1.dispose();
        Assert.assertEquals((long)0L, (long)this.tree.getColumns().length);
    }

    @Test
    public void test_getGridLineWidth() {
        this.tree.getGridLineWidth();
    }

    @Test
    public void test_getHeaderHeight() {
        if (SwtTestUtil.isGTK) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getHeaderHeight(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Tree)");
            }
            return;
        }
        Assert.assertEquals((long)0L, (long)this.tree.getHeaderHeight());
        this.tree.setHeaderVisible(true);
        Assert.assertTrue((this.tree.getHeaderHeight() > 0 ? 1 : 0) != 0);
        this.tree.setHeaderVisible(false);
        Assert.assertEquals((long)0L, (long)this.tree.getHeaderHeight());
    }

    @Test
    public void test_getItemHeight() {
        Assert.assertTrue((String)":a: Item height is 0", (this.tree.getItemHeight() > 0 ? 1 : 0) != 0);
        new TreeItem(this.tree, 0);
        Assert.assertTrue((String)":b: Item height is 0", (this.tree.getItemHeight() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getItemI() {
        int number = 15;
        TreeItem[] items = new TreeItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TreeItem(this.tree, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((String)("i=" + i), (Object)items[i], (Object)this.tree.getItem(i));
            ++i;
        }
        try {
            this.tree.getItem(number);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.tree.getItem(number + 1);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.tree.getItem(-1);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_getItems() {
        int[] nArray = new int[3];
        nArray[1] = 10;
        nArray[2] = 100;
        int[] cases = nArray;
        TreeItem[][] items = new TreeItem[cases.length][];
        int j = 0;
        while (j < cases.length) {
            items[j] = new TreeItem[cases[j]];
            ++j;
        }
        j = 0;
        while (j < cases.length) {
            int i = 0;
            while (i < cases[j]) {
                TreeItem ti;
                items[j][i] = ti = new TreeItem(this.tree, 0);
                ++i;
            }
            Assert.assertArrayEquals((Object[])items[j], (Object[])this.tree.getItems());
            this.tree.removeAll();
            Assert.assertEquals((long)0L, (long)this.tree.getItemCount());
            ++j;
        }
        this.makeCleanEnvironment(false);
        int[] nArray2 = cases;
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            int count = nArray2[n2];
            int i = 0;
            while (i < count) {
                TreeItem ti = new TreeItem(this.tree, 0);
                ti.setText(String.valueOf(i));
                ++i;
            }
            TreeItem[] items2 = this.tree.getItems();
            int i2 = 0;
            while (i2 < items2.length) {
                Assert.assertEquals((Object)String.valueOf(i2), (Object)items2[i2].getText());
                ++i2;
            }
            this.tree.removeAll();
            Assert.assertEquals((long)0L, (long)this.tree.getItemCount());
            ++n2;
        }
    }

    @Test
    public void test_getParentItem() {
        Assert.assertNull((Object)this.tree.getParentItem());
    }

    @Test
    public void test_getSelectionCount() {
        int number = 15;
        TreeItem[] items = new TreeItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TreeItem(this.tree, 0);
            ++i;
        }
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(new TreeItem[]{items[2]});
        Assert.assertEquals((long)1L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(new TreeItem[]{items[number - 1]});
        Assert.assertEquals((long)1L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(new TreeItem[]{items[10]});
        Assert.assertEquals((long)1L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(new TreeItem[]{items[2], items[number - 1], items[10]});
        Assert.assertEquals((long)3L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(items);
        Assert.assertEquals((long)15L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(new TreeItem[0]);
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
        this.makeCleanEnvironment(true);
        items = new TreeItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TreeItem(this.tree, 0);
            ++i;
        }
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(new TreeItem[]{items[2]});
        Assert.assertEquals((long)1L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(new TreeItem[]{items[number - 1]});
        Assert.assertEquals((long)1L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(new TreeItem[]{items[10]});
        Assert.assertEquals((long)1L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(new TreeItem[]{items[2], items[number - 1], items[10]});
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(items);
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(new TreeItem[0]);
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
    }

    @Test
    public void test_removeAll() {
        this.tree.removeAll();
        Assert.assertEquals((long)0L, (long)this.tree.getItemCount());
        int number = 20;
        TreeItem[] items = new TreeItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TreeItem(this.tree, 0);
            ++i;
        }
        Assert.assertEquals((long)number, (long)this.tree.getItemCount());
        this.tree.removeAll();
        Assert.assertEquals((long)0L, (long)this.tree.getItemCount());
    }

    @Test
    public void test_selectAll() {
        int number = 5;
        TreeItem[] items = new TreeItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TreeItem(this.tree, 0);
            ++i;
        }
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
        this.tree.selectAll();
        Assert.assertEquals((long)number, (long)this.tree.getSelectionCount());
        this.makeCleanEnvironment(true);
        items = new TreeItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TreeItem(this.tree, 0);
            ++i;
        }
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
        this.tree.selectAll();
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
    }

    @Test
    public void test_setHeaderBackgroundLorg_eclipse_swt_graphics_Color() {
        Assert.assertNotNull((Object)this.tree.getHeaderBackground());
        Color color = new Color(12, 34, 56);
        this.tree.setHeaderBackground(color);
        Assert.assertEquals((Object)color, (Object)this.tree.getHeaderBackground());
        this.tree.setHeaderBackground(null);
        Assert.assertFalse((boolean)this.tree.getHeaderBackground().equals((Object)color));
    }

    @Test
    public void test_setHeaderForegroundLorg_eclipse_swt_graphics_Color() {
        Assert.assertNotNull((Object)this.tree.getHeaderForeground());
        Color color = new Color(12, 34, 56);
        this.tree.setHeaderForeground(color);
        Assert.assertEquals((Object)color, (Object)this.tree.getHeaderForeground());
        this.tree.setHeaderForeground(null);
        Assert.assertFalse((boolean)this.tree.getHeaderForeground().equals((Object)color));
    }

    @Test
    public void test_setHeaderVisibleZ() {
        Assert.assertFalse((boolean)this.tree.getHeaderVisible());
        this.tree.setHeaderVisible(true);
        Assert.assertTrue((boolean)this.tree.getHeaderVisible());
        this.tree.setHeaderVisible(false);
        Assert.assertFalse((boolean)this.tree.getHeaderVisible());
    }

    @Test
    public void test_setItemCountI() {
        this.tree.removeAll();
        Assert.assertEquals((long)0L, (long)this.tree.getItemCount());
        int i = 0;
        while (i < 8) {
            new TreeItem(this.tree, 0);
            Assert.assertEquals((long)(i + 1), (long)this.tree.getItemCount());
            ++i;
        }
        Assert.assertEquals((long)8L, (long)this.tree.getItemCount());
        Assert.assertEquals((long)4L, (long)this.tree.indexOf(this.tree.getItems()[4]));
        this.tree.getItem(1).dispose();
        Assert.assertEquals((long)7L, (long)this.tree.getItemCount());
        new TreeItem(this.tree, 0, 0);
        Assert.assertEquals((long)1L, (long)this.tree.indexOf(this.tree.getItems()[1]));
        Assert.assertEquals((long)8L, (long)this.tree.getItemCount());
        this.tree.setItemCount(0);
        Assert.assertEquals((long)0L, (long)this.tree.getItemCount());
        this.tree.setItemCount(0);
        Assert.assertEquals((long)0L, (long)this.tree.getItemCount());
        this.tree.setItemCount(-1);
        Assert.assertEquals((long)0L, (long)this.tree.getItemCount());
        this.tree.setItemCount(10);
        Assert.assertEquals((long)10L, (long)this.tree.getItemCount());
        this.tree.getItem(1).dispose();
        Assert.assertEquals((long)9L, (long)this.tree.getItemCount());
        Assert.assertEquals((long)4L, (long)this.tree.indexOf(this.tree.getItems()[4]));
        this.tree.setItemCount(3);
        Assert.assertEquals((long)3L, (long)this.tree.getItemCount());
        try {
            this.tree.getItem(4);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.tree.setItemCount(40);
        Assert.assertEquals((long)40L, (long)this.tree.getItemCount());
        this.tree.getItem(39);
        this.tree.setItemCount(0);
        Assert.assertEquals((long)0L, (long)this.tree.getItemCount());
        try {
            this.tree.getItem(39);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setLinesVisibleZ() {
        Assert.assertFalse((boolean)this.tree.getLinesVisible());
        this.tree.setLinesVisible(true);
        Assert.assertTrue((boolean)this.tree.getLinesVisible());
        this.tree.setLinesVisible(false);
        Assert.assertFalse((boolean)this.tree.getLinesVisible());
    }

    @Override
    @Test
    public void test_setRedrawZ() {
    }

    @Test
    public void test_setSelection$Lorg_eclipse_swt_widgets_TreeItem() {
        int number = 20;
        Object[] items = new TreeItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TreeItem(this.tree, 0);
            ++i;
        }
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[5], items[16], items[19]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[5], items[16], items[19]}, (Object[])this.tree.getSelection());
        this.tree.setSelection((TreeItem[])items);
        Assert.assertArrayEquals((Object[])items, (Object[])this.tree.getSelection());
        this.tree.setSelection(this.tree.getItems());
        Assert.assertArrayEquals((Object[])this.tree.getItems(), (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[0]);
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
        try {
            this.tree.setSelection(null);
            Assert.fail((String)"No exception thrown for items == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.tree.setSelection(new TreeItem[1]);
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
        this.tree.setSelection(new TreeItem[]{items[10]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[10]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[number - 1]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[number - 1]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[2]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[2]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[10], items[number - 1], items[2]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[2], items[10], items[number - 1]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[0], items[3], items[2]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[0], items[2], items[3]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[3], items[2], items[1]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[1], items[2], items[3]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[1], items[4], items[0]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[0], items[1], items[4]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[0], items[4], items[0]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[0], items[4]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[2], items[3], items[4]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[2], items[3], items[4]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[4], items[4], items[4], items[4], items[4], items[4]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[4]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[0]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[0]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[3]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[3]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[4]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[4]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[2]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[2]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[1]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[1]}, (Object[])this.tree.getSelection());
        this.tree.removeAll();
        this.tree.setSelection(new TreeItem[0]);
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.makeCleanEnvironment(true);
        items = new TreeItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TreeItem(this.tree, 0);
            ++i;
        }
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[5], items[16], items[19]});
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.tree.setSelection((TreeItem[])items);
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.tree.setSelection(this.tree.getItems());
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[0]);
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        Assert.assertEquals((long)0L, (long)this.tree.getSelectionCount());
        try {
            this.tree.setSelection(null);
            Assert.fail((String)"No exception thrown for items == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.tree.setSelection(new TreeItem[]{items[10]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[10]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[number - 1]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[number - 1]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[2]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[2]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[10], items[number - 1], items[2]});
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[0], items[3], items[2]});
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[3], items[2], items[1]});
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[1], items[4], items[0]});
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[0], items[4], items[0]});
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[2], items[3], items[4]});
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[4], items[4], items[4], items[4], items[4], items[4]});
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[0]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[0]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[3]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[3]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[4]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[4]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[2]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[2]}, (Object[])this.tree.getSelection());
        this.tree.setSelection(new TreeItem[]{items[1]});
        Assert.assertArrayEquals((Object[])new TreeItem[]{items[1]}, (Object[])this.tree.getSelection());
        this.tree.removeAll();
        this.tree.setSelection(new TreeItem[0]);
        Assert.assertArrayEquals((Object[])new TreeItem[0], (Object[])this.tree.getSelection());
    }

    @Test
    public void test_setTopItemLorg_eclipse_swt_widgets_TreeItem() {
        this.tree.removeAll();
        int i = 0;
        while (i < 10) {
            new TreeItem(this.tree, 0);
            ++i;
        }
        TreeItem top = new TreeItem(this.tree, 0);
        int i2 = 0;
        while (i2 < 10) {
            new TreeItem(this.tree, 0);
            ++i2;
        }
        this.tree.setSize(50, 50);
        this.shell.open();
        this.tree.setTopItem(top);
        i2 = 0;
        while (i2 < 10) {
            new TreeItem(this.tree, 0);
            ++i2;
        }
        TreeItem top2 = this.tree.getTopItem();
        this.shell.setVisible(false);
        Assert.assertEquals((Object)top, (Object)top2);
        try {
            try {
                this.shell.setVisible(true);
                this.tree.setTopItem(null);
                Assert.fail((String)"No exception thrown for item == null");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.shell.setVisible(false);
            }
        }
        finally {
            this.shell.setVisible(false);
        }
    }

    @Test
    public void test_showItemLorg_eclipse_swt_widgets_TreeItem() {
        try {
            this.tree.showItem(null);
            Assert.fail((String)"No exception thrown for item == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int number = 20;
        TreeItem[] items = new TreeItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TreeItem(this.tree, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            this.tree.showItem(items[i]);
            ++i;
        }
        this.tree.removeAll();
        this.makeCleanEnvironment(false);
        items = new TreeItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TreeItem(this.tree, 0);
            ++i;
        }
        Tree tree2 = new Tree((Composite)this.shell, 0);
        TreeItem[] items2 = new TreeItem[number];
        int i2 = 0;
        while (i2 < number) {
            items2[i2] = new TreeItem(tree2, 0);
            ++i2;
        }
        i2 = 0;
        while (i2 < number) {
            this.tree.showItem(items2[i2]);
            ++i2;
        }
        this.tree.removeAll();
    }

    @Test
    public void test_addTreeListenerTreeCollapsedAdapterLorg_eclipse_swt_events_TreeListener() {
        TreeListener listener = TreeListener.treeCollapsedAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.tree.addTreeListener(listener);
        this.eventOccurred = false;
        this.tree.notifyListeners(18, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.tree.notifyListeners(17, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.tree.removeTreeListener(listener);
        this.eventOccurred = false;
        this.tree.notifyListeners(18, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.tree.notifyListeners(17, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addTreeListenerTreeExpandedAdapterLorg_eclipse_swt_events_TreeListener() {
        TreeListener listener = TreeListener.treeExpandedAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.tree.addTreeListener(listener);
        this.eventOccurred = false;
        this.tree.notifyListeners(17, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.tree.notifyListeners(18, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.tree.removeTreeListener(listener);
        this.eventOccurred = false;
        this.tree.notifyListeners(17, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.tree.notifyListeners(18, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_showSelection() {
        this.tree.showSelection();
        TreeItem item = new TreeItem(this.tree, 0);
        this.tree.setSelection(new TreeItem[]{item});
        this.tree.showSelection();
    }

    private void makeCleanEnvironment(boolean single) {
        if (this.tree != null) {
            this.tree.dispose();
        }
        this.tree = new Tree((Composite)this.shell, single ? 4 : 2);
        this.setWidget((Widget)this.tree);
    }

    private void createTree(List<String> events) {
        this.makeCleanEnvironment(true);
        int i = 0;
        while (i < 3) {
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText("TreeItem" + i);
            int j = 0;
            while (j < 4) {
                TreeItem ti = new TreeItem(item, 0);
                ti.setText("TreeItem" + i + j);
                this.hookExpectedEvents((Widget)ti, this.getTestName(), events);
                ++j;
            }
            this.hookExpectedEvents((Widget)item, this.getTestName(), events);
            ++i;
        }
    }

    @Test
    public void test_consistency_KeySelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTree(events);
        this.consistencyEvent(0, 0x1000002, 0, 0, 10, events);
    }

    @Test
    public void test_consistency_MouseSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTree(events);
        this.consistencyEvent(30, 30, 1, 0, 30, events);
    }

    @Test
    public void test_consistency_MouseExpand() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTree(events);
        this.consistencyEvent(11, 10, 1, 0, 30, events);
    }

    @Test
    public void test_consistency_KeyExpand() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTree(events);
        int code = 0x1000004;
        if (SwtTestUtil.isGTK) {
            code = 16777259;
        }
        this.consistencyEvent(0, code, 0, 0, 10, events);
    }

    @Test
    public void test_consistency_DoubleClick() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTree(events);
        this.consistencyPrePackShell();
        this.consistencyEvent(20, this.tree.getItemHeight() * 2, 1, 0, 40, events);
    }

    @Test
    public void test_consistency_EnterSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTree(events);
        this.consistencyEvent(13, 10, 0, 0, 10, events);
    }

    @Test
    public void test_consistency_SpaceSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTree(events);
        this.consistencyEvent(32, 32, 0, 0, 10, events);
    }

    @Test
    public void test_consistency_MenuDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTree(events);
        this.consistencyEvent(50, 25, 3, 0, 30, events);
    }

    @Test
    public void test_consistency_DragDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTree(events);
        this.consistencyEvent(30, 20, 50, 30, 50, events);
    }

    @Test
    public void test_disposeItemNotTriggerSelection() {
        Display display = this.shell.getDisplay();
        this.shell.setLayout((Layout)new FillLayout());
        Tree tree = new Tree((Composite)this.shell, 2048);
        int i = 0;
        while (i < 4) {
            TreeItem iItem = new TreeItem(tree, 0);
            iItem.setText("TreeItem (0) -" + i);
            int j = 0;
            while (j < 4) {
                TreeItem jItem = new TreeItem(iItem, 0);
                jItem.setText("TreeItem (1) -" + j);
                int k = 0;
                while (k < 4) {
                    TreeItem kItem = new TreeItem(jItem, 0);
                    kItem.setText("TreeItem (2) -" + k);
                    int l = 0;
                    while (l < 4) {
                        TreeItem lItem = new TreeItem(kItem, 0);
                        lItem.setText("TreeItem (3) -" + l);
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        boolean[] selectionCalled = new boolean[1];
        tree.addListener(13, event -> {
            blArray[0] = true;
        });
        TreeItem firstNode = tree.getItem(0);
        firstNode.setExpanded(true);
        tree.setSelection(firstNode.getItem(3));
        this.shell.setSize(200, 200);
        this.shell.open();
        display.timerExec(1000, () -> {
            if (this.shell.isDisposed()) {
                return;
            }
            TreeItem[] selection = tree.getSelection();
            if (selection.length != 1) {
                return;
            }
            TreeItem item = selection[0];
            TreeItem parentItem = item.getParentItem();
            if (parentItem == null) {
                return;
            }
            tree.deselectAll();
            item.dispose();
        });
        long end = System.currentTimeMillis() + 3000L;
        while (!this.shell.isDisposed() && System.currentTimeMillis() < end) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.assertFalse((boolean)selectionCalled[0]);
    }

    @Test
    public void test_Virtual() {
        this.tree.dispose();
        this.tree = new Tree((Composite)this.shell, 0x10000800);
        this.setWidget((Widget)this.tree);
        int count = 10000;
        int visibleCount = 10;
        this.shell.setLayout((Layout)new FillLayout());
        TreeItem[] top = new TreeItem[1];
        int[] dataCounter = new int[1];
        this.tree.addListener(36, event -> {
            TreeItem item = (TreeItem)event.item;
            if (item.getParentItem() == null) {
                treeItemArray[0] = item;
                item.setText("top");
            } else {
                if (top[0] == null) {
                    treeItemArray[0] = this.tree.getItem(0);
                }
                if (top[0] != null) {
                    int index = top[0].indexOf(item);
                    item.setText("Item " + index);
                }
            }
            nArray[0] = dataCounter[0] + 1;
        });
        this.tree.setItemCount(1);
        this.shell.setSize(200, this.tree.getItemHeight() * visibleCount);
        this.shell.open();
        TreeItem item0 = this.tree.getItem(0);
        item0.setItemCount(count);
        item0.setExpanded(true);
        long end = System.currentTimeMillis() + 3000L;
        Display display = this.shell.getDisplay();
        while (!display.isDisposed() && System.currentTimeMillis() < end) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (SwtTestUtil.isCocoa) {
            Assert.assertTrue((String)"SetData not called for top item", (top[0] != null ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)("SetData callback count not in range: " + dataCounter[0]), (dataCounter[0] > visibleCount / 2 && dataCounter[0] <= visibleCount * 3 ? 1 : 0) != 0);
    }

    @Test
    public void test_emptinessChanged() {
        int NOT_EMPTY = 0;
        int EMPTY = 1;
        int[] count = new int[2];
        this.tree.addListener(56, e -> {
            int n = e.detail;
            int n2 = nArray[n] = count[n] + 1;
        });
        TreeItem item1 = new TreeItem(this.tree, 0);
        Assert.assertEquals((long)1L, (long)count[NOT_EMPTY]);
        Assert.assertEquals((long)0L, (long)count[EMPTY]);
        TreeItem item2 = new TreeItem(this.tree, 0);
        Assert.assertEquals((long)1L, (long)count[NOT_EMPTY]);
        Assert.assertEquals((long)0L, (long)count[EMPTY]);
        item1.dispose();
        Assert.assertEquals((long)1L, (long)count[NOT_EMPTY]);
        Assert.assertEquals((long)0L, (long)count[EMPTY]);
        item2.dispose();
        Assert.assertEquals((long)1L, (long)count[NOT_EMPTY]);
        Assert.assertEquals((long)1L, (long)count[EMPTY]);
        item1 = new TreeItem(this.tree, 0);
        Assert.assertEquals((long)2L, (long)count[NOT_EMPTY]);
        Assert.assertEquals((long)1L, (long)count[EMPTY]);
        item2 = new TreeItem(item1, 0);
        Assert.assertEquals((long)2L, (long)count[NOT_EMPTY]);
        Assert.assertEquals((long)1L, (long)count[EMPTY]);
        item1.dispose();
        Assert.assertEquals((long)2L, (long)count[NOT_EMPTY]);
        Assert.assertEquals((long)2L, (long)count[EMPTY]);
        item2.dispose();
        Assert.assertEquals((long)2L, (long)count[NOT_EMPTY]);
        Assert.assertEquals((long)2L, (long)count[EMPTY]);
    }

    private void testTreeRegularAndVirtual(Runnable runnable) {
        runnable.run();
        this.tree.dispose();
        this.tree = new Tree((Composite)this.shell, 0x10000000);
        this.setWidget((Widget)this.tree);
        runnable.run();
    }

    @Test
    public void test_setItemCount_itemOrderRoot() {
        this.testTreeRegularAndVirtual(() -> {
            Tree parent = this.tree;
            new TreeItem(parent, 0).setText("0");
            new TreeItem(parent, 0).setText("2");
            new TreeItem(parent, 0, 1).setText("1");
            parent.setItemCount(6);
            parent.getItem(3).setText("3");
            parent.getItem(4).setText("4");
            parent.getItem(5).setText("5");
            new TreeItem(parent, 0).setText("6");
            new TreeItem(parent, 0).setText("8");
            new TreeItem(parent, 0, 7).setText("7");
            parent.setItemCount(12);
            parent.getItem(9).setText("9");
            parent.getItem(10).setText("10");
            parent.getItem(11).setText("11");
            TreeItem[] items = parent.getItems();
            Assert.assertEquals((long)12L, (long)items.length);
            int iItem = 0;
            while (iItem < items.length) {
                Assert.assertEquals((Object)Integer.toString(iItem), (Object)items[iItem].getText());
                ++iItem;
            }
            parent = this.tree.getItem(0);
            new TreeItem((TreeItem)parent, 0).setText("0");
            new TreeItem((TreeItem)parent, 0).setText("2");
            new TreeItem((TreeItem)parent, 0, 1).setText("1");
            parent.setItemCount(6);
            parent.getItem(3).setText("3");
            parent.getItem(4).setText("4");
            parent.getItem(5).setText("5");
            new TreeItem((TreeItem)parent, 0).setText("6");
            new TreeItem((TreeItem)parent, 0).setText("8");
            new TreeItem((TreeItem)parent, 0, 7).setText("7");
            parent.setItemCount(12);
            parent.getItem(9).setText("9");
            parent.getItem(10).setText("10");
            parent.getItem(11).setText("11");
            items = parent.getItems();
            Assert.assertEquals((long)12L, (long)items.length);
            iItem = 0;
            while (iItem < items.length) {
                Assert.assertEquals((Object)Integer.toString(iItem), (Object)items[iItem].getText());
                ++iItem;
            }
        });
    }

    @Test
    public void test_setItemCount_indexOf() {
        this.testTreeRegularAndVirtual(() -> {
            this.tree.setItemCount(10);
            TreeItem item_0 = this.tree.getItem(0);
            TreeItem item_2 = this.tree.getItem(2);
            item_0.setItemCount(10);
            item_0.setExpanded(true);
            TreeItem item_0_4 = item_0.getItem(4);
            if (!this.shell.getVisible()) {
                this.shell.setLayout((Layout)new FillLayout());
                this.shell.pack();
                this.shell.open();
            } else {
                this.tree.pack();
            }
            SwtTestUtil.processEvents();
            this.tree.setItemCount(5);
            this.tree.setItemCount(10);
            SwtTestUtil.processEvents();
            Assert.assertEquals((long)2L, (long)this.tree.indexOf(item_2));
            item_0.setItemCount(5);
            item_0.indexOf(item_0_4);
            item_0.setItemCount(10);
            Assert.assertEquals((long)4L, (long)item_0.indexOf(item_0_4));
        });
    }

    @Test
    public void test_setItemCount_itemCount() {
        this.testTreeRegularAndVirtual(() -> {
            this.tree.setItemCount(10);
            Assert.assertEquals((long)10L, (long)this.tree.getItemCount());
            this.tree.setItemCount(20);
            Assert.assertEquals((long)20L, (long)this.tree.getItemCount());
            this.tree.setItemCount(5);
            Assert.assertEquals((long)5L, (long)this.tree.getItemCount());
            TreeItem item_0 = this.tree.getItem(0);
            item_0.setItemCount(10);
            Assert.assertEquals((long)10L, (long)item_0.getItemCount());
            item_0.setItemCount(20);
            Assert.assertEquals((long)20L, (long)item_0.getItemCount());
            item_0.setItemCount(5);
            Assert.assertEquals((long)5L, (long)item_0.getItemCount());
        });
    }

    @Test
    public void test_setItemCount_itemCount2() {
        this.testTreeRegularAndVirtual(() -> {
            this.tree.setItemCount(10);
            this.tree.getItem(5).dispose();
            new TreeItem(this.tree, 0, 0);
            Assert.assertEquals((long)10L, (long)this.tree.getItemCount());
            TreeItem item_0 = this.tree.getItem(0);
            item_0.setItemCount(10);
            item_0.getItem(5).dispose();
            new TreeItem(item_0, 0, 0);
            Assert.assertEquals((long)10L, (long)item_0.getItemCount());
        });
    }
}

