/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.tests.junit.ConsistencyUtility;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.test.Screenshots;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

abstract class Test_org_eclipse_swt_widgets_Widget {
    protected Shell shell;
    private Widget widget;
    boolean listenerCalled;
    boolean disposedIntentionally;
    @Rule
    public TestName name = new TestName();
    @Rule
    public Screenshots.ScreenshotOnFailure screenshotRule = new Screenshots.ScreenshotOnFailure(() -> this.shell){

        public void dispose() {
            Display display = null;
            if (!Test_org_eclipse_swt_widgets_Widget.this.disposedIntentionally) {
                Assert.assertFalse((boolean)Test_org_eclipse_swt_widgets_Widget.this.shell.isDisposed());
                display = Test_org_eclipse_swt_widgets_Widget.this.shell.getDisplay();
            }
            super.dispose();
            Test_org_eclipse_swt_widgets_Widget.this.afterDispose(display);
        }
    };

    Test_org_eclipse_swt_widgets_Widget() {
    }

    @Before
    public void setUp() {
        this.shell = new Shell();
    }

    @After
    public void tearDown() {
        if (this.widget != null) {
            Assert.assertEquals((Object)this.disposedIntentionally, (Object)this.widget.isDisposed());
        }
    }

    protected void afterDispose(Display display) {
        if (this.widget != null) {
            Assert.assertTrue((boolean)this.widget.isDisposed());
            if (SwtTestUtil.isLinux && display != null) {
                this.assertNotExists(Test_org_eclipse_swt_widgets_Widget.getWidgetTable(display), this.widget);
            }
        }
        Assert.assertTrue((boolean)this.shell.isDisposed());
        if (SwtTestUtil.isCocoa || SwtTestUtil.isGTK) {
            while (display != null && !display.isDisposed() && display.readAndDispatch()) {
            }
        }
        if (SwtTestUtil.isLinux && display != null) {
            this.assertNotExists(Test_org_eclipse_swt_widgets_Widget.getWidgetTable(display), (Widget)this.shell);
        }
    }

    @Test
    public void test_addDisposeListenerLorg_eclipse_swt_events_DisposeListener() {
        DisposeListener listener = e -> {};
        this.widget.addDisposeListener(listener);
        this.widget.removeDisposeListener(listener);
    }

    @Test
    public void test_addListenerILorg_eclipse_swt_widgets_Listener() {
        try {
            this.widget.addListener(12, null);
            Assert.fail((String)"No exception thrown for listener == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Listener listener = e -> {};
        this.widget.addListener(12, listener);
        this.widget.removeListener(12, listener);
    }

    @Test
    public void test_getDisplay() {
        Assert.assertEquals((Object)this.widget.getDisplay(), (Object)this.widget.getDisplay());
    }

    @Test
    public void test_isDisposed() {
        Assert.assertFalse((boolean)this.widget.isDisposed());
    }

    @Test
    public void test_notifyListenersILorg_eclipse_swt_widgets_Event() {
        this.widget.notifyListeners(0, null);
        Event event = new Event();
        GC gc = null;
        if (this.widget instanceof Control) {
            gc = event.gc = new GC((Drawable)((Control)this.widget));
        }
        this.widget.notifyListeners(9, event);
        if (gc != null) {
            gc.dispose();
        }
    }

    @Test
    public void test_removeListenerILorg_eclipse_swt_widgets_Listener() {
        try {
            this.widget.removeListener(9, null);
            Assert.fail((String)"No exception thrown for listener == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.widget.removeListener(9, e -> {});
        Listener listener = e -> {};
        this.widget.addListener(9, listener);
        this.widget.removeListener(9, listener);
    }

    @Test
    public void test_setDataLjava_lang_Object() {
        this.widget.setData((Object)this.widget);
        Assert.assertEquals((Object)this.widget, (Object)this.widget.getData());
        this.widget.setData(null);
        Assert.assertNull((Object)this.widget.getData());
    }

    @Test
    public void test_setDataLjava_lang_StringLjava_lang_Object() {
        this.widget.setData("the widget", (Object)this.widget);
        Assert.assertEquals((Object)this.widget, (Object)this.widget.getData("the widget"));
        this.widget.setData("the widget", null);
        Assert.assertNull((Object)this.widget.getData("the widget"));
        try {
            this.widget.setData(null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_toString() {
        Assert.assertNotNull((Object)this.widget.toString());
        Assert.assertTrue((this.widget.toString().length() > 0 ? 1 : 0) != 0);
    }

    protected void setWidget(Widget w) {
        this.widget = w;
    }

    protected void hookListeners(Widget w, int[] types, Listener listener) {
        int[] nArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            w.addListener(type, listener);
            ++n2;
        }
    }

    protected String[] hookExpectedEvents(String type, List<String> events) {
        return this.hookExpectedEvents(this.widget, type, events);
    }

    protected String[] hookExpectedEvents(Widget w, String type, List<String> events) {
        String[] expectedEvents = ConsistencyUtility.eventOrdering.get(type);
        this.hookExpectedEvents(w, expectedEvents, events);
        return expectedEvents;
    }

    protected void hookExpectedEvents(Widget w, String[] types, List<String> events) {
        this.hookListeners(w, ConsistencyUtility.convertEventNames(types), e -> {
            Object temp = ConsistencyUtility.eventNames[e.type];
            if (e.type == 31) {
                temp = (String)temp + ":" + ConsistencyUtility.getTraversalType(e.detail);
            } else if (e.type == 13) {
                temp = (String)temp + ":" + ConsistencyUtility.getSelectionType(e.detail);
            }
            events.add((String)temp);
            System.out.println((String)temp + String.valueOf(e.widget));
        });
    }

    protected String getTestName() {
        Object test = this.name.getMethodName();
        int index = ((String)test).lastIndexOf(95);
        if (index != -1) {
            test = ((String)test).substring(index + 1);
        }
        String clss = this.getClassName();
        if ((!((String)test).equals("MenuDetect") || clss.equals("Table") || ((String)test).startsWith("Chevron")) && (!((String)test).equals("DragDetect") || clss.equals("Tree") || ((String)test).startsWith("Chevron")) && (!((String)test).equals("DoubleClick") || clss.equals("List")) && (!((String)test).equals("KeySelection") || clss.equals("Slider") || clss.equals("Combo") || clss.equals("CCombo") || clss.equals("CTabFolder")) && (!((String)test).equals("EnterSelection") || clss.equals("Button") || clss.equals("ToolBar") || clss.equals("CCombo") || clss.equals("ExpandBar"))) {
            test = clss + (String)test;
        }
        return test;
    }

    protected String getClassName() {
        String clazz = this.getClass().getName();
        int index = clazz.lastIndexOf(95);
        if (index != -1) {
            clazz = clazz.substring(index + 1);
        }
        return clazz;
    }

    protected void render(Shell shell, int durationMs) throws InterruptedException {
        long timestamp = System.currentTimeMillis();
        shell.pack();
        shell.layout();
        shell.setVisible(true);
        while (System.currentTimeMillis() - timestamp < (long)durationMs) {
            if (shell.getDisplay().readAndDispatch()) continue;
            Thread.sleep(50L);
        }
    }

    protected void assertNotExists(Widget[] widgetTable, Widget w) {
        Widget[] widgetArray = widgetTable;
        int n = widgetTable.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            if (widget == w) {
                Assert.fail((String)("Widget table leaks: " + String.valueOf(w)));
            }
            ++n2;
        }
    }

    protected static Widget[] getWidgetTable(Display display) {
        try {
            Field field = Display.class.getDeclaredField("widgetTable");
            field.setAccessible(true);
            Widget[] widgetTable = (Widget[])field.get(display);
            return widgetTable;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

