/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit.performance;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.swt.widgets.Display;

public class BenchmarkSwtMultithreading {
    private static final int BATCH_SIZE = 1000000;
    static AtomicInteger countdown = new AtomicInteger();

    public static void main(String[] args) throws InterruptedException {
        Display display = new Display();
        try {
            int runs = 0;
            while (runs < 100) {
                countdown.set(1000000);
                AtomicLong schedulingNanos = new AtomicLong();
                Thread thread = new Thread(() -> schedulingNanos.set(new BenchmarkSwtMultithreading().scheduleAsyncEvents()), "test");
                thread.start();
                thread.join();
                long nanoTime = System.nanoTime();
                while (countdown.get() > 0) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                long nanoTime2 = System.nanoTime();
                long durationNanos = nanoTime2 - nanoTime;
                System.out.println("Duration for scheduling: " + String.format("%,15d", schedulingNanos.get()) + " ns  handling: " + String.format("%,15d", durationNanos) + " ns");
                ++runs;
            }
        }
        finally {
            display.dispose();
        }
    }

    public long scheduleAsyncEvents() {
        long nanoTime = System.nanoTime();
        Display display = Display.getDefault();
        int i = 0;
        while (i < 1000000) {
            display.asyncExec(() -> {
                Display.getCurrent();
                countdown.decrementAndGet();
            });
            ++i;
        }
        long nanoTime2 = System.nanoTime();
        long durationNanos = nanoTime2 - nanoTime;
        return durationNanos;
    }
}

