/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit.performance;

import org.eclipse.swt.SWT;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;

public class SwtPerformanceTestCase {
    public static final boolean isGTK = SWT.getPlatform().equals("gtk");
    public static final boolean isWindows = SWT.getPlatform().startsWith("win32");

    protected PerformanceMeter createMeter(String id) {
        Performance performance = Performance.getDefault();
        String scenarioId = "org.eclipse.swt.test." + id;
        PerformanceMeter meter = performance.createPerformanceMeter(scenarioId);
        performance.tagAsSummary(meter, id, Dimension.ELAPSED_PROCESS);
        return meter;
    }

    protected PerformanceMeter createMeterWithoutSummary(String id) {
        Performance performance = Performance.getDefault();
        String scenarioId = "org.eclipse.swt.test." + id;
        PerformanceMeter meter = performance.createPerformanceMeter(scenarioId);
        return meter;
    }

    protected void disposeMeter(PerformanceMeter meter) {
        try {
            meter.commit();
            Performance.getDefault().assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }
}

