/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit.performance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Test_org_eclipse_swt_widgets_Tree {
    @Rule
    public final TestName name = new TestName();
    private final boolean virtual;
    private final Shape shape;
    private final Shell shell = new Shell();
    private final Font font = new Font((Device)this.shell.getDisplay(), "Arial", 5, 5);
    private final Color foreground = this.shell.getDisplay().getSystemColor(5);
    private final Color background = this.shell.getDisplay().getSystemColor(2);
    private final AtomicLong itemCount = new AtomicLong(0L);

    @Parameterized.Parameters(name="Shape: {0}, virtual: {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({Shape.STAR, false}, {Shape.STAR, true}, {Shape.BINARY, false}, {Shape.BINARY, true});
    }

    public Test_org_eclipse_swt_widgets_Tree(Shape shape, boolean virtual) {
        this.shape = Objects.requireNonNull(shape);
        this.virtual = virtual;
    }

    @Before
    public void setUp() {
        this.shell.setSize(500, 500);
        this.shell.setLayout((Layout)new FillLayout());
        SwtTestUtil.openShell(this.shell);
    }

    @After
    public void teardown() {
        this.font.dispose();
        this.shell.dispose();
    }

    @Test
    public void build() {
        this.assertMaximumDegree(1.1, n -> this.measureNanos(() -> {
            Tree tree = this.buildSubject(n, this::initializeItem);
        }));
    }

    @Test
    public void traverse() {
        this.assertMaximumDegree(2.1, n -> {
            Tree tree = this.buildSubject(n, this::initializeItem);
            return this.measureNanos(() -> {
                int[] count = new int[1];
                this.breadthFirstTraverse(tree, item -> {
                    int n = count[0];
                    int n2 = n;
                    nArray[0] = n + 1;
                });
                Assert.assertEquals((long)n, (long)count[0]);
            });
        });
    }

    @Test
    public void secondTraverse() {
        this.assertMaximumDegree(1.2, n -> {
            Tree tree = this.buildSubject(n, this::initializeItem);
            this.breadthFirstTraverse(tree, item -> item.setExpanded(true));
            return this.measureNanos(() -> this.breadthFirstTraverse(tree, item -> {}));
        });
    }

    @Test
    public void dispose() {
        this.assertMaximumDegree(1.2, n -> {
            Tree tree = this.buildSubject(n, this::initializeItem);
            this.breadthFirstTraverse(tree, item -> item.setExpanded(true));
            return this.measureNanos(() -> tree.dispose());
        });
    }

    @Test
    public void getForeground() {
        this.assertMaximumDegree(1.2, n -> {
            Tree tree = this.buildSubject(n, this::initializeItem);
            this.breadthFirstTraverse(tree, item -> item.setExpanded(true));
            return this.measureNanos(() -> this.breadthFirstTraverse(tree, TreeItem::getForeground));
        });
    }

    @Test
    public void setForeground() {
        this.assertMaximumDegree(1.3, n -> {
            Tree tree = this.buildSubject(n, this::initializeItem);
            this.breadthFirstTraverse(tree, item -> item.setExpanded(true));
            Color cyan = this.shell.getDisplay().getSystemColor(13);
            return this.measureNanos(() -> this.breadthFirstTraverse(tree, item -> item.setForeground(cyan)));
        });
    }

    @Test
    public void setText() {
        this.assertMaximumDegree(1.3, n -> {
            Tree tree = this.buildSubject(n, this::initializeItem);
            this.breadthFirstTraverse(tree, item -> item.setExpanded(true));
            return this.measureNanos(() -> this.breadthFirstTraverse(tree, item -> item.setText("test")));
        });
    }

    @Test
    public void showItem() {
        this.assertMaximumDegree(this.virtual ? 1.2 : 1.9, n -> {
            Tree tree = this.buildSubject(n, this::initializeItem);
            return this.measureNanos(() -> tree.showItem(this.shape.lastItem(tree)));
        });
    }

    @Test
    public void jfaceReveal() {
        this.assertMaximumDegree(this.virtual ? 1.1 : 2.0, n -> {
            Tree tree = this.buildSubject(n, this::initializeItem);
            return this.measureNanos(() -> {
                TreeItem item = tree.getItem(tree.getItemCount() - 1);
                while (true) {
                    item.setExpanded(true);
                    int count = item.getItemCount();
                    if (this.virtual) {
                        item.getItems();
                        int i = 0;
                        while (i < count) {
                            item.getItem(i);
                            ++i;
                        }
                    }
                    if (count <= 0) break;
                    item = item.getItem(count - 1);
                }
                tree.showItem(item);
            });
        });
    }

    private Tree buildSubject(int size, Consumer<TreeItem> initialize) {
        Tree result = new Tree((Composite)this.shell, this.virtual ? 0x10000000 : 0);
        this.shell.layout();
        result.setRedraw(false);
        this.shape.buildTree(result, size, initialize);
        result.setRedraw(true);
        return result;
    }

    private void assertMaximumDegree(double maximumDegree, IntFunction<Double> function) {
        this.shell.setText(this.name.getMethodName());
        this.clearShell();
        int[] elementCount = new int[]{10000, 100000};
        function.apply(elementCount[0]);
        this.clearShell();
        double[] elapsed = new double[]{function.apply(elementCount[0]), 0.0};
        this.clearShell();
        elapsed[1] = function.apply(elementCount[1]);
        double ratio = elapsed[1] / (double)elementCount[1] / elapsed[0] * (double)elementCount[0];
        double degree = Math.log(elapsed[1] / elapsed[0]) / Math.log(elementCount[1] / elementCount[0]);
        String error = String.format("Execution time should grow as %f degree polynom. \nTime for %d elements: %f ns\nTime for %d elements: %f ns\nRatio: %f\nDegree: %f\n", maximumDegree, elementCount[0], elapsed[0], elementCount[1], elapsed[1], ratio, degree);
        System.out.println(this.name.getMethodName() + "\n" + error);
        Assert.assertTrue((String)error, (elapsed[1] <= 100.0 && elapsed[0] <= 100.0 || degree < maximumDegree ? 1 : 0) != 0);
    }

    private double measureNanos(Runnable runnable) {
        SwtTestUtil.processEvents();
        long start = System.nanoTime();
        runnable.run();
        SwtTestUtil.processEvents();
        long stop = System.nanoTime();
        return stop - start;
    }

    private void initializeItem(TreeItem item) {
        item.setText("" + this.itemCount.getAndIncrement());
        item.setForeground(this.foreground);
        item.setBackground(this.background);
        item.setFont(this.font);
    }

    private void clearShell() {
        Control[] controlArray = this.shell.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        assert (this.shell.getChildren().length == 0);
        this.itemCount.set(0L);
        SwtTestUtil.processEvents();
    }

    private void breadthFirstTraverse(Tree tree, Consumer<TreeItem> visitor) {
        tree.setRedraw(false);
        try {
            LinkedList<TreeItem> queue = new LinkedList<TreeItem>();
            queue.addAll(Arrays.asList(tree.getItems()));
            while (!queue.isEmpty()) {
                TreeItem parent = (TreeItem)queue.removeFirst();
                visitor.accept(parent);
                queue.addAll(Arrays.asList(parent.getItems()));
            }
        }
        finally {
            tree.setRedraw(true);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Shape {
        BINARY{

            @Override
            void buildTree(Tree tree, int size, Consumer<TreeItem> initializeItem) {
                boolean virtual;
                tree.setItemCount(2);
                int leftChildCount = size / 2;
                tree.getItem(0).setData("childCount", (Object)(leftChildCount - 1));
                tree.getItem(1).setData("childCount", (Object)(size - leftChildCount - 1));
                boolean bl = virtual = (tree.getStyle() & 0x10000000) != 0;
                if (virtual) {
                    tree.addListener(36, event -> {
                        TreeItem item = (TreeItem)event.item;
                        initializeItem.accept(item);
                        this.createBinaryChildren(item, initializeItem);
                    });
                } else {
                    this.createBinaryBranch(tree.getItem(0), initializeItem);
                    this.createBinaryBranch(tree.getItem(1), initializeItem);
                }
            }

            private void createBinaryBranch(TreeItem item, Consumer<TreeItem> initializeItem) {
                initializeItem.accept(item);
                for (TreeItem child : this.createBinaryChildren(item, initializeItem)) {
                    this.createBinaryBranch(child, initializeItem);
                }
            }

            @Override
            protected TreeItem lastItem(Tree tree) {
                return this.lastItem(tree.getItem(1));
            }

            private List<TreeItem> createBinaryChildren(TreeItem item, Consumer<TreeItem> initializeItem) {
                int childCount = (Integer)item.getData("childCount");
                int leftChildCount = childCount / 2;
                int rightChildCount = childCount - leftChildCount;
                ArrayList<TreeItem> result = new ArrayList<TreeItem>();
                if (leftChildCount > 0) {
                    TreeItem left = new TreeItem(item, 0);
                    left.setData("childCount", (Object)(leftChildCount - 1));
                    result.add(left);
                }
                if (rightChildCount > 0) {
                    TreeItem right = new TreeItem(item, 0);
                    right.setData("childCount", (Object)(rightChildCount - 1));
                    result.add(right);
                }
                return result;
            }

            private TreeItem lastItem(TreeItem item) {
                TreeItem[] children = item.getItems();
                if (children.length == 0) {
                    return item;
                }
                return this.lastItem(children[children.length - 1]);
            }
        }
        ,
        STAR{

            @Override
            void buildTree(Tree tree, int size, Consumer<TreeItem> initializeItem) {
                if ((tree.getStyle() & 0x10000000) != 0) {
                    tree.addListener(36, event -> {
                        TreeItem item = (TreeItem)event.item;
                        initializeItem.accept(item);
                        if (item.getParentItem() == null) {
                            item.setItemCount(size - 1);
                        }
                    });
                    tree.setItemCount(1);
                } else {
                    tree.setItemCount(1);
                    TreeItem root = tree.getItem(0);
                    initializeItem.accept(root);
                    root.setItemCount(size - 1);
                    TreeItem[] treeItemArray = root.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        initializeItem.accept(item);
                        ++n2;
                    }
                }
            }

            @Override
            protected TreeItem lastItem(Tree tree) {
                TreeItem root = tree.getItem(0);
                return root.getItem(tree.getItemCount() - 1);
            }
        };


        abstract void buildTree(Tree var1, int var2, Consumer<TreeItem> var3);

        protected abstract TreeItem lastItem(Tree var1);
    }
}

