/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit.performance;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.tests.junit.performance.SwtPerformanceTestCase;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class Test_situational
extends SwtPerformanceTestCase {
    Display display;

    @Before
    public void setUp() {
        this.display = Display.getDefault();
    }

    @Test
    public void test_createComposites() {
        int j;
        Composite c;
        int i;
        Shell shell;
        Assume.assumeFalse((String)"https://github.com/eclipse-platform/eclipse.platform.swt/issues/912 Very slow on Mac OS", (boolean)"gtk".equalsIgnoreCase("cocoa"));
        PerformanceMeter meter = this.createMeter("Create composites");
        Performance.getDefault();
        int samples = 0;
        while (samples < 2) {
            shell = new Shell(this.display);
            i = 0;
            while (i < 100) {
                c = new Composite((Composite)shell, 0);
                j = 0;
                while (j < 10) {
                    new Composite(c, 0);
                    ++j;
                }
                ++i;
            }
            shell.dispose();
            while (this.display.readAndDispatch()) {
            }
            ++samples;
        }
        samples = 0;
        while (samples < 100) {
            shell = new Shell(this.display);
            meter.start();
            i = 0;
            while (i < 100) {
                c = new Composite((Composite)shell, 0);
                j = 0;
                while (j < 50) {
                    new Composite(c, 0);
                    ++j;
                }
                ++i;
            }
            meter.stop();
            shell.dispose();
            while (this.display.readAndDispatch()) {
            }
            ++samples;
        }
        this.disposeMeter(meter);
    }

    @Test
    public void test_createWidgets() {
        PerformanceMeter meter = this.createMeter("Create composites and widgets");
        Performance performance = Performance.getDefault();
        performance.tagAsGlobalSummary(meter, "Create composites and widgets", Dimension.ELAPSED_PROCESS);
        int samples = 0;
        while (samples < 10) {
            Shell shell = new Shell(this.display);
            shell.setLayout((Layout)new FillLayout());
            meter.start();
            int i = 0;
            while (i < 50) {
                Composite c = new Composite((Composite)shell, 0);
                int j = 0;
                while (j < 10) {
                    new Button(c, 8);
                    new Label(c, 0);
                    new Scale(c, 0);
                    new ProgressBar(c, 0);
                    new List(c, 0);
                    new Text(c, 4);
                    new Text(c, 2);
                    new Slider(c, 0);
                    new Tree(c, 0);
                    new Table(c, 0);
                    new TabFolder(c, 0);
                    new Group(c, 2048);
                    new Composite(c, 0);
                    ++j;
                }
                ++i;
            }
            meter.stop();
            shell.dispose();
            while (this.display.readAndDispatch()) {
            }
            ++samples;
        }
        this.disposeMeter(meter);
    }

    @Test
    public void test_layout() {
        PerformanceMeter meter = this.createMeter("Layout Composites");
        int samples = 0;
        while (samples < 10) {
            GridData data;
            Shell shell = new Shell(this.display);
            shell.setLayout((Layout)new GridLayout());
            Object curText = "";
            Shell parent = shell;
            int i = 0;
            while (i < 10) {
                Composite c = new Composite((Composite)parent, 2048);
                data = new GridData();
                data.horizontalAlignment = 4;
                data.verticalAlignment = 4;
                c.setLayoutData((Object)data);
                c.setLayout((Layout)new GridLayout(2, false));
                Composite c1 = new Composite(c, 2048);
                data = new GridData();
                data.horizontalAlignment = 4;
                data.verticalAlignment = 4;
                data.heightHint = 2;
                data.widthHint = 2;
                c1.setLayoutData((Object)data);
                Composite c2 = new Composite(c, 2048);
                data = new GridData();
                data.horizontalAlignment = 4;
                data.verticalAlignment = 4;
                data.heightHint = 2;
                data.widthHint = 2;
                c2.setLayoutData((Object)data);
                Composite c3 = new Composite(c, 2048);
                data = new GridData();
                data.horizontalAlignment = 4;
                data.verticalAlignment = 4;
                data.heightHint = 2;
                data.widthHint = 2;
                c3.setLayoutData((Object)data);
                Composite c4 = new Composite(c, 2048);
                data = new GridData();
                data.horizontalAlignment = 4;
                data.verticalAlignment = 4;
                c4.setLayoutData((Object)data);
                c4.setLayout((Layout)new GridLayout());
                parent = c4;
                ++i;
            }
            Label changedLabel = new Label((Composite)parent, 0);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            changedLabel.setLayoutData((Object)data);
            shell.open();
            while (this.display.readAndDispatch()) {
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
            while (this.display.readAndDispatch()) {
            }
            meter.start();
            int numlayouts = 0;
            while (numlayouts < 20) {
                shell.layout(true);
                curText = "!!!" + (String)curText + "!!!\n!";
                changedLabel.setText((String)curText);
                ++numlayouts;
            }
            meter.stop();
            shell.dispose();
            while (this.display.readAndDispatch()) {
            }
            ++samples;
        }
        this.disposeMeter(meter);
    }

    @Test
    public void test_imageDrawing() {
        PerformanceMeter meter = this.createMeter("Draw on an image");
        int samples = 0;
        while (samples < 10) {
            int width = 640;
            int height = 480;
            Image image = new Image((Device)this.display, width, height);
            Color color1 = new Color(255, 0, 255);
            Color color2 = new Color(0, 255, 255);
            int x1 = 0;
            int y1 = height / 2;
            int x2 = width / 2;
            int y2 = 0;
            meter.start();
            GC gc = new GC((Drawable)image);
            int i = 0;
            while (i < 10000) {
                x1 = (x1 + 5) % width;
                y1 = (y1 + 5) % height;
                x2 = (x2 + 5) % width;
                y2 = (y2 + 5) % height;
                gc.setLineStyle(1);
                gc.drawLine(x1, y1, x2, y2);
                gc.setForeground((i & 1) == 0 ? color1 : color2);
                gc.setBackground((i & 1) == 0 ? color1 : color2);
                gc.fillRectangle(x1, y1, 200, 200);
                gc.drawRoundRectangle(x2, y2, 200, 200, 50, 50);
                gc.setLineStyle(4);
                gc.drawLine(x2, y1, x1, y2);
                ++i;
            }
            gc.dispose();
            meter.stop();
            image.dispose();
            while (this.display.readAndDispatch()) {
            }
            ++samples;
        }
        this.disposeMeter(meter);
    }

    @Test
    public void test_windowDrawing() {
        PerformanceMeter meter = this.createMeter("Draw on a window");
        Performance performance = Performance.getDefault();
        performance.setComment(meter, 1, "Regression due to a issue on the Releng test machine");
        int samples = 0;
        while (samples < 10) {
            int width = 640;
            int height = 480;
            Shell shell = new Shell(this.display);
            shell.setLayout((Layout)new GridLayout());
            Canvas c = new Canvas((Composite)shell, 0);
            GridData data = new GridData();
            data.widthHint = width;
            data.heightHint = height;
            c.setLayoutData((Object)data);
            shell.pack();
            shell.open();
            while (this.display.readAndDispatch()) {
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
            while (this.display.readAndDispatch()) {
            }
            Color color1 = new Color(255, 0, 255);
            Color color2 = new Color(0, 255, 255);
            int x1 = 0;
            int y1 = height / 2;
            int x2 = width / 2;
            int y2 = 0;
            meter.start();
            GC gc = new GC((Drawable)c);
            int i = 0;
            while (i < 6000) {
                x1 = (x1 + 5) % width;
                y1 = (y1 + 5) % height;
                x2 = (x2 + 5) % width;
                y2 = (y2 + 5) % height;
                gc.setLineStyle(1);
                gc.drawLine(x1, y1, x2, y2);
                gc.setForeground((i & 1) == 0 ? color1 : color2);
                gc.setBackground((i & 1) == 0 ? color1 : color2);
                gc.fillRectangle(x1, y1, 200, 200);
                gc.drawRoundRectangle(x2, y2, 200, 200, 50, 50);
                gc.setLineStyle(4);
                gc.drawLine(x2, y1, x1, y2);
                ++i;
            }
            gc.dispose();
            meter.stop();
            shell.dispose();
            while (this.display.readAndDispatch()) {
            }
            ++samples;
        }
        this.disposeMeter(meter);
    }

    @Test
    public void test_stringDrawing() {
        PerformanceMeter meter = this.createMeterWithoutSummary("Draw strings using GC.drawText");
        int samples = 0;
        while (samples < 10) {
            int width = 640;
            int height = 480;
            Shell shell = new Shell(this.display);
            shell.setLayout((Layout)new GridLayout());
            Canvas c = new Canvas((Composite)shell, 0);
            GridData data = new GridData();
            data.widthHint = width;
            data.heightHint = height;
            c.setLayoutData((Object)data);
            shell.pack();
            shell.open();
            while (this.display.readAndDispatch()) {
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
            while (this.display.readAndDispatch()) {
            }
            Color color1 = new Color(255, 0, 255);
            Color color2 = new Color(0, 255, 255);
            Font font1 = new Font((Device)this.display, "Helvetica", 20, 0);
            Font font2 = new Font((Device)this.display, "Helvetica", 10, 1);
            String testString = "The quick \tbr&own SWT jum&ped foxily o\nver the lazy dog.";
            int x1 = 0;
            int y1 = height / 2;
            int x2 = width / 2;
            int y2 = 0;
            meter.start();
            GC gc = new GC((Drawable)c);
            int i = 0;
            while (i < 4000) {
                x1 = (x1 + 5) % width;
                y1 = (y1 + 5) % height;
                x2 = (x2 + 5) % width;
                y2 = (y2 + 5) % height;
                gc.setFont((i & 1) == 0 ? font1 : font2);
                gc.setForeground((i & 1) == 0 ? color1 : color2);
                gc.textExtent(testString);
                gc.drawText(testString, x2, y1);
                gc.drawText(testString, x2, y1 / 2, 9);
                gc.drawText(testString, x2, y2, true);
                ++i;
            }
            gc.dispose();
            meter.stop();
            shell.dispose();
            font1.dispose();
            font2.dispose();
            while (this.display.readAndDispatch()) {
            }
            ++samples;
        }
        this.disposeMeter(meter);
    }

    @Test
    public void test_fastStringDrawing() {
        PerformanceMeter meter = this.createMeterWithoutSummary("Draw strings using GC.drawString()");
        int samples = 0;
        while (samples < 10) {
            int width = 640;
            int height = 480;
            Shell shell = new Shell(this.display);
            shell.setLayout((Layout)new GridLayout());
            Canvas c = new Canvas((Composite)shell, 0);
            GridData data = new GridData();
            data.widthHint = width;
            data.heightHint = height;
            c.setLayoutData((Object)data);
            shell.pack();
            shell.open();
            while (this.display.readAndDispatch()) {
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
            while (this.display.readAndDispatch()) {
            }
            Color color1 = new Color(255, 0, 255);
            Color color2 = new Color(0, 255, 255);
            Font font1 = new Font((Device)this.display, "Helvetica", 20, 0);
            Font font2 = new Font((Device)this.display, "Helvetica", 10, 1);
            String testString = "The quick brown SWT jumped foxily over the lazy dog.";
            int x1 = 0;
            int y1 = height / 2;
            int x2 = width / 2;
            int y2 = 0;
            meter.start();
            GC gc = new GC((Drawable)c);
            int i = 0;
            while (i < 2000) {
                x1 = (x1 + 5) % width;
                y1 = (y1 + 5) % height;
                x2 = (x2 + 5) % width;
                y2 = (y2 + 5) % height;
                gc.setFont((i & 1) == 0 ? font1 : font2);
                gc.setForeground((i & 1) == 0 ? color1 : color2);
                gc.stringExtent(testString);
                gc.drawString(testString, x1, y2);
                gc.drawString(testString, x1, y1, true);
                ++i;
            }
            gc.dispose();
            meter.stop();
            shell.dispose();
            font1.dispose();
            font2.dispose();
            while (this.display.readAndDispatch()) {
            }
            ++samples;
        }
        this.disposeMeter(meter);
    }
}

