/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.urischeme.AutoRegisterSchemeHandlersJob;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.ISchemeInformation;
import org.eclipse.urischeme.IUriSchemeExtensionReader;
import org.eclipse.urischeme.IUriSchemeHandler;
import org.eclipse.urischeme.internal.registration.Scheme;
import org.eclipse.urischeme.internal.registration.SchemeInformation;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.prefs.BackingStoreException;

public class TestUnitAutoRegisterSchemeHandlersJob {
    private PreferenceMock preferenceNode;
    private OperatingSystemRegistrationMock osRegistration;
    private static final String HELLO_URI_SCHEME = "hello";
    private static final IScheme helloScheme = new Scheme("hello", "helloScheme");
    private static final String HELLO1_URI_SCHEME = "hello1";
    private static final IScheme hello1Scheme = new Scheme("hello1", "hello1Scheme");
    private static final boolean SUPPORTS_REGISTRATION = true;
    private static final boolean DOESNT_SUPPORT_REGISTRATION = false;

    @Test
    public void noSchemeDoesNothing() throws Exception {
        AutoRegisterSchemeHandlersJob job = this.createJob(Collections.emptyList(), "", Collections.emptyList(), true);
        job.run((IProgressMonitor)new NullProgressMonitor());
        Assert.assertNull((String)"Nothing should be written to preferences", (Object)this.preferenceNode.writtenValue);
        Assert.assertFalse((String)"Flush on preferences should not be called", (boolean)this.preferenceNode.flushed);
        Assert.assertNull((String)"No schemes should be registered", this.osRegistration.addedSchemes);
        Assert.assertNull((String)"No schemes should be un-registered", this.osRegistration.removedSchemes);
    }

    @Test
    public void noNewSchemeDoesNothing() throws Exception {
        AutoRegisterSchemeHandlersJob job = this.createJob(Arrays.asList(helloScheme), HELLO_URI_SCHEME, Collections.emptyList(), true);
        job.run((IProgressMonitor)new NullProgressMonitor());
        Assert.assertNull((String)"Nothing should be written to preferences", (Object)this.preferenceNode.writtenValue);
        Assert.assertFalse((String)"Flush on preferences should not be called", (boolean)this.preferenceNode.flushed);
        Assert.assertNull((String)"No schemes should be registered", this.osRegistration.addedSchemes);
        Assert.assertNull((String)"No schemes should be un-registered", this.osRegistration.removedSchemes);
    }

    @Test
    public void newSchemeRegistersNewScheme() throws Exception {
        SchemeInformation helloSchemeInfo = new SchemeInformation(helloScheme.getName(), helloScheme.getDescription());
        helloSchemeInfo.setHandled(true);
        SchemeInformation hello1SchemeInfo = new SchemeInformation(hello1Scheme.getName(), hello1Scheme.getDescription());
        hello1SchemeInfo.setHandled(false);
        List<ISchemeInformation> schemeInfos = Arrays.asList(hello1SchemeInfo);
        AutoRegisterSchemeHandlersJob job = this.createJob(Arrays.asList(helloScheme, hello1Scheme), HELLO_URI_SCHEME, schemeInfos, true);
        job.run((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"Wrong values written to preferences", (Object)(helloScheme.getName() + "," + hello1Scheme.getName()), (Object)this.preferenceNode.writtenValue);
        Assert.assertTrue((String)"Preferences not flushed", (boolean)this.preferenceNode.flushed);
        Assert.assertEquals((String)"Wrong schemes have been registered", (Object)hello1SchemeInfo, (Object)this.osRegistration.addedSchemes.iterator().next());
        Assert.assertTrue((String)"No schemes should be un-registered", (boolean)this.osRegistration.removedSchemes.isEmpty());
    }

    @Test
    public void newAlreadyRegisteredSchemeDoesNoting() throws Exception {
        SchemeInformation helloSchemeInfo = new SchemeInformation(helloScheme.getName(), helloScheme.getDescription());
        helloSchemeInfo.setHandled(true);
        SchemeInformation hello1SchemeInfo = new SchemeInformation(hello1Scheme.getName(), hello1Scheme.getDescription());
        hello1SchemeInfo.setHandled(true);
        ArrayList<ISchemeInformation> schemeInfos = new ArrayList<ISchemeInformation>();
        AutoRegisterSchemeHandlersJob job = this.createJob(Arrays.asList(helloScheme, hello1Scheme), HELLO_URI_SCHEME, schemeInfos, true);
        job.run((IProgressMonitor)new NullProgressMonitor());
        Assert.assertNull((String)"Nothing should be written to preferences", (Object)this.preferenceNode.writtenValue);
        Assert.assertFalse((String)"Flush on preferences should not be called", (boolean)this.preferenceNode.flushed);
        Assert.assertNull((String)"No schemes should be registered", this.osRegistration.addedSchemes);
        Assert.assertNull((String)"No schemes should be un-registered", this.osRegistration.removedSchemes);
    }

    @Test
    public void unregisteredSchemeThatWasAutoregisterdOnceDoesNotAutoregisterAgain() throws Exception {
        SchemeInformation helloSchemeInfo = new SchemeInformation(helloScheme.getName(), helloScheme.getDescription());
        helloSchemeInfo.setHandled(false);
        SchemeInformation hello1SchemeInfo = new SchemeInformation(hello1Scheme.getName(), hello1Scheme.getDescription());
        hello1SchemeInfo.setHandled(true);
        List<ISchemeInformation> schemeInfos = Arrays.asList(helloSchemeInfo, hello1SchemeInfo);
        AutoRegisterSchemeHandlersJob job = this.createJob(Arrays.asList(helloScheme, hello1Scheme), "hello,hello1", schemeInfos, true);
        job.run((IProgressMonitor)new NullProgressMonitor());
        Assert.assertNull((String)"Nothing should be written to preferences", (Object)this.preferenceNode.writtenValue);
        Assert.assertFalse((String)"Flush on preferences should not be called", (boolean)this.preferenceNode.flushed);
        Assert.assertNull((String)"No schemes should be registered", this.osRegistration.addedSchemes);
        Assert.assertNull((String)"No schemes should be un-registered", this.osRegistration.removedSchemes);
    }

    @Test
    public void registrationOnUnsupportedRegistrationDoesNothing() throws Exception {
        AutoRegisterSchemeHandlersJob job = this.createJob(new ArrayList<IScheme>(), "dontCare", new ArrayList<ISchemeInformation>(), false);
        Assert.assertFalse((String)"Job should not run on OSes that don't support registration", (boolean)job.shouldSchedule());
    }

    private AutoRegisterSchemeHandlersJob createJob(Collection<IScheme> installedSchemes, String alreadyProcessedSchemes, List<ISchemeInformation> registeredSchemes, boolean supportsRegistration) {
        ExtensionReaderStub extensionReader = new ExtensionReaderStub(installedSchemes);
        this.osRegistration = new OperatingSystemRegistrationMock(registeredSchemes, supportsRegistration);
        this.preferenceNode = new PreferenceMock();
        this.preferenceNode.currentValue = alreadyProcessedSchemes;
        return new AutoRegisterSchemeHandlersJob((IEclipsePreferences)this.preferenceNode, (IUriSchemeExtensionReader)extensionReader, (IOperatingSystemRegistration)this.osRegistration);
    }

    private static final class ExtensionReaderStub
    implements IUriSchemeExtensionReader {
        public Collection<IScheme> schemes;

        public ExtensionReaderStub(Collection<IScheme> schemes) {
            this.schemes = schemes;
        }

        public Collection<IScheme> getSchemes() {
            return this.schemes;
        }

        public IUriSchemeHandler getHandlerFromExtensionPoint(String uriScheme) {
            return null;
        }
    }

    private static final class OperatingSystemRegistrationMock
    implements IOperatingSystemRegistration {
        private final List<ISchemeInformation> schemeInformations;
        public Collection<IScheme> addedSchemes = null;
        public Collection<IScheme> removedSchemes = null;
        public boolean supportsRegistration;

        public OperatingSystemRegistrationMock(List<ISchemeInformation> schemeInformations, boolean supportsRegistration) {
            this.schemeInformations = schemeInformations;
            this.supportsRegistration = supportsRegistration;
        }

        public void handleSchemes(Collection<IScheme> toAdd, Collection<IScheme> toRemove) throws Exception {
            this.addedSchemes = toAdd;
            this.removedSchemes = toRemove;
        }

        public List<ISchemeInformation> getSchemesInformation(Collection<IScheme> schemes) throws Exception {
            return this.schemeInformations;
        }

        public String getEclipseLauncher() {
            return "";
        }

        public boolean canOverwriteOtherApplicationsRegistration() {
            return false;
        }

        public boolean supportsRegistration() {
            return this.supportsRegistration;
        }
    }

    private static final class PreferenceMock
    extends EclipsePreferences {
        private static final String PROCESSED_SCHEMES_PREFERENCE = "processedSchemes";
        public boolean flushed = false;
        public String writtenValue;
        public String currentValue;

        private PreferenceMock() {
        }

        public String get(String key, String defaultValue) {
            if (PROCESSED_SCHEMES_PREFERENCE.equals(key)) {
                return this.currentValue;
            }
            throw new IllegalArgumentException("Wrong key provided");
        }

        public void put(String key, String newValue) {
            if (!PROCESSED_SCHEMES_PREFERENCE.equals(key)) {
                throw new IllegalArgumentException("Wrong key provided");
            }
            this.writtenValue = newValue;
        }

        public void flush() throws BackingStoreException {
            this.flushed = true;
        }
    }
}

