/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.internal.UriSchemeExtensionReader;
import org.eclipse.urischeme.internal.UriSchemeHandlerSpy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UriSchemeExtensionReaderUnitTest {
    private UriSchemeHandlerSpy abcHandler;
    private ConfigurationElementMock configElementForAbc;
    private UriSchemeExtensionReader extensionReader;

    @Before
    public void setup() throws Exception {
        this.abcHandler = new UriSchemeHandlerSpy();
        this.configElementForAbc = new ConfigurationElementMock("abc", "abc Scheme", this.abcHandler);
        this.extensionReader = new UriSchemeExtensionReader();
        this.setExtensionsInReader(this.configElementForAbc);
    }

    @Test
    public void returnsRegisteredHandler() throws Exception {
        Assert.assertEquals((Object)this.abcHandler, (Object)this.extensionReader.getHandlerFromExtensionPoint("abc"));
    }

    @Test
    public void doesntReturnHandlerForUnregisteredScheme() throws Exception {
        Assert.assertNull((Object)this.extensionReader.getHandlerFromExtensionPoint("xyz"));
    }

    @Test
    public void callsFirstOfTwoHandlersForSameScheme() throws Exception {
        ConfigurationElementMock second = new ConfigurationElementMock("abc", "abc Scheme", new UriSchemeHandlerSpy());
        this.setExtensionsInReader(this.configElementForAbc, second);
        Assert.assertEquals((Object)this.abcHandler, (Object)this.extensionReader.getHandlerFromExtensionPoint("abc"));
    }

    @Test(expected=CoreException.class)
    public void throwExceptionOnWrongRegisteredType() throws Exception {
        ConfigurationElementMock element = new ConfigurationElementMock("abc", "abc Scheme", new Object());
        this.setExtensionsInReader(element);
        this.extensionReader.getHandlerFromExtensionPoint("abc");
    }

    @Test
    public void returnsAllRegisteredSchemes() throws Exception {
        ConfigurationElementMock element1 = new ConfigurationElementMock("abc", "abc Scheme", new Object());
        ConfigurationElementMock element2 = new ConfigurationElementMock("xyz", "xyz Scheme", new Object());
        this.setExtensionsInReader(element1, element2);
        Collection schemes = this.extensionReader.getSchemes();
        Assert.assertEquals((long)2L, (long)schemes.size());
        IScheme[] schemesArray = schemes.toArray(new IScheme[0]);
        Assert.assertEquals((Object)"abc", (Object)schemesArray[0].getName());
        Assert.assertEquals((Object)"abc Scheme", (Object)schemesArray[0].getDescription());
        Assert.assertEquals((Object)"xyz", (Object)schemesArray[1].getName());
        Assert.assertEquals((Object)"xyz Scheme", (Object)schemesArray[1].getDescription());
    }

    private void setExtensionsInReader(IConfigurationElement ... element) throws Exception {
        this.extensionReader.configurationElements = element;
    }

    private static final class ConfigurationElementMock
    implements IConfigurationElement {
        private final String uriScheme;
        private final String uriSchemeDescription;
        private final Object handler;

        private ConfigurationElementMock(String uriScheme, String uriSchemeDescription, Object handler) {
            this.uriScheme = uriScheme;
            this.uriSchemeDescription = uriSchemeDescription;
            this.handler = handler;
        }

        public boolean isValid() {
            return false;
        }

        public String getValueAsIs() throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue(String locale) throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue() throws InvalidRegistryObjectException {
            return null;
        }

        public Object getParent() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespace() throws InvalidRegistryObjectException {
            return null;
        }

        public String getName() throws InvalidRegistryObjectException {
            return null;
        }

        public int getHandleId() {
            return 0;
        }

        public IExtension getDeclaringExtension() throws InvalidRegistryObjectException {
            return null;
        }

        public IContributor getContributor() throws InvalidRegistryObjectException {
            return null;
        }

        public IConfigurationElement[] getChildren(String name) throws InvalidRegistryObjectException {
            return null;
        }

        public IConfigurationElement[] getChildren() throws InvalidRegistryObjectException {
            return null;
        }

        public String[] getAttributeNames() throws InvalidRegistryObjectException {
            return null;
        }

        public String getAttributeAsIs(String name) throws InvalidRegistryObjectException {
            return null;
        }

        public String getAttribute(String attrName, String locale) throws InvalidRegistryObjectException {
            return null;
        }

        public String getAttribute(String name) throws InvalidRegistryObjectException {
            if (name.equals("uriScheme")) {
                return this.uriScheme;
            }
            if (name.equals("uriSchemeDescription")) {
                return this.uriSchemeDescription;
            }
            return null;
        }

        public Object createExecutableExtension(String propertyName) throws CoreException {
            return propertyName.equals("class") ? this.handler : null;
        }
    }
}

