/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.IUriSchemeExtensionReader;
import org.eclipse.urischeme.IUriSchemeHandler;
import org.eclipse.urischeme.internal.UriSchemeHandlerSpy;
import org.eclipse.urischeme.internal.UriSchemeProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UriSchemeProcessorUnitTest {
    private UriSchemeHandlerSpy abcHandler;
    private UriSchemeProcessor schemeProcessor;
    private UriSchemeExtensionReaderMock extensionReader;

    @Before
    public void setup() throws Exception {
        this.abcHandler = new UriSchemeHandlerSpy();
        this.extensionReader = new UriSchemeExtensionReaderMock();
        this.extensionReader.registration.put("abc", this.abcHandler);
        this.schemeProcessor = new UriSchemeProcessor();
        this.schemeProcessor.reader = this.extensionReader;
    }

    @Test
    public void callsRegisteredUriSchemeHandler() throws Exception {
        this.schemeProcessor.handleUri("abc", "abc://test");
        String errorMsg = "Registered handler was not called for 'abc://test'";
        Assert.assertTrue((String)errorMsg, (boolean)this.abcHandler.uris.contains("abc://test"));
    }

    @Test
    public void doesntCallHandlerForUnregisteredScheme() throws Exception {
        this.schemeProcessor.handleUri("xyz", "xyz://test");
        Assert.assertTrue((boolean)this.abcHandler.uris.isEmpty());
    }

    @Test
    public void buffersExtensionAndCreatesThemOnlyOnce() throws Exception {
        this.schemeProcessor.handleUri("abc", "abc://test");
        this.schemeProcessor.handleUri("abc", "abc://test");
        Assert.assertEquals((long)2L, (long)this.abcHandler.uris.size());
        Assert.assertEquals((String)"Extension created more than once", (long)1L, (long)this.extensionReader.readCount.get("abc").intValue());
    }

    @Test(expected=CoreException.class)
    public void passesException() throws Exception {
        this.extensionReader.exception = new CoreException(Status.CANCEL_STATUS);
        this.schemeProcessor.handleUri("abc", "abc://test");
    }

    private static class UriSchemeExtensionReaderMock
    implements IUriSchemeExtensionReader {
        public CoreException exception;
        public Map<String, IUriSchemeHandler> registration = new HashMap<String, IUriSchemeHandler>();
        public Map<String, Integer> readCount = new HashMap<String, Integer>();

        private UriSchemeExtensionReaderMock() {
        }

        public Collection<IScheme> getSchemes() {
            return null;
        }

        public IUriSchemeHandler getHandlerFromExtensionPoint(String uriScheme) throws CoreException {
            if (this.exception != null) {
                throw this.exception;
            }
            this.readCount.putIfAbsent(uriScheme, 0);
            this.readCount.put(uriScheme, this.readCount.get(uriScheme) + 1);
            return this.registration.get(uriScheme);
        }
    }
}

