/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.urischeme.internal.registration.IFileProvider;

public class FileProviderMock
implements IFileProvider {
    Map<String, Object> readAnswers = new HashMap<String, Object>();
    Map<String, Boolean> fileExistsAnswers = new HashMap<String, Boolean>();
    Map<String, Boolean> isDirectoryAnswers = new HashMap<String, Boolean>();
    Map<URL, String> urlTosFilePaths = new HashMap<URL, String>();
    Map<String, Map<String, List<String>>> newDirectoryStreamAnswers = new HashMap<String, Map<String, List<String>>>();
    List<String> recordedReadPaths = new ArrayList<String>();
    String writePath = "not/written";
    byte[] writtenBytes;
    Writer writer;

    public List<String> readAllLines(String path) throws IOException {
        this.recordedReadPaths.add(path);
        Object answer = this.readAnswers.get(path);
        if (answer instanceof Exception) {
            this.readAnswers.remove(path);
            throw (IOException)answer;
        }
        return (List)answer;
    }

    public void write(String path, byte[] bytes) throws IOException {
        this.writePath = path;
        this.writtenBytes = bytes;
    }

    public Reader newReader(String path) throws IOException {
        this.recordedReadPaths.add(path);
        Object answer = this.readAnswers.get(path);
        if (answer instanceof Exception) {
            this.readAnswers.remove(path);
            throw (IOException)answer;
        }
        return (Reader)answer;
    }

    public Writer newWriter(String path) throws IOException {
        this.writePath = path;
        return this.writer;
    }

    public boolean fileExists(String path) {
        return this.fileExistsAnswers.get(path);
    }

    public boolean isDirectory(String path) {
        return this.isDirectoryAnswers.get(path);
    }

    public String getFilePath(URL url) {
        return this.urlTosFilePaths.get(url);
    }

    public DirectoryStream<Path> newDirectoryStream(final String dir, final String glob) throws IOException {
        return new DirectoryStream<Path>(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public Iterator<Path> iterator() {
                return FileProviderMock.this.newDirectoryStreamAnswers.get(dir).get(glob).stream().map(string -> Paths.get(string, new String[0])).iterator();
            }
        };
    }
}

