/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.urischeme.internal.registration.DesktopFileWriter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringContains;
import org.hamcrest.core.StringEndsWith;
import org.junit.Assert;
import org.junit.Test;

public class TestUnitDesktopFileWriter {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String NO_MIME = "";

    @Test
    public void addsOneScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", NO_MIME));
        writer.addScheme("adt");
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;"));
    }

    @Test
    public void addTwoSchemes() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", NO_MIME));
        writer.addScheme("adt");
        writer.addScheme("other");
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;x-scheme-handler/other;"));
    }

    @Test
    public void addsSecondToExistingScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.addScheme("other");
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;x-scheme-handler/other;"));
    }

    @Test
    public void doesntAddSchemeIfExisting() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.addScheme("adt");
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void addFailsOnIllegalScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.addScheme("&/%");
    }

    @Test
    public void removesScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.removeScheme("adt");
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.not(this.contains("MimeType")));
    }

    @Test
    public void removesFirstOfTwoSchemes() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;x-scheme-handler/other;"));
        writer.removeScheme("adt");
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/other;"));
    }

    @Test
    public void removesLastOfTwoSchemes() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;x-scheme-handler/other;"));
        writer.removeScheme("other");
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;"));
    }

    @Test
    public void removesSecondOfThreeSchemes() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;x-scheme-handler/other;x-scheme-handler/yetAnother;"));
        writer.removeScheme("other");
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;x-scheme-handler/yetAnother;"));
    }

    @Test
    public void removesNonExistingScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.removeScheme("other");
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeFailsOnIllegalScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.removeScheme("&/%");
    }

    @Test
    public void doesNothing() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.containsLine("MimeType=x-scheme-handler/adt;"));
    }

    @Test
    public void removesEmptyMimeType() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.removeScheme("adt");
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.not(this.contains("MimeType")));
    }

    @Test(expected=IllegalStateException.class)
    public void throwsExceptionOnEmptyDocument() {
        this.getWriterFor(Collections.emptyList());
    }

    @Test
    public void keepsComments() {
        String comment = "# comment=test";
        ArrayList<String> fileContent = new ArrayList<String>(this.fileContentWith("Exec=/usr/bin/eclipse %u", NO_MIME));
        fileContent.add(comment);
        DesktopFileWriter writer = this.getWriterFor(fileContent);
        MatcherAssert.assertThat((Object)new String(writer.getResult()), (Matcher)new StringEndsWith(comment));
    }

    @Test(expected=IllegalStateException.class)
    public void throwsExceptionOnNonPropertiesFile() {
        this.getWriterFor(Arrays.asList("foo=bar"));
    }

    @Test
    public void addsUriPlaceholderToExecLineWhenAddingScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse", NO_MIME));
        writer.addScheme("adt");
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.containsLine("Exec=/usr/bin/eclipse %u"));
    }

    @Test
    public void addsAddUriPlaceholderToExecLineWhenJustGettingResult() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse", NO_MIME));
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.containsLine("Exec=/usr/bin/eclipse %u"));
    }

    @Test
    public void addsAddUriPlaceholderToExecLineWhenRemovingScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse", "MimeType=x-scheme-handler/adt;"));
        writer.removeScheme("adt");
        MatcherAssert.assertThat((Object)new String(writer.getResult()), this.containsLine("Exec=/usr/bin/eclipse %u"));
    }

    @Test
    public void returnsTrueForRegisteredScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        Assert.assertTrue((boolean)writer.isRegistered("adt"));
        Assert.assertFalse((boolean)writer.isRegistered("other"));
    }

    @Test
    public void returnsFalseWhenNoSchemeIsRegistered() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", NO_MIME));
        Assert.assertFalse((boolean)writer.isRegistered("adt"));
        Assert.assertFalse((boolean)writer.isRegistered("other"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void isRegisteredFailsOnIllegalScheme() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        writer.isRegistered("&/%");
    }

    @Test
    public void keepsPropertiesOrder() {
        List<String> fileContent = this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;");
        DesktopFileWriter writer = this.getWriterFor(fileContent);
        String expected = String.join((CharSequence)LINE_SEPARATOR, fileContent);
        MatcherAssert.assertThat((Object)new String(writer.getResult()), (Matcher)new IsEqual((Object)expected));
    }

    @Test
    public void returnsMinimalDesktopFile() {
        List actual = DesktopFileWriter.getMinimalDesktopFileContent((String)"/home/myuser/Eclipse/eclipse/eclipse", (String)"MyProduct");
        List<String> expected = Arrays.asList("[Desktop Entry]", "Name=MyProduct", "Exec=/home/myuser/Eclipse/eclipse/eclipse", "NoDisplay=true", "Type=Application");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void returnsMinimalDesktopFileWithSpaceEscapedInLocation() {
        List actual = DesktopFileWriter.getMinimalDesktopFileContent((String)"/home/myuser/Eclipse/eclipse (copy)/eclipse", (String)"MyProduct");
        List<String> expected = Arrays.asList("[Desktop Entry]", "Name=MyProduct", "Exec=/home/myuser/Eclipse/eclipse\\ (copy)/eclipse", "NoDisplay=true", "Type=Application");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void returnsMinimalDesktopFileWithMultipleSpacesEscapedInLocation() {
        List actual = DesktopFileWriter.getMinimalDesktopFileContent((String)"/home/myuser/Eclipse/eclipse   (copy)/eclipse", (String)"MyProduct");
        List<String> expected = Arrays.asList("[Desktop Entry]", "Name=MyProduct", "Exec=/home/myuser/Eclipse/eclipse\\ \\ \\ (copy)/eclipse", "NoDisplay=true", "Type=Application");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void returnsExecutablePathWithoutParameter() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse %u", "MimeType=x-scheme-handler/adt;"));
        Assert.assertEquals((Object)"/usr/bin/eclipse", (Object)writer.getExecutableLocation());
    }

    @Test
    public void returnsUnescapedSpaceExecutablePathWithoutParameter() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse\\ (copy) %u", "MimeType=x-scheme-handler/adt;"));
        Assert.assertEquals((Object)"/usr/bin/eclipse (copy)", (Object)writer.getExecutableLocation());
    }

    @Test
    public void returnsUnescapedMultipleSpacesExecutablePathWithoutParameter() {
        DesktopFileWriter writer = this.getWriterFor(this.fileContentWith("Exec=/usr/bin/eclipse\\ \\ (copy) %u", "MimeType=x-scheme-handler/adt;"));
        Assert.assertEquals((Object)"/usr/bin/eclipse  (copy)", (Object)writer.getExecutableLocation());
    }

    private Matcher<String> containsLine(String line) {
        return AnyOf.anyOf((Matcher[])new Matcher[]{new StringContains(LINE_SEPARATOR + line + LINE_SEPARATOR), new StringContains(LINE_SEPARATOR + line)});
    }

    private Matcher<String> contains(String line) {
        return new StringContains(line);
    }

    private Matcher<String> not(Matcher<String> not) {
        return new IsNot(not);
    }

    private DesktopFileWriter getWriterFor(List<String> fileContent) {
        return new DesktopFileWriter(fileContent);
    }

    private List<String> fileContentWith(String execLine, String mimeTypeLine) {
        return Arrays.asList("[Desktop Entry]", "Encoding=UTF-8", "Name=Eclipse 4.4.1", "Comment=Eclipse Luna", execLine, "Icon=/opt/eclipse/icon.xpm", "Categories=Application;Development;Java;IDE", "Version=1.0", "Type=Application", "Terminal=0", mimeTypeLine);
    }
}

