/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.urischeme.internal.registration.PlistFileWriter;
import org.junit.Assert;
import org.junit.Test;

public class TestUnitPlistFileWriter {
    @Test
    public void addsOneScheme() {
        PlistFileWriter writer = this.getWriter();
        writer.addScheme("adt", "adtScheme");
        this.assertSchemesInOrder(writer, "adt");
    }

    @Test
    public void addsTwoSchemes() {
        PlistFileWriter writer = this.getWriter();
        writer.addScheme("adt", "adtScheme");
        writer.addScheme("other", "otherScheme");
        this.assertSchemesInOrder(writer, "adt", "other");
    }

    @Test
    public void addsOneSchemeToEmptyArray() {
        PlistFileWriter writer = this.getWriter();
        writer.addScheme("adt", "adtScheme");
        this.assertSchemesInOrder(writer, "adt");
    }

    @Test
    public void addsSecondToExistingScheme() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt");
        writer.addScheme("other", "otherScheme");
        this.assertSchemesInOrder(writer, "adt", "other");
    }

    @Test
    public void doesntAddSchemeIfExisting() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt");
        writer.addScheme("adt", "adtScheme");
        this.assertSchemesInOrder(writer, "adt");
    }

    @Test(expected=IllegalArgumentException.class)
    public void addFailsOnIllegalScheme() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt");
        writer.addScheme("&/%", "thisIsIllegal");
    }

    @Test
    public void doesntRemoveCommentAfterEndArrayTag() {
        String xml = this.getPlistStartXmlSnippet() + "\t<key>CFBundleURLTypes</key>\n\t\t<array>\n" + this.getSchemeXmlSnippet("other") + "\t\t</array>\n<!--comment-->\n" + this.getPlistEndXmlSnippet();
        PlistFileWriter writer = new PlistFileWriter(() -> new StringReader(xml));
        writer.addScheme("adt", "adtScheme");
        String expectedXml = this.getPlistStartXmlSnippet() + "\t<key>CFBundleURLTypes</key>\n\t\t<array>\n" + this.getSchemeXmlSnippet("other") + this.getSchemeXmlSnippet("adt") + "\t\t</array>\n<!--comment-->\n" + this.getPlistEndXmlSnippet();
        this.assertXml(expectedXml, writer);
    }

    @Test
    public void doesntRemoveCommentBeforeEndArrayTag() {
        String xml = this.getPlistStartXmlSnippet() + "\t<key>CFBundleURLTypes</key>\n\t\t<array>\n" + this.getSchemeXmlSnippet("other") + "<!--comment-->\t\t</array>\n" + this.getPlistEndXmlSnippet();
        PlistFileWriter writer = new PlistFileWriter(() -> new StringReader(xml));
        writer.addScheme("adt", "adtScheme");
        String expectedXml = this.getPlistStartXmlSnippet() + "\t<key>CFBundleURLTypes</key>\n\t\t<array>\n" + this.getSchemeXmlSnippet("other") + "<!--comment-->\n" + this.getSchemeXmlSnippet("adt") + "\t\t</array>\n" + this.getPlistEndXmlSnippet();
        this.assertXml(expectedXml, writer);
    }

    @Test
    public void removesScheme() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt");
        writer.removeScheme("adt");
        String expectedXml = this.getPlistStartXmlSnippet() + "\t\n\t\t\n" + this.getPlistEndXmlSnippet();
        this.assertXml(expectedXml, writer);
    }

    @Test
    public void removesFirstOfTwoSchemes() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt", "other");
        writer.removeScheme("adt");
        this.assertSchemesInOrder(writer, "other");
    }

    @Test
    public void removesLastOfTwoSchemes() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt", "other");
        writer.removeScheme("other");
        this.assertSchemesInOrder(writer, "adt");
    }

    @Test
    public void removesSecondOfThreeSchemes() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt", "other", "yetAnother");
        writer.removeScheme("other");
        this.assertSchemesInOrder(writer, "adt", "yetAnother");
    }

    @Test
    public void removesNonExistingScheme() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt");
        writer.removeScheme("other");
        this.assertSchemesInOrder(writer, "adt");
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeFailsOnIllegalScheme() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt");
        writer.removeScheme("&/%");
    }

    @Test
    public void doesNothing() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt");
        this.assertSchemesInOrder(writer, "adt");
    }

    @Test
    public void removesEmptyCFBundleURLTypesEntry() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt");
        writer.removeScheme("adt");
        String expectedXml = this.getPlistStartXmlSnippet() + "\t\n\t\t\n" + this.getPlistEndXmlSnippet();
        this.assertXml(expectedXml, writer);
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsExceptionOnEmptyDocument() {
        new PlistFileWriter(() -> new StringReader(""));
    }

    @Test(expected=IllegalStateException.class)
    public void throwsExceptionOnWrongPlistFile() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><plist version=\"1.0\"/>";
        new PlistFileWriter(() -> new StringReader(xml));
    }

    @Test(expected=IllegalStateException.class)
    public void throwsExceptionOnWrongXmlFile() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><foo/>";
        new PlistFileWriter(() -> new StringReader(xml));
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsExceptionOnNonXmlFile() {
        String xml = "foo bar";
        new PlistFileWriter(() -> new StringReader(xml));
    }

    @Test
    public void returnsTrueForRegisteredScheme() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt");
        Assert.assertTrue((boolean)writer.isRegisteredScheme("adt"));
        Assert.assertFalse((boolean)writer.isRegisteredScheme("other"));
    }

    @Test
    public void returnsFalseWhenNoSchemeIsRegistered() {
        PlistFileWriter writer = this.getWriter();
        Assert.assertFalse((boolean)writer.isRegisteredScheme("adt"));
        Assert.assertFalse((boolean)writer.isRegisteredScheme("other"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getRegisteredFailsOnIllegalScheme() {
        PlistFileWriter writer = this.getWriterWithSchemes("adt");
        writer.isRegisteredScheme("&/%");
    }

    private void assertSchemesInOrder(PlistFileWriter writer, String ... schemes) {
        this.assertXml(this.getXml(schemes), writer);
    }

    private void assertXml(String xml, PlistFileWriter writer) {
        StringWriter[] stringWriters = new StringWriter[1];
        writer.writeTo(() -> {
            stringWriterArray[0] = new StringWriter();
            return stringWriterArray[0];
        });
        Assert.assertEquals((Object)xml, (Object)stringWriters[0].toString().replaceAll("\r\n", "\n"));
    }

    private PlistFileWriter getWriter() {
        return new PlistFileWriter(() -> new StringReader(this.getXml()));
    }

    private PlistFileWriter getWriterWithSchemes(String ... schemes) {
        return new PlistFileWriter(() -> new StringReader(this.getXml(schemes)));
    }

    private String getXml() {
        return this.getPlistStartXmlSnippet() + this.getPlistEndXmlSnippet();
    }

    private String getXml(String[] schemes) {
        StringBuilder snippets = new StringBuilder();
        if (schemes != null) {
            String[] stringArray = schemes;
            int n = schemes.length;
            int n2 = 0;
            while (n2 < n) {
                String scheme = stringArray[n2];
                snippets.append(this.getSchemeXmlSnippet(scheme));
                ++n2;
            }
        }
        return this.getPlistStartXmlSnippet() + "\t<key>CFBundleURLTypes</key>\n\t\t<array>\n" + snippets.append("\t\t</array>\n").append(this.getPlistEndXmlSnippet()).toString();
    }

    private String getPlistStartXmlSnippet() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><plist version=\"1.0\">\n\n<dict>\n\t<key>CFBundleExecutable</key>\n\t\t<string>eclipse</string>\n\t<key>CFBundleGetInfoString</key>\n\t\t<string>Eclipse 4.8 for Mac OS X, Copyright IBM Corp. and others 2002, 2017. All rights reserved.</string>\n\t<key>CFBundleIconFile</key>\n\t\t<string>Eclipse.icns</string>\n\t<key>CFBundleIdentifier</key>\n\t\t<string>org.eclipse.sdk.ide</string>\n\t<key>CFBundleInfoDictionaryVersion</key>\n\t\t<string>6.0</string>\n\t<key>CFBundleName</key>\n\t\t<string>Eclipse</string>\n\t<key>CFBundlePackageType</key>\n\t\t<string>APPL</string>\n\t<key>CFBundleShortVersionString</key>\n\t\t<string>4.8.0</string>\n\t<key>CFBundleSignature</key>\n\t\t<string>????</string>\n\t<key>CFBundleVersion</key>\n\t\t<string>4.8.0.I20180516-2000</string>\n\t<key>NSHighResolutionCapable</key>\n\t\t<true/>\n\t<key>CFBundleDevelopmentRegion</key>\n\t\t<string>English</string>\t\t\n\t<key>Eclipse</key>\n\t\t<array>\n\t\t\t<!-- to use a specific Java version (instead of the platform's default) uncomment one of the following options,\n\t\t\t\t\tor add a VM found via $/usr/libexec/java_home -V\n\t\t\t\t<string>-vm</string><string>/System/Library/Java/JavaVirtualMachines/1.6.0.jdk/Contents/Commands/java</string>\n\t\t\t\t<string>-vm</string><string>/Library/Java/JavaVirtualMachines/1.8.0.jdk/Contents/Home/bin/java</string>\n\t\t\t-->\n\t\t\t<string>-keyring</string>\n\t\t\t<string>~/.eclipse_keyring</string>\n\t\t</array>\n\t<key>CFBundleDisplayName</key>\n\t\t<string>Eclipse</string>\n";
    }

    private String getPlistEndXmlSnippet() {
        return "</dict>\n\n</plist>";
    }

    private String getSchemeXmlSnippet(String scheme) {
        return "\t\t\t<dict>\n\t\t\t\t<key>CFBundleURLName</key>\n\t\t\t\t\t<string>" + scheme + "Scheme</string>\n\t\t\t\t<key>CFBundleURLSchemes</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<string>" + scheme + "</string>\n\t\t\t\t\t</array>\n\t\t\t</dict>\n";
    }
}

