/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.ISchemeInformation;
import org.eclipse.urischeme.internal.registration.FileProviderMock;
import org.eclipse.urischeme.internal.registration.IFileProvider;
import org.eclipse.urischeme.internal.registration.IProcessExecutor;
import org.eclipse.urischeme.internal.registration.ProcessSpy;
import org.eclipse.urischeme.internal.registration.RegistrationLinux;
import org.eclipse.urischeme.internal.registration.Scheme;
import org.eclipse.urischeme.internal.registration.SchemeInformation;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringContains;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUnitRegistrationLinux {
    private static final String PRODUCT_NAME = "myProduct";
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String ECLIPSE_LAUNCHER = "eclipse.launcher";
    private static final String ECLIPSE_HOME_LOCATION = "eclipse.home.location";
    private static final String OTHER_APP_EXECUTABLE_PATH = "/home/myuser/otherApp/app";
    private static final String OTHER_APP_DESKTOP_FILE = "otherApp.desktop";
    private static final String PATH_OTHER_APP_DESKTOP_FILE = USER_HOME + "/.local/share/applications/otherApp.desktop";
    private static final String OWN_EXECUTABLE_PATH = "/home/myuser/Eclipse/Eclipse";
    private static final String OWN_DESKTOP_FILE = "_home_myuser_Eclipse_.desktop";
    private static final String PATH_OWN_DESKTOP_FILE = USER_HOME + "/.local/share/applications/_home_myuser_Eclipse_.desktop";
    private static final IScheme ADT_SCHEME = new Scheme("adt", "");
    private static final ISchemeInformation OTHER_SCHEME_INFO = new SchemeInformation("other", "");
    private static final ISchemeInformation ADT_SCHEME_INFO = new SchemeInformation("adt", "");
    private static String originalEclipseHomeLocation;
    private static String originalEclipseLauncher;
    private IOperatingSystemRegistration registration;
    private FileProviderMock fileProvider;
    private ProcessSpy processStub;

    @Before
    public void setup() {
        this.fileProvider = new FileProviderMock();
        this.processStub = new ProcessSpy();
        System.setProperty(ECLIPSE_HOME_LOCATION, "file:/home/myuser/Eclipse/");
        System.setProperty(ECLIPSE_LAUNCHER, OWN_EXECUTABLE_PATH);
        this.registration = new RegistrationLinux((IFileProvider)this.fileProvider, (IProcessExecutor)this.processStub, PRODUCT_NAME);
    }

    @BeforeClass
    public static void classSetup() {
        originalEclipseHomeLocation = System.getProperty(ECLIPSE_HOME_LOCATION, "");
        originalEclipseLauncher = System.getProperty(ECLIPSE_LAUNCHER, "");
    }

    @AfterClass
    public static void classTearDown() {
        System.setProperty(ECLIPSE_HOME_LOCATION, originalEclipseHomeLocation);
        System.setProperty(ECLIPSE_LAUNCHER, originalEclipseLauncher);
    }

    @Test
    public void handlesAddOnly() throws Exception {
        this.fileProvider.readAnswers.put(PATH_OWN_DESKTOP_FILE, this.getFileLines(OWN_EXECUTABLE_PATH, ""));
        this.registration.handleSchemes(Arrays.asList(ADT_SCHEME_INFO), Collections.emptyList());
        this.assertFilePathIs(PATH_OWN_DESKTOP_FILE);
        this.assertMimeTypeInFileIs("x-scheme-handler/adt;");
        this.assertXdgMimeCalledFor("x-scheme-handler/adt");
    }

    @Test
    public void handlesAddAndRemoveAtOnce() throws Exception {
        this.fileProvider.readAnswers.put(PATH_OWN_DESKTOP_FILE, this.getFileLines(OWN_EXECUTABLE_PATH, "MimeType=x-scheme-handler/adt;"));
        this.registration.handleSchemes(Arrays.asList(OTHER_SCHEME_INFO), Arrays.asList(ADT_SCHEME_INFO));
        this.assertFilePathIs(PATH_OWN_DESKTOP_FILE);
        this.assertMimeTypeInFileIs("x-scheme-handler/other;");
        this.assertXdgMimeCalledFor("x-scheme-handler/other");
    }

    @Test
    public void handlesRemoveOnly() throws Exception {
        this.fileProvider.readAnswers.put(PATH_OWN_DESKTOP_FILE, this.getFileLines(OWN_EXECUTABLE_PATH, "MimeType=x-scheme-handler/adt;"));
        this.registration.handleSchemes(Collections.emptyList(), Arrays.asList(ADT_SCHEME_INFO));
        this.assertFilePathIs(PATH_OWN_DESKTOP_FILE);
        this.assertNoMimeTypeInFile();
        Assert.assertTrue((boolean)this.processStub.records.isEmpty());
    }

    @Test
    public void createsInitialDesktopFile() throws Exception {
        this.fileProvider.readAnswers.put(PATH_OWN_DESKTOP_FILE, new IOException("desktop file not existing"));
        this.registration.handleSchemes(Arrays.asList(ADT_SCHEME_INFO), Collections.emptyList());
        Assert.assertEquals((Object)PATH_OWN_DESKTOP_FILE, (Object)this.fileProvider.writePath);
        this.assertAppNameInFileIs(PRODUCT_NAME);
        this.assertMimeTypeInFileIs("x-scheme-handler/adt;");
        this.assertExecInFileIs("/home/myuser/Eclipse/Eclipse %u");
        this.assertXdgMimeCalledFor("x-scheme-handler/adt");
    }

    @Test
    public void callsXdgMimeOnceForAllSchemes() throws Exception {
        this.fileProvider.readAnswers.put(PATH_OWN_DESKTOP_FILE, this.getFileLines(OWN_EXECUTABLE_PATH, ""));
        this.registration.handleSchemes(Arrays.asList(ADT_SCHEME_INFO, OTHER_SCHEME_INFO), Collections.emptyList());
        this.assertFilePathIs(PATH_OWN_DESKTOP_FILE);
        this.assertMimeTypeInFileIs("x-scheme-handler/adt;x-scheme-handler/other;");
        this.assertXdgMimeCalledFor("x-scheme-handler/adt", "x-scheme-handler/other");
    }

    @Test
    public void returnsFallbackIfEclipseLauncherIsNotSet() throws Exception {
        System.clearProperty(ECLIPSE_LAUNCHER);
        String eclipseLauncher = this.registration.getEclipseLauncher();
        Assert.assertEquals((Object)"/home/myuser/Eclipse/eclipse", (Object)eclipseLauncher);
    }

    @Test
    public void givesSchemeInfoForHandledScheme() throws Exception {
        this.fileProvider.fileExistsAnswers.put(PATH_OWN_DESKTOP_FILE, true);
        this.fileProvider.readAnswers.put(PATH_OWN_DESKTOP_FILE, this.getFileLines(OWN_EXECUTABLE_PATH, "MimeType=x-scheme-handler/adt;"));
        this.processStub.result = OWN_DESKTOP_FILE;
        List registeredSchemes = this.registration.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)registeredSchemes.size());
        Assert.assertEquals((Object)"adt", (Object)((ISchemeInformation)registeredSchemes.get(0)).getName());
        Assert.assertTrue((String)"Scheme should be handled", (boolean)((ISchemeInformation)registeredSchemes.get(0)).isHandled());
    }

    @Test
    public void givesSchemeInfoForSchemeHandledByOtherApp() throws Exception {
        this.fileProvider.fileExistsAnswers.put(PATH_OTHER_APP_DESKTOP_FILE, true);
        this.fileProvider.readAnswers.put(PATH_OTHER_APP_DESKTOP_FILE, this.getFileLines(OTHER_APP_EXECUTABLE_PATH, "MimeType=x-scheme-handler/adt;"));
        this.processStub.result = OTHER_APP_DESKTOP_FILE;
        List infos = this.registration.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"adt", (Object)((ISchemeInformation)infos.get(0)).getName());
        Assert.assertFalse((boolean)((ISchemeInformation)infos.get(0)).isHandled());
        Assert.assertEquals((Object)OTHER_APP_EXECUTABLE_PATH, (Object)((ISchemeInformation)infos.get(0)).getHandlerInstanceLocation());
    }

    @Test
    public void givesSchemeInfoForSchemeHandledByOtherAppAndInOwnDesktopFile() throws Exception {
        this.fileProvider.fileExistsAnswers.put(PATH_OWN_DESKTOP_FILE, true);
        this.fileProvider.readAnswers.put(PATH_OWN_DESKTOP_FILE, this.getFileLines(OWN_EXECUTABLE_PATH, "MimeType=x-scheme-handler/adt;"));
        this.fileProvider.fileExistsAnswers.put(PATH_OTHER_APP_DESKTOP_FILE, true);
        this.fileProvider.readAnswers.put(PATH_OTHER_APP_DESKTOP_FILE, this.getFileLines(OTHER_APP_EXECUTABLE_PATH, "MimeType=x-scheme-handler/adt;"));
        this.processStub.result = OTHER_APP_DESKTOP_FILE;
        List infos = this.registration.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"adt", (Object)((ISchemeInformation)infos.get(0)).getName());
        Assert.assertFalse((boolean)((ISchemeInformation)infos.get(0)).isHandled());
        Assert.assertEquals((Object)OTHER_APP_EXECUTABLE_PATH, (Object)((ISchemeInformation)infos.get(0)).getHandlerInstanceLocation());
    }

    @Test
    public void givesSchemeInfoForSchemeNotHandledAnymoreButInXdgMimeForOtherApp() throws Exception {
        this.fileProvider.fileExistsAnswers.put(PATH_OTHER_APP_DESKTOP_FILE, true);
        this.fileProvider.fileExistsAnswers.put(PATH_OWN_DESKTOP_FILE, true);
        this.fileProvider.readAnswers.put(PATH_OWN_DESKTOP_FILE, this.getFileLines(OWN_EXECUTABLE_PATH, ""));
        this.fileProvider.readAnswers.put(PATH_OTHER_APP_DESKTOP_FILE, this.getFileLines(OTHER_APP_EXECUTABLE_PATH, ""));
        this.processStub.result = OTHER_APP_DESKTOP_FILE;
        List infos = this.registration.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"adt", (Object)((ISchemeInformation)infos.get(0)).getName());
        Assert.assertFalse((boolean)((ISchemeInformation)infos.get(0)).isHandled());
        Assert.assertEquals((Object)"", (Object)((ISchemeInformation)infos.get(0)).getHandlerInstanceLocation());
    }

    @Test
    public void givesSchemeInfoForSchemeNotHandledAnymoreDesktopFileNoLongerExistsButInXdgMimeForOtherApp() throws Exception {
        this.fileProvider.fileExistsAnswers.put(PATH_OTHER_APP_DESKTOP_FILE, false);
        this.fileProvider.fileExistsAnswers.put(PATH_OWN_DESKTOP_FILE, false);
        this.processStub.result = OTHER_APP_DESKTOP_FILE;
        List infos = this.registration.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"adt", (Object)((ISchemeInformation)infos.get(0)).getName());
        Assert.assertFalse((boolean)((ISchemeInformation)infos.get(0)).isHandled());
        Assert.assertEquals((Object)"", (Object)((ISchemeInformation)infos.get(0)).getHandlerInstanceLocation());
    }

    @Test
    public void givesSchemeInfoForSchemeNotHandledAnymoreButInXdgMimeForOwn() throws Exception {
        this.fileProvider.fileExistsAnswers.put(PATH_OWN_DESKTOP_FILE, true);
        this.fileProvider.readAnswers.put(PATH_OWN_DESKTOP_FILE, this.getFileLines(OWN_EXECUTABLE_PATH, ""));
        this.fileProvider.readAnswers.put(PATH_OTHER_APP_DESKTOP_FILE, this.getFileLines(OTHER_APP_EXECUTABLE_PATH, ""));
        this.processStub.result = OWN_DESKTOP_FILE;
        List infos = this.registration.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"adt", (Object)((ISchemeInformation)infos.get(0)).getName());
        Assert.assertFalse((boolean)((ISchemeInformation)infos.get(0)).isHandled());
        Assert.assertEquals((Object)"", (Object)((ISchemeInformation)infos.get(0)).getHandlerInstanceLocation());
    }

    @Test
    public void givesSchemeInfoForSchemeNotHandledAnymoreDesktopFileNoLongerExistsButInXdgMimeForOwn() throws Exception {
        this.fileProvider.fileExistsAnswers.put(PATH_OWN_DESKTOP_FILE, false);
        this.fileProvider.fileExistsAnswers.put(PATH_OTHER_APP_DESKTOP_FILE, false);
        this.processStub.result = OWN_DESKTOP_FILE;
        List infos = this.registration.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"adt", (Object)((ISchemeInformation)infos.get(0)).getName());
        Assert.assertFalse((boolean)((ISchemeInformation)infos.get(0)).isHandled());
        Assert.assertEquals((Object)"", (Object)((ISchemeInformation)infos.get(0)).getHandlerInstanceLocation());
    }

    private List<String> getFileLines(String exec, String mimeType) {
        return Arrays.asList("[Desktop Entry]", "Exec=" + exec, "NoDisplay=true", mimeType, "Type=Application");
    }

    private void assertFilePathIs(String filePath) {
        Assert.assertEquals((Object)filePath, (Object)this.fileProvider.recordedReadPaths.get(0));
        Assert.assertEquals((Object)filePath, (Object)this.fileProvider.writePath);
    }

    private void assertAppNameInFileIs(String name) {
        MatcherAssert.assertThat((Object)new String(this.fileProvider.writtenBytes), (Matcher)new StringContains("Name=" + name));
    }

    private void assertMimeTypeInFileIs(String mimeType) {
        MatcherAssert.assertThat((Object)new String(this.fileProvider.writtenBytes), (Matcher)new StringContains("MimeType=" + mimeType));
    }

    private void assertExecInFileIs(String exec) {
        MatcherAssert.assertThat((Object)new String(this.fileProvider.writtenBytes), (Matcher)new StringContains("Exec=" + exec));
    }

    private void assertNoMimeTypeInFile() {
        MatcherAssert.assertThat((Object)new String(this.fileProvider.writtenBytes), (Matcher)new IsNot((Matcher)new StringContains("MimeType=x-scheme-handler/adt;")));
    }

    private void assertXdgMimeCalledFor(String ... schemeHandler) {
        Assert.assertEquals((long)1L, (long)this.processStub.records.size());
        Assert.assertEquals((Object)"xdg-mime", (Object)this.processStub.records.get((int)0).process);
        String schemeHandlers = Arrays.stream(schemeHandler).collect(Collectors.joining(" "));
        Assert.assertArrayEquals((Object[])new String[]{"default", OWN_DESKTOP_FILE, schemeHandlers}, (Object[])this.processStub.records.get((int)0).args);
    }
}

