/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.ISchemeInformation;
import org.eclipse.urischeme.internal.registration.FileProviderMock;
import org.eclipse.urischeme.internal.registration.IFileProvider;
import org.eclipse.urischeme.internal.registration.IProcessExecutor;
import org.eclipse.urischeme.internal.registration.ProcessSpy;
import org.eclipse.urischeme.internal.registration.RegistrationMacOsX;
import org.eclipse.urischeme.internal.registration.Scheme;
import org.eclipse.urischeme.internal.registration.SchemeInformation;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringContains;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUnitRegistrationMacOsX {
    private static final String OWN_APP_PLIST_PATH = "/Users/myuser/Applications/Eclipse.app/Contents/Info.plist";
    private static final String PATH_TO_CODE_SIGNATURE = "/Users/myuser/Applications/Eclipse.app/Contents/_CodeSignature";
    private static final String OTHER_APP_PLIST_PATH = "/Users/myuser/Applications/OtherApp.app/Contents/Info.plist";
    private static final String OTHER_APP_BUNDLE_PATH = "/Users/myuser/Applications/OtherApp.app";
    private static final IScheme ADT_SCHEME = new Scheme("adt", "");
    private static final IScheme ADT_DEMO_SCHEME = new Scheme("adt+demo", "");
    private static final ISchemeInformation OTHER_SCHEME_INFO = new SchemeInformation("other", "");
    private static final ISchemeInformation ADT_SCHEME_INFO = new SchemeInformation("adt", "");
    private static final ISchemeInformation ADT_DEMO_SCHEME_INFO = new SchemeInformation("adt+demo", "");
    private IOperatingSystemRegistration registration;
    private FileProviderMock fileProvider;
    private ProcessSpy processStub;
    private static String originalEclipseHomeLocation;
    private static String originalEclipseLauncher;
    private String lsregisterDumpForOtherApp;
    private String lsregisterDumpForOwnApp;
    private String lsregisterDumpForOwnAppPlus;
    private String lsregisterDumpMacOS10_15_3;

    @Before
    public void setup() {
        this.fileProvider = new FileProviderMock();
        this.fileProvider.writer = new StringWriter();
        this.fileProvider.fileExistsAnswers.put(PATH_TO_CODE_SIGNATURE, false);
        this.processStub = new ProcessSpy();
        System.setProperty("eclipse.home.location", "file:/Users/myuser/Applications/Eclipse.app/Contents/Eclipse/");
        System.setProperty("eclipse.launcher", "/Users/myuser/Applications/Eclipse.app/Contents/MacOS/eclipse");
        this.registration = new RegistrationMacOsX((IFileProvider)this.fileProvider, (IProcessExecutor)this.processStub);
        InputStream inputStream = this.getClass().getResourceAsStream("lsregisterForOtherApp.txt");
        this.lsregisterDumpForOtherApp = this.convert(inputStream);
        inputStream = this.getClass().getResourceAsStream("lsregisterForOwnApp.txt");
        this.lsregisterDumpForOwnApp = this.convert(inputStream);
        inputStream = this.getClass().getResourceAsStream("lsregisterForOwnAppPlus.txt");
        this.lsregisterDumpForOwnAppPlus = this.convert(inputStream);
        inputStream = this.getClass().getResourceAsStream("lsreigsterForOwnApp_macOS_10_15_3.txt");
        this.lsregisterDumpMacOS10_15_3 = this.convert(inputStream);
    }

    @BeforeClass
    public static void classSetup() {
        originalEclipseHomeLocation = System.getProperty("eclipse.home.location", "");
        originalEclipseLauncher = System.getProperty("eclipse.launcher", "");
    }

    @AfterClass
    public static void classTearDown() {
        System.setProperty("eclipse.home.location", originalEclipseHomeLocation);
        System.setProperty("eclipse.launcher", originalEclipseLauncher);
    }

    private String convert(InputStream inputStream) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name());){
            return scanner.useDelimiter("\\A").next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void handlesAddOnly() throws Exception {
        this.fileProvider.readAnswers.put(OWN_APP_PLIST_PATH, this.getPlistFileReader());
        this.registration.handleSchemes(Arrays.asList(ADT_SCHEME_INFO), Collections.emptyList());
        this.assertFilePathIs(OWN_APP_PLIST_PATH);
        this.assertSchemeInFile("adt");
        this.assertLsRegisterCallWithOptionAtIndex("-u", 0);
        this.assertLsRegisterCallWithOptionAtIndex("-r", 1);
    }

    @Test
    public void handlesAddOnlyPlus() throws Exception {
        this.fileProvider.readAnswers.put(OWN_APP_PLIST_PATH, this.getPlistFileReader());
        this.registration.handleSchemes(Arrays.asList(ADT_DEMO_SCHEME_INFO), Collections.emptyList());
        this.assertFilePathIs(OWN_APP_PLIST_PATH);
        this.assertSchemeInFile("adt+demo");
        this.assertLsRegisterCallWithOptionAtIndex("-u", 0);
        this.assertLsRegisterCallWithOptionAtIndex("-r", 1);
    }

    @Test
    public void handlesAddAndRemoveAtOnce() throws Exception {
        this.fileProvider.readAnswers.put(OWN_APP_PLIST_PATH, this.getPlistFileReaderWithAdtScheme());
        this.registration.handleSchemes(Arrays.asList(OTHER_SCHEME_INFO), Arrays.asList(ADT_SCHEME_INFO));
        this.assertFilePathIs(OWN_APP_PLIST_PATH);
        this.assertSchemeInFile("other");
        this.assertSchemeNotInFile("adt");
        this.assertLsRegisterCallWithOptionAtIndex("-u", 0);
        this.assertLsRegisterCallWithOptionAtIndex("-r", 1);
    }

    @Test
    public void handlesAddAndRemoveAtOncePlus() throws Exception {
        this.fileProvider.readAnswers.put(OWN_APP_PLIST_PATH, this.getPlistFileReaderWithAdtSchemePlus());
        this.registration.handleSchemes(Arrays.asList(OTHER_SCHEME_INFO), Arrays.asList(ADT_DEMO_SCHEME_INFO));
        this.assertFilePathIs(OWN_APP_PLIST_PATH);
        this.assertSchemeInFile("other");
        this.assertSchemeNotInFile("adt+demo");
        this.assertLsRegisterCallWithOptionAtIndex("-u", 0);
        this.assertLsRegisterCallWithOptionAtIndex("-r", 1);
    }

    @Test
    public void handlesRemoveOnly() throws Exception {
        this.fileProvider.readAnswers.put(OWN_APP_PLIST_PATH, this.getPlistFileReaderWithAdtScheme());
        this.registration.handleSchemes(Collections.emptyList(), Arrays.asList(ADT_SCHEME_INFO));
        this.assertFilePathIs(OWN_APP_PLIST_PATH);
        this.assertSchemeNotInFile("adt");
        this.assertLsRegisterCallWithOptionAtIndex("-u", 0);
        this.assertLsRegisterCallWithOptionAtIndex("-r", 1);
    }

    @Test
    public void handlesRemoveOnlyPlus() throws Exception {
        this.fileProvider.readAnswers.put(OWN_APP_PLIST_PATH, this.getPlistFileReaderWithAdtSchemePlus());
        this.registration.handleSchemes(Collections.emptyList(), Arrays.asList(ADT_DEMO_SCHEME_INFO));
        this.assertFilePathIs(OWN_APP_PLIST_PATH);
        this.assertSchemeNotInFile("adt+demo");
        this.assertLsRegisterCallWithOptionAtIndex("-u", 0);
        this.assertLsRegisterCallWithOptionAtIndex("-r", 1);
    }

    @Test
    public void returnsRegisteredSchemes() throws Exception {
        this.fileProvider.readAnswers.put(OWN_APP_PLIST_PATH, this.getPlistFileReaderWithAdtScheme());
        this.processStub.result = this.lsregisterDumpForOwnApp;
        List infos = this.registration.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"adt", (Object)((ISchemeInformation)infos.get(0)).getName());
        Assert.assertTrue((boolean)((ISchemeInformation)infos.get(0)).isHandled());
    }

    @Test
    public void returnsRegisteredSchemesOnMacOS_10_15_3() throws Exception {
        this.fileProvider.readAnswers.put(OWN_APP_PLIST_PATH, this.getPlistFileReaderWithAdtScheme());
        this.processStub.result = this.lsregisterDumpMacOS10_15_3;
        List infos = this.registration.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"adt", (Object)((ISchemeInformation)infos.get(0)).getName());
        Assert.assertTrue((boolean)((ISchemeInformation)infos.get(0)).isHandled());
    }

    @Test
    public void returnsRegisteredSchemesOnMacOS10_15_3() throws Exception {
        this.fileProvider.readAnswers.put(OWN_APP_PLIST_PATH, this.getPlistFileReaderWithAdtScheme());
        this.processStub.result = this.lsregisterDumpForOwnApp;
        List infos = this.registration.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"adt", (Object)((ISchemeInformation)infos.get(0)).getName());
        Assert.assertTrue((boolean)((ISchemeInformation)infos.get(0)).isHandled());
    }

    @Test
    public void returnsRegisteredSchemesPlus() throws Exception {
        this.fileProvider.readAnswers.put(OWN_APP_PLIST_PATH, this.getPlistFileReaderWithAdtSchemePlus());
        this.processStub.result = this.lsregisterDumpForOwnAppPlus;
        List infos = this.registration.getSchemesInformation(Arrays.asList(ADT_DEMO_SCHEME));
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"adt+demo", (Object)((ISchemeInformation)infos.get(0)).getName());
        Assert.assertTrue((boolean)((ISchemeInformation)infos.get(0)).isHandled());
    }

    @Test
    public void givesSchemeInfoForSchemeHandledByOtherApp() throws Exception {
        this.fileProvider.readAnswers.put(OTHER_APP_PLIST_PATH, this.getPlistFileReaderWithAdtScheme());
        this.processStub.result = this.lsregisterDumpForOtherApp;
        List infos = this.registration.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"adt", (Object)((ISchemeInformation)infos.get(0)).getName());
        Assert.assertFalse((boolean)((ISchemeInformation)infos.get(0)).isHandled());
        Assert.assertEquals((Object)OTHER_APP_BUNDLE_PATH, (Object)((ISchemeInformation)infos.get(0)).getHandlerInstanceLocation());
    }

    @Test
    public void givesSchemeInfoForSchemeHandledByOtherAppAndInOwnPlistFile() throws Exception {
        this.fileProvider.readAnswers.put(OWN_APP_PLIST_PATH, this.getPlistFileReaderWithAdtScheme());
        this.fileProvider.readAnswers.put(OTHER_APP_PLIST_PATH, this.getPlistFileReaderWithAdtScheme());
        this.processStub.result = this.lsregisterDumpForOtherApp;
        List infos = this.registration.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"adt", (Object)((ISchemeInformation)infos.get(0)).getName());
        Assert.assertFalse((boolean)((ISchemeInformation)infos.get(0)).isHandled());
        Assert.assertEquals((Object)OTHER_APP_BUNDLE_PATH, (Object)((ISchemeInformation)infos.get(0)).getHandlerInstanceLocation());
    }

    @Test
    public void doesSupportRegistrationIfAppIsNotSigned() throws Exception {
        Assert.assertTrue((boolean)this.registration.supportsRegistration());
    }

    @Test
    public void doesNotSupportRegistrationIfAppIsSigned() throws Exception {
        this.fileProvider.fileExistsAnswers.put(PATH_TO_CODE_SIGNATURE, true);
        Assert.assertFalse((boolean)this.registration.supportsRegistration());
    }

    private void assertFilePathIs(String filePath) {
        Assert.assertEquals((Object)filePath, (Object)this.fileProvider.recordedReadPaths.get(0));
        Assert.assertEquals((Object)filePath, (Object)this.fileProvider.writePath);
    }

    private void assertSchemeInFile(String scheme) {
        MatcherAssert.assertThat((Object)this.fileProvider.writer.toString(), (Matcher)new StringContains("<string>" + scheme + "</string>"));
    }

    private void assertSchemeNotInFile(String scheme) {
        MatcherAssert.assertThat((Object)this.fileProvider.writer.toString(), (Matcher)new IsNot((Matcher)new StringContains("<string>" + scheme + "</string>")));
    }

    private void assertLsRegisterCallWithOptionAtIndex(String option, int index) {
        String expectedProcess = "/System/Library/Frameworks/CoreServices.framework/Versions/A/Frameworks/LaunchServices.framework/Versions/A/Support/lsregister";
        Object[] expectedArguments = new String[]{option, "/Users/myuser/Applications/Eclipse.app"};
        Assert.assertEquals((Object)expectedProcess, (Object)this.processStub.records.get((int)index).process);
        Assert.assertArrayEquals((Object[])expectedArguments, (Object[])this.processStub.records.get((int)index).args);
    }

    private Reader getPlistFileReader() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><plist version=\"1.0\">\n<dict>\n\t<key>CFBundleExecutable</key>\n\t\t<string>eclipse</string>\n</dict>\n</plist>\n";
        return new StringReader(xml);
    }

    private Reader getPlistFileReaderWithAdtScheme() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><plist version=\"1.0\">\n<dict>\n\t<key>CFBundleExecutable</key>\n\t\t<string>eclipse</string>\n\t<key>CFBundleURLTypes</key>\n\t\t<array>\n\t\t\t<dict>\n\t\t\t\t<key>CFBundleURLName</key>\n\t\t\t\t\t<string>AdtScheme</string>\n\t\t\t\t<key>CFBundleURLSchemes</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<string>adt</string>\n\t\t\t\t\t</array>\n\t\t\t</dict>\n\t\t</array>\n</dict>\n</plist>\n";
        return new StringReader(xml);
    }

    private Reader getPlistFileReaderWithAdtSchemePlus() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><plist version=\"1.0\">\n<dict>\n\t<key>CFBundleExecutable</key>\n\t\t<string>eclipse</string>\n\t<key>CFBundleURLTypes</key>\n\t\t<array>\n\t\t\t<dict>\n\t\t\t\t<key>CFBundleURLName</key>\n\t\t\t\t\t<string>AdtScheme</string>\n\t\t\t\t<key>CFBundleURLSchemes</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<string>adt+demo</string>\n\t\t\t\t\t</array>\n\t\t\t</dict>\n\t\t</array>\n</dict>\n</plist>\n";
        return new StringReader(xml);
    }
}

