/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.ISchemeInformation;
import org.eclipse.urischeme.internal.registration.FileProviderMock;
import org.eclipse.urischeme.internal.registration.IFileProvider;
import org.eclipse.urischeme.internal.registration.IRegistryWriter;
import org.eclipse.urischeme.internal.registration.RegistrationWindows;
import org.eclipse.urischeme.internal.registration.RegistryWriterMock;
import org.eclipse.urischeme.internal.registration.Scheme;
import org.eclipse.urischeme.internal.registration.SchemeInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestUnitRegistrationWindows {
    @Rule
    public TestName name = new TestName();
    private static final String PATH_TO_OTHER_APPLICATION_EXE = "c:\\path\\to\\otherApplication.exe";
    private static final String PATH_TO_ECLIPSE_EXE = "c:\\path\\with spaces\\to\\eclipse\\Eclipse.exe";
    private static final String PATH_TO_ECLIPSE_HOME = "c:\\path\\with spaces\\to\\eclipse";
    private static final String URL_TO_ECLIPSE_HOME = "file:/c:/path/with spaces/to/eclipse/";
    private static final IScheme OTHER_SCHEME = new Scheme("other", "");
    private static final IScheme ADT_SCHEME = new Scheme("adt", "");
    private static final ISchemeInformation OTHER_SCHEME_INFO = new SchemeInformation("other", "");
    private static final ISchemeInformation ADT_SCHEME_INFO = new SchemeInformation("adt", "");
    RegistryWriterMock registryWriter;
    FileProviderMock fileProvider;
    private static String originalEclipseLauncher;
    private static String originalEclipseHome;
    private RegistrationWindows registrationWindows;

    @BeforeClass
    public static void classSetup() throws MalformedURLException {
        originalEclipseLauncher = System.getProperty("eclipse.launcher", null);
        originalEclipseHome = System.getProperty("eclipse.home.location", null);
    }

    @Before
    public void setUp() throws Exception {
        System.setProperty("eclipse.launcher", PATH_TO_ECLIPSE_EXE);
        this.registryWriter = new RegistryWriterMock();
        this.fileProvider = new FileProviderMock();
        this.fileProvider.fileExistsAnswers.put(PATH_TO_ECLIPSE_EXE, true);
        this.fileProvider.isDirectoryAnswers.put(PATH_TO_ECLIPSE_EXE, false);
        this.fileProvider.urlTosFilePaths.put(new URL(URL_TO_ECLIPSE_HOME), PATH_TO_ECLIPSE_HOME);
        this.registrationWindows = new RegistrationWindows((IRegistryWriter)this.registryWriter, (IFileProvider)this.fileProvider);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (originalEclipseLauncher != null) {
            System.setProperty("eclipse.launcher", originalEclipseLauncher);
        } else {
            System.clearProperty("eclipse.launcher");
        }
        if (originalEclipseHome != null) {
            System.setProperty("eclipse.home.location", originalEclipseHome);
        } else {
            System.clearProperty("eclipse.home.location");
        }
    }

    @Test
    public void handlesAdd() throws Exception {
        this.registrationWindows.handleSchemes(Arrays.asList(OTHER_SCHEME_INFO, ADT_SCHEME_INFO), Collections.emptyList());
        Assert.assertEquals((String)"Too many schemes added", (long)2L, (long)this.registryWriter.addedSchemes.size());
        Assert.assertTrue((String)"Scheme not added", (boolean)this.registryWriter.addedSchemes.contains(OTHER_SCHEME_INFO.getName()));
        Assert.assertTrue((String)"Scheme not added", (boolean)this.registryWriter.addedSchemes.contains(ADT_SCHEME_INFO.getName()));
        Assert.assertEquals((String)"Too many schemes removed", (long)0L, (long)this.registryWriter.removedSchemes.size());
    }

    @Test
    public void handlesAddAndRemoveOfSameScheme() throws Exception {
        this.registrationWindows.handleSchemes(Arrays.asList(OTHER_SCHEME_INFO), Arrays.asList(OTHER_SCHEME_INFO));
        Assert.assertEquals((String)"Too many schemes added", (long)1L, (long)this.registryWriter.addedSchemes.size());
        Assert.assertTrue((String)"Scheme not added", (boolean)this.registryWriter.addedSchemes.contains(OTHER_SCHEME_INFO.getName()));
        Assert.assertEquals((String)"Too many schemes removed", (long)1L, (long)this.registryWriter.removedSchemes.size());
        Assert.assertTrue((String)"Scheme not removed", (boolean)this.registryWriter.removedSchemes.contains(OTHER_SCHEME_INFO.getName()));
    }

    @Test
    public void handlesAddAndRemoveOfSameSchemes() throws Exception {
        this.registrationWindows.handleSchemes(Arrays.asList(OTHER_SCHEME_INFO, ADT_SCHEME_INFO), Arrays.asList(ADT_SCHEME_INFO, OTHER_SCHEME_INFO));
        Assert.assertEquals((String)"Too many schemes added", (long)2L, (long)this.registryWriter.addedSchemes.size());
        Assert.assertTrue((String)"Scheme not added", (boolean)this.registryWriter.addedSchemes.contains(OTHER_SCHEME_INFO.getName()));
        Assert.assertTrue((String)"Scheme not added", (boolean)this.registryWriter.addedSchemes.contains(ADT_SCHEME_INFO.getName()));
        Assert.assertEquals((String)"Too many schemes removed", (long)2L, (long)this.registryWriter.removedSchemes.size());
        Assert.assertTrue((String)"Scheme not removed", (boolean)this.registryWriter.removedSchemes.contains(OTHER_SCHEME_INFO.getName()));
        Assert.assertTrue((String)"Scheme not removed", (boolean)this.registryWriter.removedSchemes.contains(ADT_SCHEME_INFO.getName()));
    }

    @Test
    public void returnsUnregisteredSchemeInformation() throws Exception {
        List schemeInformation = this.registrationWindows.getSchemesInformation(Arrays.asList(ADT_SCHEME, OTHER_SCHEME));
        Assert.assertEquals((long)2L, (long)schemeInformation.size());
        this.assertSchemeInformation((ISchemeInformation)schemeInformation.get(0), ADT_SCHEME, "", false);
        this.assertSchemeInformation((ISchemeInformation)schemeInformation.get(1), OTHER_SCHEME, "", false);
    }

    @Test
    public void returnsRegisteredSchemeInformationForThisEclipse() throws Exception {
        this.registryWriter.schemeToHandlerPath.put(ADT_SCHEME.getName(), PATH_TO_ECLIPSE_EXE);
        List schemeInformation = this.registrationWindows.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)schemeInformation.size());
        this.assertSchemeInformation((ISchemeInformation)schemeInformation.get(0), ADT_SCHEME, PATH_TO_ECLIPSE_EXE, true);
    }

    @Test
    public void returnsRegisteredSchemeInformationForOtherApplication() throws Exception {
        this.registryWriter.schemeToHandlerPath.put(ADT_SCHEME.getName(), PATH_TO_OTHER_APPLICATION_EXE);
        List schemeInformation = this.registrationWindows.getSchemesInformation(Arrays.asList(ADT_SCHEME));
        Assert.assertEquals((long)1L, (long)schemeInformation.size());
        this.assertSchemeInformation((ISchemeInformation)schemeInformation.get(0), ADT_SCHEME, PATH_TO_OTHER_APPLICATION_EXE, false);
    }

    @Test
    public void getLauncherPathFromLauncherProperty() throws Exception {
        System.setProperty("eclipse.launcher", PATH_TO_ECLIPSE_EXE);
        this.fileProvider.fileExistsAnswers.put(PATH_TO_ECLIPSE_EXE, true);
        this.fileProvider.isDirectoryAnswers.put(PATH_TO_ECLIPSE_EXE, false);
        Assert.assertEquals((Object)PATH_TO_ECLIPSE_EXE, (Object)this.registrationWindows.getEclipseLauncher());
    }

    @Test
    public void getLauncherPathFromEclipseHomeProperty() throws Exception {
        System.out.println("registrationWindows1: " + String.valueOf(this.registrationWindows));
        System.clearProperty("eclipse.launcher");
        System.setProperty("eclipse.home.location", URL_TO_ECLIPSE_HOME);
        this.fileProvider.fileExistsAnswers.put(PATH_TO_ECLIPSE_HOME, true);
        this.fileProvider.isDirectoryAnswers.put(PATH_TO_ECLIPSE_HOME, true);
        this.fileProvider.newDirectoryStreamAnswers.computeIfAbsent(PATH_TO_ECLIPSE_HOME, path -> new HashMap()).put("*.exe", Arrays.asList(PATH_TO_ECLIPSE_EXE));
        System.out.println("registrationWindows2: " + String.valueOf(this.registrationWindows));
        Assert.assertEquals((Object)PATH_TO_ECLIPSE_EXE, (Object)this.registrationWindows.getEclipseLauncher());
    }

    @Test
    public void getLauncherPathFromEclipseHomeProperty_NoExeFileInDirectory() throws Exception {
        System.clearProperty("eclipse.launcher");
        System.setProperty("eclipse.home.location", URL_TO_ECLIPSE_HOME);
        this.fileProvider.fileExistsAnswers.put(PATH_TO_ECLIPSE_HOME, true);
        this.fileProvider.isDirectoryAnswers.put(PATH_TO_ECLIPSE_HOME, true);
        this.fileProvider.newDirectoryStreamAnswers.computeIfAbsent(PATH_TO_ECLIPSE_HOME, path -> new HashMap()).put("*.exe", Collections.emptyList());
        Assert.assertNull((Object)this.registrationWindows.getEclipseLauncher());
    }

    @Test
    public void getLauncherPathFromEclipseHomeProperty_DirectoryDoesNotExist() throws Exception {
        System.clearProperty("eclipse.launcher");
        System.setProperty("eclipse.home.location", URL_TO_ECLIPSE_HOME);
        this.fileProvider.fileExistsAnswers.put(PATH_TO_ECLIPSE_HOME, false);
        Assert.assertNull((Object)this.registrationWindows.getEclipseLauncher());
    }

    @Test
    public void getLauncherPathFromEclipseHomeProperty_NotAFileUrl() throws Exception {
        System.clearProperty("eclipse.launcher");
        System.setProperty("eclipse.home.location", "http://path/to/eclipse");
        Assert.assertNull((Object)this.registrationWindows.getEclipseLauncher());
    }

    private void assertSchemeInformation(ISchemeInformation schemeInformation, IScheme scheme, String handlerlocation, boolean isHandled) {
        Assert.assertEquals((String)"Scheme not set correctly", (Object)scheme.getName(), (Object)schemeInformation.getName());
        Assert.assertEquals((String)"Scheme description not set correctly", (Object)scheme.getDescription(), (Object)schemeInformation.getDescription());
        Assert.assertEquals((String)"Handler location not set correctly", (Object)handlerlocation, (Object)schemeInformation.getHandlerInstanceLocation());
        Assert.assertEquals((String)"isHandled not set correctly", (Object)isHandled, (Object)schemeInformation.isHandled());
    }
}

