/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import org.eclipse.urischeme.internal.registration.FileProviderMock;
import org.eclipse.urischeme.internal.registration.IFileProvider;
import org.eclipse.urischeme.internal.registration.IWinRegistry;
import org.eclipse.urischeme.internal.registration.RegistryWriter;
import org.eclipse.urischeme.internal.registration.WinRegistryException;
import org.eclipse.urischeme.internal.registration.WinRegistryMock;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUnitRegistryWriter {
    private static final String QUOTE = "\"";
    private static String originalEclipseHomeLocation;
    private static String originalEclipseLauncher;
    public static String launcher;
    public static String launcherWithArgs;
    public static String homeLocation;
    private RegistryWriter writer;
    private WinRegistryMock registryMock;
    private FileProviderMock fileProviderMock;

    @Before
    public void setUp() throws Exception {
        this.registryMock = new WinRegistryMock();
        launcher = "/path/to/eclipse/Eclips.exe";
        launcherWithArgs = QUOTE + launcher + "\" \"%1\"";
        homeLocation = "/path/to/eclipse/";
        System.setProperty("eclipse.launcher", launcher);
        System.setProperty("eclipse.home.location", homeLocation);
        this.fileProviderMock = new FileProviderMock();
        this.fileProviderMock.fileExistsAnswers.put(launcher, true);
        this.fileProviderMock.isDirectoryAnswers.put(launcher, false);
        this.writer = new RegistryWriter((IWinRegistry)this.registryMock, (IFileProvider)this.fileProviderMock);
    }

    @BeforeClass
    public static void classSetup() {
        originalEclipseLauncher = System.getProperty("eclipse.launcher", "");
        originalEclipseHomeLocation = System.getProperty("eclipse.home.location", "");
    }

    @AfterClass
    public static void classTearDown() {
        System.setProperty("eclipse.launcher", originalEclipseLauncher);
        System.setProperty("eclipse.home.location", originalEclipseHomeLocation);
    }

    @Test
    public void addsOneScheme() throws Exception {
        this.writer.addScheme("adt", launcher);
        this.assertEntry(this.registryMock.setValues.get(0), "Software\\Classes\\adt", "URL Protocol", "");
        this.assertEntry(this.registryMock.setValues.get(1), "Software\\Classes\\adt", null, "URL:adt");
        this.assertEntry(this.registryMock.setValues.get(2), "Software\\Classes\\adt\\shell\\open\\command", "Executable", launcher);
        this.assertEntry(this.registryMock.setValues.get(3), "Software\\Classes\\adt\\shell\\open\\command", null, launcherWithArgs);
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsExceptionOnAddingInvalidScheme() throws Exception {
        this.writer.addScheme("%&$", launcher);
    }

    @Test(expected=WinRegistryException.class)
    public void throwsIllegalStateExceptionOnAddScheme() throws Exception {
        this.registryMock.setValueForKeyException = new WinRegistryException("failed");
        this.writer.addScheme("adt", launcher);
    }

    @Test
    public void removesOneScheme() throws Exception {
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt-URL Protocol", "");
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt-null", "URL:adt");
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt\\shell\\open\\command-Executable", launcher);
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt\\shell\\open\\command-null", launcherWithArgs);
        this.fileProviderMock.fileExistsAnswers.put(launcher, true);
        this.writer.removeScheme("adt");
        Assert.assertEquals((Object)"Software\\Classes\\adt\\shell\\open\\command", (Object)this.registryMock.deletedKeys.get(0));
        Assert.assertEquals((Object)"Software\\Classes\\adt\\shell\\open", (Object)this.registryMock.deletedKeys.get(1));
        Assert.assertEquals((Object)"Software\\Classes\\adt\\shell", (Object)this.registryMock.deletedKeys.get(2));
        Assert.assertEquals((Object)"Software\\Classes\\adt", (Object)this.registryMock.deletedKeys.get(3));
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsExceptionOnRemovingInvalidScheme() throws Exception {
        this.writer.removeScheme("%&$");
    }

    @Test(expected=WinRegistryException.class)
    public void throwsWinRegistryExceptionOnRemoveScheme() throws Exception {
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt-URL Protocol", "");
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt-null", "URL:adt");
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt\\shell\\open\\command-Executable", launcher);
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt\\shell\\open\\command-null", launcherWithArgs);
        this.fileProviderMock.fileExistsAnswers.put(launcher, true);
        this.registryMock.deleteKeyException = new WinRegistryException("failed");
        this.writer.removeScheme("adt");
    }

    private void assertEntry(WinRegistryMock.Entry entry, String key, String attribute, String value) {
        Assert.assertEquals((Object)key, (Object)entry.key);
        Assert.assertEquals((Object)attribute, (Object)entry.attribute);
        Assert.assertEquals((Object)value, (Object)entry.value);
    }

    @Test
    public void addsTwoSchemes() throws WinRegistryException {
        this.writer.addScheme("adt", launcher);
        this.writer.addScheme("other", launcher);
        this.assertEntry(this.registryMock.setValues.get(0), "Software\\Classes\\adt", "URL Protocol", "");
        this.assertEntry(this.registryMock.setValues.get(1), "Software\\Classes\\adt", null, "URL:adt");
        this.assertEntry(this.registryMock.setValues.get(2), "Software\\Classes\\adt\\shell\\open\\command", "Executable", launcher);
        this.assertEntry(this.registryMock.setValues.get(3), "Software\\Classes\\adt\\shell\\open\\command", null, launcherWithArgs);
        this.assertEntry(this.registryMock.setValues.get(4), "Software\\Classes\\other", "URL Protocol", "");
        this.assertEntry(this.registryMock.setValues.get(5), "Software\\Classes\\other", null, "URL:other");
        this.assertEntry(this.registryMock.setValues.get(6), "Software\\Classes\\other\\shell\\open\\command", "Executable", launcher);
        this.assertEntry(this.registryMock.setValues.get(7), "Software\\Classes\\other\\shell\\open\\command", null, launcherWithArgs);
    }

    @Test
    public void removesTwoSchemes() throws Exception {
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt-URL Protocol", "");
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt-null", "URL:adt");
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt\\shell\\open\\command-Executable", launcher);
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt\\shell\\open\\command-null", launcherWithArgs);
        this.registryMock.valuesForKeys.put("Software\\Classes\\other-URL Protocol", "");
        this.registryMock.valuesForKeys.put("Software\\Classes\\other-null", "URL:other");
        this.registryMock.valuesForKeys.put("Software\\Classes\\other\\shell\\open\\command-Executable", launcher);
        this.registryMock.valuesForKeys.put("Software\\Classes\\other\\shell\\open\\command-null", launcherWithArgs);
        this.fileProviderMock.fileExistsAnswers.put(launcher, true);
        this.writer.removeScheme("adt");
        this.writer.removeScheme("other");
        Assert.assertEquals((Object)"Software\\Classes\\adt\\shell\\open\\command", (Object)this.registryMock.deletedKeys.get(0));
        Assert.assertEquals((Object)"Software\\Classes\\adt\\shell\\open", (Object)this.registryMock.deletedKeys.get(1));
        Assert.assertEquals((Object)"Software\\Classes\\adt\\shell", (Object)this.registryMock.deletedKeys.get(2));
        Assert.assertEquals((Object)"Software\\Classes\\adt", (Object)this.registryMock.deletedKeys.get(3));
        Assert.assertEquals((Object)"Software\\Classes\\other\\shell\\open\\command", (Object)this.registryMock.deletedKeys.get(4));
        Assert.assertEquals((Object)"Software\\Classes\\other\\shell\\open", (Object)this.registryMock.deletedKeys.get(5));
        Assert.assertEquals((Object)"Software\\Classes\\other\\shell", (Object)this.registryMock.deletedKeys.get(6));
        Assert.assertEquals((Object)"Software\\Classes\\other", (Object)this.registryMock.deletedKeys.get(7));
    }

    @Test
    public void returnsRegisteredHandlerPath() throws WinRegistryException {
        Assert.assertNull((Object)this.writer.getRegisteredHandlerPath("adt"));
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt-URL Protocol", "");
        Assert.assertNull((Object)this.writer.getRegisteredHandlerPath("adt"));
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt\\shell\\open\\command-null", "URL:adt");
        Assert.assertNull((Object)this.writer.getRegisteredHandlerPath("adt"));
        this.fileProviderMock.fileExistsAnswers.put(launcher, true);
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt\\shell\\open\\command-Executable", launcher);
        Assert.assertEquals((Object)launcher, (Object)this.writer.getRegisteredHandlerPath("adt"));
    }

    @Test
    public void returnsNullOnNotExitingRegisteredHandlerPath() throws WinRegistryException {
        Assert.assertNull((Object)this.writer.getRegisteredHandlerPath("adt"));
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt-URL Protocol", "");
        Assert.assertNull((Object)this.writer.getRegisteredHandlerPath("adt"));
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt\\shell\\open\\command-null", "URL:adt");
        Assert.assertNull((Object)this.writer.getRegisteredHandlerPath("adt"));
        this.fileProviderMock.fileExistsAnswers.put(launcher, false);
        this.registryMock.valuesForKeys.put("Software\\Classes\\adt\\shell\\open\\command-Executable", launcher);
        Assert.assertEquals(null, (Object)this.writer.getRegisteredHandlerPath("adt"));
    }

    @Test(expected=WinRegistryException.class)
    public void throwsWinRegistryExceptionOnGetRegisteredHandlerPath() throws Exception {
        this.registryMock.getValueForKeyException = new WinRegistryException("failed");
        this.writer.getRegisteredHandlerPath("adt");
    }

    @Test
    public void ignoresUnregisteredSchemeOnRemove() throws WinRegistryException {
        this.writer.removeScheme("adt");
        Assert.assertTrue((boolean)this.registryMock.deletedKeys.isEmpty());
    }
}

