/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.eclipse.urischeme.internal.registration.WinRegistry;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assume;
import org.junit.Test;

public class TestUnitWinRegistry {
    @Test
    public void testWinRegistry() throws Exception {
        Assume.assumeThat((String)"Requires Windows OS", (Object)Platform.getOS(), (Matcher)CoreMatchers.is((Object)"win32"));
        WinRegistry winRegistry = new WinRegistry();
        String randomKeyMain = UUID.randomUUID().toString();
        String randomKeySub = UUID.randomUUID().toString();
        winRegistry.setValueForKey(randomKeyMain + "\\" + randomKeySub, "dummykey", "dummyval");
        String actualVal = winRegistry.getValueForKey(randomKeyMain + "\\" + randomKeySub, "dummykey");
        MatcherAssert.assertThat((Object)actualVal, (Matcher)CoreMatchers.is((Object)"dummyval"));
        winRegistry.deleteKey(randomKeyMain + "\\" + randomKeySub);
        winRegistry.deleteKey(randomKeyMain);
        actualVal = winRegistry.getValueForKey(randomKeyMain + "\\" + randomKeySub, "dummykey");
        MatcherAssert.assertThat((Object)actualVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

