/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.action;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.tests.action.DummyAction;
import org.eclipse.jface.tests.action.JFaceActionRule;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MenuManagerTest {
    @Rule
    public JFaceActionRule rule = new JFaceActionRule();
    private int groupMarkerCount = 0;
    private int separatorCount = 0;

    @Test
    public void testMenuWithNoConcreteVisibleItemsIsHidden() {
        MenuManager menuBarMgr = this.createMenuBarManager();
        MenuManager fileMenu = this.createMenuManager("File", "gsgn");
        menuBarMgr.add((IContributionItem)fileMenu);
        menuBarMgr.updateAll(false);
        Assert.assertEquals((long)0L, (long)this.rule.getShell().getMenuBar().getItems().length);
    }

    @Test
    public void testAddingConcreteItemToMenuWithNoConcreteVisibleItems() {
        MenuManager menuBarMgr = this.createMenuBarManager();
        MenuManager fileMenuMgr = this.createMenuManager("File", "gsgn");
        menuBarMgr.add((IContributionItem)fileMenuMgr);
        menuBarMgr.updateAll(false);
        Menu menuBar = this.rule.getShell().getMenuBar();
        Assert.assertEquals((long)0L, (long)menuBar.getItems().length);
        fileMenuMgr.add(this.createItem('a'));
        menuBarMgr.updateAll(false);
        Assert.assertEquals((long)1L, (long)menuBar.getItems().length);
        Assert.assertEquals((Object)"File", (Object)menuBar.getItems()[0].getText());
        Menu fileMenu = menuBar.getItems()[0].getMenu();
        Assert.assertEquals((long)1L, (long)fileMenu.getItems().length);
    }

    @Test
    public void testDisposedMenuIsDirty() {
        MenuManager menuBarMgr = this.createMenuBarManager();
        MenuManager fileMenuMgr = this.createMenuManager("File", "gsgn");
        menuBarMgr.add((IContributionItem)fileMenuMgr);
        menuBarMgr.updateAll(false);
        Assert.assertFalse((boolean)menuBarMgr.isDirty());
        menuBarMgr.dispose();
        Assert.assertTrue((boolean)menuBarMgr.isDirty());
    }

    @Test
    public void testEmptyMenuManagerNPE() {
        Menu menu = new Menu((Control)this.rule.getShell());
        MenuManager manager = new MenuManager();
        manager.fill(menu, -1);
    }

    private MenuManager createMenuManager(String name, String template) {
        MenuManager menuMgr = new MenuManager(name);
        this.addItems((IContributionManager)menuMgr, template);
        return menuMgr;
    }

    private void addItems(IContributionManager manager, String template) {
        int i = 0;
        while (i < template.length()) {
            manager.add(this.createItem(template.charAt(i)));
            ++i;
        }
    }

    private IContributionItem createItem(char template) {
        switch (template) {
            case 'g': {
                return new GroupMarker("testGroup" + this.groupMarkerCount++);
            }
            case 's': {
                return new Separator("testSeparator" + this.separatorCount++);
            }
            case 'a': {
                DummyAction action = new DummyAction();
                return new ActionContributionItem((IAction)action);
            }
            case 'n': {
                DummyAction action = new DummyAction();
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.setVisible(false);
                return item;
            }
        }
        throw new IllegalArgumentException("Unknown template char: " + template);
    }

    protected MenuManager createMenuBarManager() {
        Shell shell = this.rule.getShell();
        MenuManager menuMgr = new MenuManager();
        Menu menuBar = menuMgr.createMenuBar((Decorations)shell);
        shell.setMenuBar(menuBar);
        return menuMgr;
    }
}

