/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.action;

import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.tests.action.JFaceActionRule;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ToolBarManagerTest {
    private static final int DEFAULT_STYLE = 8519744;
    @Rule
    public JFaceActionRule rule = new JFaceActionRule();

    public void testSetStyleWhenToolBarDoesNotExist() {
        Composite parent = this.createComposite();
        ToolBarManager manager = new ToolBarManager(8520000);
        manager.setStyle(8520256);
        ToolBar toolBar = manager.createControl(parent);
        Assert.assertFalse((boolean)toolBar.isDisposed());
        ToolBarManagerTest.verifyOrientation(toolBar, 512);
    }

    @Test
    public void testSetStyleWhenToolBarExists() {
        Composite parent = this.createComposite();
        ToolBar toolBar = new ToolBar(parent, 8520256);
        ToolBarManager manager = new ToolBarManager(toolBar);
        manager.setStyle(8520000);
        Assert.assertSame((Object)toolBar, (Object)manager.createControl(parent));
        Assert.assertFalse((boolean)toolBar.isDisposed());
        toolBar.dispose();
        ToolBar newToolBar = manager.createControl(parent);
        Assert.assertNotSame((Object)toolBar, (Object)newToolBar);
        Assert.assertFalse((boolean)newToolBar.isDisposed());
        ToolBarManagerTest.verifyOrientation(newToolBar, 256);
    }

    @Test
    public void testCreateControlWhenParentNull() {
        Composite parent = this.createComposite();
        ToolBarManager manager = new ToolBarManager(8520256);
        Assert.assertNull((Object)manager.createControl(null));
        ToolBar toolBar = manager.createControl(parent);
        Assert.assertNotNull((Object)toolBar);
        Assert.assertSame((Object)toolBar, (Object)manager.createControl(null));
    }

    @Test
    public void testDispose() {
        Composite parent = this.createComposite();
        ToolBar toolBar = new ToolBar(parent, 8520256);
        ToolBarManager manager = new ToolBarManager(toolBar);
        manager.dispose();
        Assert.assertTrue((boolean)toolBar.isDisposed());
    }

    @Test
    public void testUpdate() {
        ToolBarManager manager = new ToolBarManager();
        ObservableControlContribution item = new ObservableControlContribution("i want to be updated!");
        manager.add((IContributionItem)item);
        manager.createControl(this.createComposite());
        Assert.assertFalse((String)"Update was called already", (boolean)item.updateCalled);
        Assert.assertTrue((String)"computeWidth was not called", (boolean)item.computeWidthCalled);
        item.computeWidthCalled = false;
        manager.update(false);
        Assert.assertFalse((String)"Item update should only be called when manager update is forced", (boolean)item.updateCalled);
        Assert.assertFalse((String)"computeWidth should only be called when manager update is forced", (boolean)item.computeWidthCalled);
        manager.update(true);
        Assert.assertTrue((String)"Update was not called", (boolean)item.updateCalled);
        Assert.assertTrue((String)"computeWidth was not called", (boolean)item.computeWidthCalled);
    }

    @Test
    public void testControlContributionIsSet() {
        ToolBarManager manager = new ToolBarManager();
        manager.add((IContributionItem)new ControlContribution("test"){

            protected Control createControl(Composite parent) {
                return new Label(parent, 0);
            }
        });
        ToolBar toolBar = manager.createControl(this.createComposite());
        ToolItem[] toolItemArray = toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            if (!(item.getData() instanceof ControlContribution)) {
                Assert.fail((String)"ToolItem data is not set to ControlContribution");
            }
            ++n2;
        }
    }

    @Test
    public void testDefaultImageIsGray() {
        boolean oldState = ActionContributionItem.getUseColorIconsInToolbars();
        try {
            ActionContributionItem.setUseColorIconsInToolbars((boolean)false);
            ToolBarManager manager = new ToolBarManager();
            Action action = new Action("Button with Hover"){};
            ImageDescriptor descriptor = JFaceResources.getImageRegistry().getDescriptor("dialog_messasge_info_image");
            ImageDescriptor hoverDescriptor = JFaceResources.getImageRegistry().getDescriptor("dialog_message_error_image");
            ImageDescriptor disabledDescriptor = JFaceResources.getImageRegistry().getDescriptor("dialog_messasge_warning_image");
            action.setImageDescriptor(descriptor);
            action.setHoverImageDescriptor(hoverDescriptor);
            action.setDisabledImageDescriptor(disabledDescriptor);
            manager.add((IAction)action);
            ToolBar toolBar = manager.createControl(this.createComposite());
            ToolItem[] items = toolBar.getItems();
            Assert.assertEquals((long)1L, (long)items.length);
            ToolItem item = items[0];
            ToolBarManagerTest.assertImageEqualsDescriptor(hoverDescriptor, item.getHotImage());
            ToolBarManagerTest.assertImageEqualsDescriptor(disabledDescriptor, item.getDisabledImage());
            ToolBarManagerTest.assertImageEqualsDescriptor(ImageDescriptor.createWithFlags((ImageDescriptor)descriptor, (int)2), item.getImage());
        }
        finally {
            ActionContributionItem.setUseColorIconsInToolbars((boolean)oldState);
        }
    }

    @Test
    public void testActionImagesAreSet() {
        boolean oldState = ActionContributionItem.getUseColorIconsInToolbars();
        try {
            ActionContributionItem.setUseColorIconsInToolbars((boolean)true);
            ToolBarManager manager = new ToolBarManager();
            Action action = new Action("Button with Hover"){};
            ImageDescriptor descriptor = JFaceResources.getImageRegistry().getDescriptor("dialog_messasge_info_image");
            ImageDescriptor hoverDescriptor = JFaceResources.getImageRegistry().getDescriptor("dialog_message_error_image");
            ImageDescriptor disabledDescriptor = JFaceResources.getImageRegistry().getDescriptor("dialog_messasge_warning_image");
            action.setImageDescriptor(descriptor);
            action.setHoverImageDescriptor(hoverDescriptor);
            action.setDisabledImageDescriptor(disabledDescriptor);
            manager.add((IAction)action);
            ToolBar toolBar = manager.createControl(this.createComposite());
            ToolItem[] items = toolBar.getItems();
            Assert.assertEquals((long)1L, (long)items.length);
            ToolItem item = items[0];
            ToolBarManagerTest.assertImageEqualsDescriptor(descriptor, item.getImage());
            ToolBarManagerTest.assertImageEqualsDescriptor(hoverDescriptor, item.getHotImage());
            ToolBarManagerTest.assertImageEqualsDescriptor(disabledDescriptor, item.getDisabledImage());
        }
        finally {
            ActionContributionItem.setUseColorIconsInToolbars((boolean)oldState);
        }
    }

    private static void assertImageEqualsDescriptor(ImageDescriptor descriptor, Image image) {
        Image createImage = descriptor.createImage();
        try {
            ToolBarManagerTest.assertImageDataEquals(createImage.getImageData(), image.getImageData());
        }
        finally {
            createImage.dispose();
        }
    }

    private static void assertImageDataEquals(ImageData im1, ImageData im2) {
        Assert.assertNotNull((String)"ImageData 1 is null", (Object)im1);
        Assert.assertNotNull((String)"ImageData 2 is null", (Object)im2);
        Assert.assertEquals((String)"ImageData width missmatch", (long)im1.width, (long)im2.width);
        Assert.assertEquals((String)"ImageData height missmatch", (long)im1.height, (long)im2.height);
        int x = 0;
        while (x < im1.width) {
            int y = 0;
            while (y < im1.height) {
                Assert.assertEquals((String)("pixel (" + x + "," + y + ") are not equal"), (long)im1.getPixel(x, y), (long)im2.getPixel(x, y));
                ++y;
            }
            ++x;
        }
    }

    @Test
    public void testMissingIsSet() {
        boolean oldState = ActionContributionItem.getUseColorIconsInToolbars();
        try {
            ActionContributionItem.setUseColorIconsInToolbars((boolean)true);
            ToolBarManager manager = new ToolBarManager();
            Action action = new Action("Button with Missing"){};
            action.setDisabledImageDescriptor(JFaceResources.getImageRegistry().getDescriptor("dialog_messasge_warning_image"));
            manager.add((IAction)action);
            ToolBar toolBar = manager.createControl(this.createComposite());
            ToolItem[] items = toolBar.getItems();
            Assert.assertEquals((long)1L, (long)items.length);
            ToolItem item = items[0];
            Assert.assertNotNull((Object)item.getImage());
            Image img = ImageDescriptor.getMissingImageDescriptor().createImage();
            byte[] data = img.getImageData().data;
            img.dispose();
            Assert.assertTrue((boolean)Arrays.equals(data, item.getImage().getImageData((int)100).data));
            Assert.assertNull((Object)item.getHotImage());
            Assert.assertNotNull((Object)item.getDisabledImage());
        }
        finally {
            ActionContributionItem.setUseColorIconsInToolbars((boolean)oldState);
        }
    }

    private Composite createComposite() {
        return new Composite((Composite)this.rule.getShell(), -1);
    }

    private static void verifyOrientation(ToolBar toolBar, int expected) {
        Assert.assertTrue(((toolBar.getStyle() & expected) != 0 ? 1 : 0) != 0);
        int opposite = (expected & 0x100) != 0 ? 512 : 256;
        Assert.assertEquals((long)0L, (long)(toolBar.getStyle() & opposite));
    }

    private final class ObservableControlContribution
    extends ControlContribution {
        private boolean updateCalled;
        private boolean computeWidthCalled;

        private ObservableControlContribution(String id) {
            super(id);
        }

        protected Control createControl(Composite parent) {
            return new ComboViewer(parent).getControl();
        }

        public void update() {
            super.update();
            this.updateCalled = true;
        }

        protected int computeWidth(Control control) {
            int computeWidth = super.computeWidth(control);
            this.computeWidthCalled = true;
            return computeWidth;
        }
    }
}

