/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.dialogs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.junit.Assert;
import org.junit.Test;

public class DialogSettingsTest {
    private static final float DELTA = 1.0E-7f;
    private static final String[] TEST_STRINGS = new String[]{"value", " value with spaces ", "value.with.many.dots", "value_with_underscores", "value<with<lessthan", "value>with>greaterthan", "value&with&ampersand", "value\"with\"quote", "value#with#hash", "", "\nvalue\nwith\nnewlines\n", "\tvalue\twith\ttab\t", "\rvalue\rwith\rreturn\r"};

    @Test
    public void testDialogSettings() throws IOException {
        String[] stringArray = TEST_STRINGS;
        int n = TEST_STRINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String testString;
            final String name = testString = stringArray[n2];
            DialogSettingsTest.testPutAndGetWithTitle(new DialogSettingsChecker(){

                @Override
                public void prepareAndCheckBeforeSerialization(IDialogSettings dialogSettingsToSerialize) {
                }

                @Override
                public void checkAfterDeserialization(IDialogSettings deserializedDialogSettings) {
                    Assert.assertEquals((Object)name, (Object)deserializedDialogSettings.getName());
                }
            }, name);
            ++n2;
        }
    }

    @Test
    public void testAddNewSection() throws IOException {
        String[] stringArray = TEST_STRINGS;
        int n = TEST_STRINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String testString;
            final String name = testString = stringArray[n2];
            DialogSettingsTest.testPutAndGet(new DialogSettingsChecker(){

                @Override
                public void prepareAndCheckBeforeSerialization(IDialogSettings dialogSettingsToSerialize) {
                    Assert.assertEquals((long)0L, (long)dialogSettingsToSerialize.getSections().length);
                    Assert.assertEquals(null, (Object)dialogSettingsToSerialize.getSection(name));
                    dialogSettingsToSerialize.addNewSection(name);
                    Assert.assertEquals((long)1L, (long)dialogSettingsToSerialize.getSections().length);
                    Assert.assertNotNull((Object)dialogSettingsToSerialize.getSection(name));
                    Assert.assertEquals((Object)name, (Object)dialogSettingsToSerialize.getSection(name).getName());
                    Assert.assertEquals((Object)name, (Object)dialogSettingsToSerialize.getSections()[0].getName());
                }

                @Override
                public void checkAfterDeserialization(IDialogSettings deserializedDialogSettings) {
                    Assert.assertEquals((long)1L, (long)deserializedDialogSettings.getSections().length);
                    Assert.assertNotNull((Object)deserializedDialogSettings.getSection(name));
                    Assert.assertEquals((Object)name, (Object)deserializedDialogSettings.getSection(name).getName());
                    Assert.assertEquals((Object)name, (Object)deserializedDialogSettings.getSections()[0].getName());
                }
            });
            ++n2;
        }
    }

    private static void fill(IDialogSettings dialogSettings) {
        dialogSettings.put("booleanKey", true);
        dialogSettings.put("floatKey", 0.4f);
        dialogSettings.put("doubleKey", 0.5);
        dialogSettings.put("integerKey", 324765);
        dialogSettings.put("longKey", 1324765L);
        dialogSettings.put("stringKey", "a string");
        dialogSettings.put("stringArrayKey", new String[]{"some text data1", "some text data2"});
        IDialogSettings section = dialogSettings.addNewSection("child1");
        section.addNewSection("child2");
        section.addNewSection("child3");
    }

    protected void check(IDialogSettings dialogSettings) {
        Assert.assertTrue((boolean)dialogSettings.getBoolean("booleanKey"));
        Assert.assertEquals((float)0.4f, (float)dialogSettings.getFloat("floatKey"), (float)0.4f);
        Assert.assertEquals((double)0.4f, (double)dialogSettings.getDouble("doubleKey"), (double)0.5);
        Assert.assertEquals((long)324765L, (long)dialogSettings.getInt("integerKey"));
        Assert.assertEquals((long)1324765L, (long)dialogSettings.getLong("longKey"));
        Assert.assertEquals((Object)"a string", (Object)dialogSettings.get("stringKey"));
        String[] stringArray = dialogSettings.getArray("stringArrayKey");
        Assert.assertEquals((long)2L, (long)stringArray.length);
        Assert.assertEquals((Object)"some text data1", (Object)stringArray[0]);
        Assert.assertEquals((Object)"some text data2", (Object)stringArray[1]);
        IDialogSettings section = dialogSettings.getSection("child1");
        Assert.assertNotNull((Object)section);
        Assert.assertNotNull((Object)section.getSection("child2"));
        Assert.assertNotNull((Object)section.getSection("child3"));
    }

    @Test
    public void testAddSection() throws IOException {
        DialogSettingsTest.testPutAndGet(new DialogSettingsChecker(){

            @Override
            public void prepareAndCheckBeforeSerialization(IDialogSettings dialogSettingsToSerialize) {
                DialogSettings section = new DialogSettings("some section");
                DialogSettingsTest.fill((IDialogSettings)section);
                DialogSettingsTest.this.check((IDialogSettings)section);
                Assert.assertEquals((Object)"some section", (Object)section.getName());
                dialogSettingsToSerialize.addSection((IDialogSettings)section);
            }

            @Override
            public void checkAfterDeserialization(IDialogSettings deserializedDialogSettings) {
                IDialogSettings section = deserializedDialogSettings.getSection("some section");
                Assert.assertNotNull((Object)section);
                Assert.assertEquals((Object)"some section", (Object)section.getName());
                DialogSettingsTest.this.check(section);
            }
        });
    }

    @Test
    public void testRemoveSection() {
        DialogSettings dialogSettings = new DialogSettings(null);
        IDialogSettings section = dialogSettings.addNewSection("new-section");
        Assert.assertEquals((long)1L, (long)dialogSettings.getSections().length);
        dialogSettings.removeSection(section);
        Assert.assertEquals((long)0L, (long)dialogSettings.getSections().length);
    }

    @Test
    public void testRemoveSectionByName() {
        DialogSettings dialogSettings = new DialogSettings(null);
        IDialogSettings section = dialogSettings.addNewSection("new-section");
        Assert.assertEquals((long)1L, (long)dialogSettings.getSections().length);
        IDialogSettings removedSection = dialogSettings.removeSection("new-section");
        Assert.assertEquals((long)0L, (long)dialogSettings.getSections().length);
        Assert.assertEquals((Object)section, (Object)removedSection);
    }

    @Test
    public void testRemoveNonExistingSection() {
        DialogSettings dialogSettings = new DialogSettings(null);
        dialogSettings.addNewSection("new-section");
        Assert.assertEquals((long)1L, (long)dialogSettings.getSections().length);
        DialogSettings otherSection = new DialogSettings(null);
        dialogSettings.removeSection((IDialogSettings)otherSection);
        Assert.assertEquals((long)1L, (long)dialogSettings.getSections().length);
    }

    @Test
    public void testRemoveOtherSection() {
        DialogSettings dialogSettings = new DialogSettings(null);
        dialogSettings.addNewSection("new-section");
        Assert.assertEquals((long)1L, (long)dialogSettings.getSections().length);
        DialogSettings otherSection = new DialogSettings("new-section");
        dialogSettings.removeSection((IDialogSettings)otherSection);
        Assert.assertEquals((long)1L, (long)dialogSettings.getSections().length);
    }

    @Test
    public void testRemoveSectionWithNullArgument() {
        DialogSettings dialogSettings = new DialogSettings(null);
        try {
            dialogSettings.removeSection(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testKeys() throws IOException {
        String[] stringArray = TEST_STRINGS;
        int n = TEST_STRINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String testString;
            final String key = testString = stringArray[n2];
            DialogSettingsTest.testPutAndGet(new DialogSettingsChecker(){

                @Override
                public void prepareAndCheckBeforeSerialization(IDialogSettings dialogSettingsToSerialize) {
                    Assert.assertNull((Object)dialogSettingsToSerialize.get(key));
                    dialogSettingsToSerialize.put(key, "some string");
                    Assert.assertEquals((Object)"some string", (Object)dialogSettingsToSerialize.get(key));
                }

                @Override
                public void checkAfterDeserialization(IDialogSettings deserializedDialogSettings) {
                    Assert.assertEquals((Object)"some string", (Object)deserializedDialogSettings.get(key));
                }
            });
            ++n2;
        }
    }

    @Test
    public void testGet() throws IOException {
        String[] stringArray = TEST_STRINGS;
        int n = TEST_STRINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String testString;
            final String value = testString = stringArray[n2];
            DialogSettingsTest.testPutAndGet(new DialogSettingsChecker(){

                @Override
                public void prepareAndCheckBeforeSerialization(IDialogSettings dialogSettingsToSerialize) {
                    dialogSettingsToSerialize.put("someKey", value);
                    Assert.assertEquals((Object)value, (Object)dialogSettingsToSerialize.get("someKey"));
                }

                @Override
                public void checkAfterDeserialization(IDialogSettings deserializedDialogSettings) {
                    Assert.assertEquals((Object)value, (Object)deserializedDialogSettings.get("someKey"));
                }
            });
            ++n2;
        }
    }

    @Test
    public void testGetArray() throws IOException {
        String[] stringArray = TEST_STRINGS;
        int n = TEST_STRINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String testString;
            final String value1 = testString = stringArray[n2];
            String[] stringArray2 = TEST_STRINGS;
            int n3 = TEST_STRINGS.length;
            int n4 = 0;
            while (n4 < n3) {
                String otherTestString;
                final String value2 = otherTestString = stringArray2[n4];
                final String[] value = new String[]{value1, value2};
                DialogSettingsTest.testPutAndGet(new DialogSettingsChecker(){

                    @Override
                    public void prepareAndCheckBeforeSerialization(IDialogSettings dialogSettingsToSerialize) {
                        dialogSettingsToSerialize.put("someKey", value);
                        Assert.assertEquals((long)2L, (long)dialogSettingsToSerialize.getArray("someKey").length);
                        Assert.assertEquals((Object)value1, (Object)dialogSettingsToSerialize.getArray("someKey")[0]);
                        Assert.assertEquals((Object)value2, (Object)dialogSettingsToSerialize.getArray("someKey")[1]);
                        dialogSettingsToSerialize.put("anotherKey1", new String[0]);
                    }

                    @Override
                    public void checkAfterDeserialization(IDialogSettings deserializedDialogSettings) {
                        Assert.assertEquals((long)2L, (long)deserializedDialogSettings.getArray("someKey").length);
                        Assert.assertEquals((Object)value1, (Object)deserializedDialogSettings.getArray("someKey")[0]);
                        Assert.assertEquals((Object)value2, (Object)deserializedDialogSettings.getArray("someKey")[1]);
                        Assert.assertEquals((long)0L, (long)deserializedDialogSettings.getArray("anotherKey1").length);
                    }
                });
                ++n4;
            }
            ++n2;
        }
    }

    @Test
    public void testGetBoolean() throws IOException {
        DialogSettingsTest.testPutAndGet(new DialogSettingsChecker(){

            @Override
            public void prepareAndCheckBeforeSerialization(IDialogSettings dialogSettingsToSerialize) {
                dialogSettingsToSerialize.put("true", true);
                dialogSettingsToSerialize.put("false", false);
                Assert.assertTrue((boolean)dialogSettingsToSerialize.getBoolean("true"));
                Assert.assertFalse((boolean)dialogSettingsToSerialize.getBoolean("false"));
            }

            @Override
            public void checkAfterDeserialization(IDialogSettings deserializedDialogSettings) {
                Assert.assertTrue((boolean)deserializedDialogSettings.getBoolean("true"));
                Assert.assertFalse((boolean)deserializedDialogSettings.getBoolean("false"));
            }
        });
    }

    @Test
    public void testGetDouble() throws IOException {
        double[] values;
        double[] dArray = values = new double[]{-3.1415, 1.0, 0.0, 4554.45235, Double.MAX_VALUE, Double.MIN_VALUE, Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double testValue;
            final double value = testValue = dArray[n2];
            DialogSettingsTest.testPutAndGet(new DialogSettingsChecker(){

                @Override
                public void prepareAndCheckBeforeSerialization(IDialogSettings dialogSettingsToSerialize) {
                    dialogSettingsToSerialize.put("someKey", value);
                    double d = dialogSettingsToSerialize.getDouble("someKey");
                    if (Double.isNaN(value)) {
                        Assert.assertTrue((boolean)Double.isNaN(d));
                    } else {
                        Assert.assertEquals((double)value, (double)d, (double)1.0E-7f);
                    }
                }

                @Override
                public void checkAfterDeserialization(IDialogSettings deserializedDialogSettings) {
                    double d = deserializedDialogSettings.getDouble("someKey");
                    if (Double.isNaN(value)) {
                        Assert.assertTrue((boolean)Double.isNaN(d));
                    } else {
                        Assert.assertEquals((double)value, (double)d, (double)1.0E-7f);
                    }
                }
            });
            ++n2;
        }
    }

    @Test
    public void testGetFloat() throws IOException {
        float[] values;
        float[] fArray = values = new float[]{-3.1415f, 1.0f, 0.0f, 4554.452f, Float.MAX_VALUE, Float.MIN_VALUE, Float.NaN, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY};
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float testValue;
            final float value = testValue = fArray[n2];
            DialogSettingsTest.testPutAndGet(new DialogSettingsChecker(){

                @Override
                public void prepareAndCheckBeforeSerialization(IDialogSettings dialogSettingsToSerialize) {
                    dialogSettingsToSerialize.put("someKey", value);
                    float f = dialogSettingsToSerialize.getFloat("someKey");
                    if (Float.isNaN(value)) {
                        Assert.assertTrue((boolean)Float.isNaN(f));
                    } else {
                        Assert.assertEquals((float)value, (float)f, (float)1.0E-7f);
                    }
                }

                @Override
                public void checkAfterDeserialization(IDialogSettings deserializedDialogSettings) {
                    float f = deserializedDialogSettings.getFloat("someKey");
                    if (Float.isNaN(value)) {
                        Assert.assertTrue((boolean)Float.isNaN(f));
                    } else {
                        Assert.assertEquals((float)value, (float)f, (float)1.0E-7f);
                    }
                }
            });
            ++n2;
        }
    }

    @Test
    public void testGetInt() throws IOException {
        int[] values;
        int[] nArray = new int[6];
        nArray[0] = 36254;
        nArray[2] = 1;
        nArray[3] = -36254;
        nArray[4] = Integer.MAX_VALUE;
        nArray[5] = Integer.MIN_VALUE;
        int[] nArray2 = values = nArray;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int testValue;
            final int value = testValue = nArray2[n2];
            DialogSettingsTest.testPutAndGet(new DialogSettingsChecker(){

                @Override
                public void prepareAndCheckBeforeSerialization(IDialogSettings dialogSettingsToSerialize) {
                    dialogSettingsToSerialize.put("someKey", value);
                    Assert.assertEquals((long)value, (long)dialogSettingsToSerialize.getInt("someKey"));
                }

                @Override
                public void checkAfterDeserialization(IDialogSettings deserializedDialogSettings) {
                    Assert.assertEquals((long)value, (long)deserializedDialogSettings.getInt("someKey"));
                }
            });
            ++n2;
        }
    }

    @Test
    public void testGetLong() throws IOException {
        long[] values;
        long[] lArray = new long[6];
        lArray[0] = 36254L;
        lArray[2] = 1L;
        lArray[3] = -36254L;
        lArray[4] = Long.MAX_VALUE;
        lArray[5] = Long.MIN_VALUE;
        long[] lArray2 = values = lArray;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long testValue;
            final long value = testValue = lArray2[n2];
            DialogSettingsTest.testPutAndGet(new DialogSettingsChecker(){

                @Override
                public void prepareAndCheckBeforeSerialization(IDialogSettings dialogSettingsToSerialize) {
                    dialogSettingsToSerialize.put("someKey", value);
                    Assert.assertEquals((long)value, (long)dialogSettingsToSerialize.getLong("someKey"));
                }

                @Override
                public void checkAfterDeserialization(IDialogSettings deserializedDialogSettings) {
                    Assert.assertEquals((long)value, (long)deserializedDialogSettings.getLong("someKey"));
                }
            });
            ++n2;
        }
    }

    private static void testPutAndGet(DialogSettingsChecker dialogSettingsChecker) throws IOException {
        DialogSettingsTest.testPutAndGetWithTitle(dialogSettingsChecker, "DialogSettingsTest");
    }

    private static void testPutAndGetWithTitle(DialogSettingsChecker dialogSettingsChecker, String sectionName) throws IOException {
        DialogSettings dialogSettingsToSerialize = new DialogSettings(sectionName);
        dialogSettingsChecker.prepareAndCheckBeforeSerialization((IDialogSettings)dialogSettingsToSerialize);
        Throwable throwable = null;
        Object var4_5 = null;
        try (StringWriter writer = new StringWriter();){
            dialogSettingsToSerialize.save((Writer)writer);
            StringReader reader = new StringReader(writer.getBuffer().toString());
            DialogSettings deserializedDialogSettings = new DialogSettings("");
            deserializedDialogSettings.load((Reader)reader);
            dialogSettingsChecker.checkAfterDeserialization((IDialogSettings)deserializedDialogSettings);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSaveWithIOException() {
        DialogSettings settings = new DialogSettings("test");
        try {
            settings.save((Writer)new BrokenWriter());
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class BrokenWriter
    extends Writer {
        private BrokenWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            throw new IOException("Bang!");
        }

        @Override
        public void close() throws IOException {
            throw new IOException("Bang!");
        }

        @Override
        public void flush() throws IOException {
            throw new IOException("Bang!");
        }
    }

    private static interface DialogSettingsChecker {
        public void prepareAndCheckBeforeSerialization(IDialogSettings var1);

        public void checkAfterDeserialization(IDialogSettings var1);
    }
}

