/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DialogTest {
    private Dialog dialog;

    @After
    public void tearDown() throws Exception {
        if (this.dialog != null) {
            this.dialog.close();
            this.dialog = null;
        }
    }

    @Test
    public void testButtonAlignmentBug272583() {
        ForceLayoutDialog forceLayoutDialog = new ForceLayoutDialog();
        this.dialog = forceLayoutDialog;
        forceLayoutDialog.setBlockOnOpen(false);
        forceLayoutDialog.open();
        Button okBtn = forceLayoutDialog.getButton(0);
        Button cancelBtn = forceLayoutDialog.getButton(1);
        int okX = okBtn.getBounds().x;
        int cancelX = cancelBtn.getBounds().x;
        if (okBtn.getDisplay().getDismissalAlignment() == 16384) {
            Assert.assertTrue((String)"The 'OK' button should be to the left of the 'Cancel' button", (okX < cancelX ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"The 'OK' button should be to the right of the 'Cancel' button", (cancelX < okX ? 1 : 0) != 0);
        }
        forceLayoutDialog.close();
    }

    private class ForceLayoutDialog
    extends Dialog {
        ForceLayoutDialog() {
            super(null);
        }

        protected Control createContents(Composite parent) {
            Control contents = super.createContents(parent);
            this.getShell().layout(new Control[]{this.getButton(0)});
            return contents;
        }

        protected Button getButton(int id) {
            return super.getButton(id);
        }
    }
}

