/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.dialogs;

import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.PlainMessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PlainMessageDialogTest {
    private PlainMessageDialog.Builder builder;
    private PlainMessageDialog dialog;

    @Before
    public void setup() {
        Shell shell = new Shell(Display.getDefault());
        this.builder = PlainMessageDialog.getBuilder((Shell)shell, (String)"My Dialog");
    }

    @After
    public void tearDown() {
        if (this.dialog != null) {
            this.dialog.close();
        }
    }

    @Test
    public void createsDialogInShellWithTitle() {
        this.createAndOpenDialog();
        Assert.assertEquals((Object)"My Dialog", (Object)this.dialog.getShell().getText());
    }

    @Test
    public void createsDialogWithMessage() {
        this.builder.message("Hello World!");
        this.createAndOpenDialog();
        Label label = (Label)this.dialog.getShell().getChildren()[0];
        Assert.assertEquals((Object)"Hello World!", (Object)label.getText());
    }

    @Test
    public void createsDialogWithButtons() {
        this.builder.buttonLabels(Arrays.asList("Yes", "No", "Cancel"));
        this.createAndOpenDialog();
        Composite buttonComposite = (Composite)this.dialog.getShell().getChildren()[1];
        Button left = (Button)buttonComposite.getChildren()[0];
        Button middle = (Button)buttonComposite.getChildren()[1];
        Button right = (Button)buttonComposite.getChildren()[2];
        if (Platform.getOS().equals("win32")) {
            Assert.assertEquals((Object)"Yes", (Object)left.getText());
            Assert.assertEquals((Object)"No", (Object)middle.getText());
            Assert.assertEquals((Object)"Cancel", (Object)right.getText());
        } else {
            Assert.assertEquals((Object)"No", (Object)left.getText());
            Assert.assertEquals((Object)"Cancel", (Object)middle.getText());
            Assert.assertEquals((Object)"Yes", (Object)right.getText());
        }
    }

    @Test
    public void createsDialogWithDefaultButton() {
        this.builder.buttonLabels(Arrays.asList("Yes", "No", "Cancel")).defaultButtonIndex(1);
        this.createAndOpenDialog();
        Composite buttonComposite = (Composite)this.dialog.getShell().getChildren()[1];
        Button left = (Button)buttonComposite.getChildren()[0];
        Button middle = (Button)buttonComposite.getChildren()[1];
        Button right = (Button)buttonComposite.getChildren()[2];
        Assert.assertEquals((Object)"Yes", (Object)left.getText());
        if (Platform.getOS().equals("win32")) {
            Assert.assertEquals((Object)"No", (Object)middle.getText());
            Assert.assertEquals((Object)"Cancel", (Object)right.getText());
        } else {
            Assert.assertEquals((Object)"Cancel", (Object)middle.getText());
            Assert.assertEquals((Object)"No", (Object)right.getText());
        }
    }

    private void createAndOpenDialog() {
        this.dialog = this.builder.build();
        this.dialog.create();
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
    }
}

