/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.dialogs;

import java.lang.reflect.Field;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Test;

public class ProgressIndicatorStyleTest {
    protected ProgressIndicator progress;
    protected ProgressBar deter;
    protected ProgressBar indeter;
    protected int style;

    @Test
    public void testProgressIndicator() {
        this.style = 65536;
        this.verifyIndicator();
        this.style = 512;
        this.verifyIndicator();
        this.style = 256;
        this.verifyIndicator();
    }

    private void verifyIndicator() {
        Shell shell = new Shell();
        this.progress = new ProgressIndicator((Composite)shell, this.style);
        this.progress.setSize(175, 175);
        shell.setSize(200, 200);
        shell.open();
        shell.forceActive();
        this.progress.beginTask(100);
        this.progress.worked(50.0);
        this.loader("determinateProgressBar", this.deter);
        this.loader("indeterminateProgressBar", this.indeter);
        long timeout = System.currentTimeMillis() + 1000L;
        while (System.currentTimeMillis() < timeout) {
            shell.getDisplay().readAndDispatch();
        }
        shell.close();
        this.progress.dispose();
    }

    private void loader(String field, ProgressBar p) {
        Class<?> c = this.progress.getClass();
        try {
            Field f = c.getDeclaredField(field);
            f.setAccessible(true);
            p = (ProgressBar)f.get(this.progress);
            Assert.assertEquals((long)this.style, (long)(p.getStyle() & this.style));
        }
        catch (NoSuchFieldException e) {
            System.err.println("No such field");
        }
        catch (IllegalAccessException e) {
            System.err.println("Illegal Access");
        }
    }
}

