/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.dialogs;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.junit.Assert;
import org.junit.Test;

public class SafeRunnableErrorTest {
    int count;

    protected Thread runner() {
        return new Thread(() -> {
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    throw new RuntimeException("test exception " + ++SafeRunnableErrorTest.this.count);
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
        });
    }

    @Test
    public void testSafeRunnableHandler() {
        SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                throw new RuntimeException("test exception");
            }
        });
    }

    @Test
    public void testSafeRunnableHandlerOtherThread() throws Exception {
        Thread t = this.runner();
        t.run();
        t.join();
    }

    @Test
    public void testSafeRunnableHandlerMulti() {
        SafeRunnable runnable = new SafeRunnable(){

            public void run() throws Exception {
                throw new RuntimeException("test exception " + ++SafeRunnableErrorTest.this.count);
            }
        };
        int expectedRuns = 3;
        int run = 0;
        while (run < expectedRuns) {
            SafeRunnable.run((ISafeRunnable)runnable);
            ++run;
        }
        Assert.assertEquals((long)expectedRuns, (long)this.count);
    }
}

