/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.fieldassist;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.tests.fieldassist.AbstractFieldAssistWindow;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.tests.harness.util.TestRunLogUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestWatcher;

public abstract class AbstractFieldAssistTestCase {
    @Rule
    public TestWatcher LOG_TESTRUN = TestRunLogUtil.LOG_TESTRUN;
    private AbstractFieldAssistWindow window;
    private Shell anotherShell;
    private int originalShellCount;

    @Before
    public final void setUp() throws Exception {
        Display display = this.getDisplay();
        this.anotherShell = new Shell(display);
        new Text((Composite)this.anotherShell, 4);
        this.anotherShell.open();
        this.spinEventLoop();
        this.originalShellCount = display.getShells().length;
        this.window = this.createFieldAssistWindow();
        Assert.assertNotNull((Object)((Object)this.window));
    }

    @After
    public final void tearDown() throws Exception {
        if (this.window != null) {
            this.spinEventLoop();
        }
        this.closeFieldAssistWindow();
        this.anotherShell.close();
    }

    protected Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected void closeFieldAssistWindow() {
        if (this.window != null) {
            this.window.close();
            this.window = null;
        }
    }

    protected abstract AbstractFieldAssistWindow createFieldAssistWindow();

    protected AbstractFieldAssistWindow getFieldAssistWindow() {
        return this.window;
    }

    protected void spinEventLoop() {
        Display disp = this.getDisplay();
        while (disp.readAndDispatch()) {
        }
    }

    protected void ensurePopupIsUp() {
        if (this.window.getAutoActivationDelay() == 0) {
            this.spinEventLoop();
        } else {
            long time = System.currentTimeMillis();
            long target = time + (long)this.window.getAutoActivationDelay();
            while (target > time) {
                this.spinEventLoop();
                time = System.currentTimeMillis();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.spinEventLoop();
        }
    }

    protected void sendFocusInToControl() {
        this.window.getFieldAssistControl().setFocus();
        this.spinEventLoop();
    }

    protected void sendFocusElsewhere() {
        this.anotherShell.setFocus();
        this.spinEventLoop();
    }

    protected void sendFocusToPopup() {
        this.getFieldAssistWindow().getContentProposalAdapter().setProposalPopupFocus();
        this.spinEventLoop();
    }

    protected void sendKeyDownToControl(char character) {
        this.sendFocusInToControl();
        Event event = new Event();
        event.type = 1;
        event.character = character;
        Assert.assertTrue((String)"unable to post event to display queue for test case", (boolean)this.window.getDisplay().post(event));
        this.spinEventLoop();
    }

    protected void sendKeyDownToControl(KeyStroke keystroke) {
        this.sendFocusInToControl();
        Event event = new Event();
        event.type = 1;
        event.keyCode = keystroke.getNaturalKey();
        Assert.assertTrue((String)"unable to post event to display queue for test case", (boolean)this.window.getDisplay().post(event));
        this.spinEventLoop();
    }

    protected void assertOneShellUp() {
        this.spinEventLoop();
        Assert.assertEquals((String)"There should only be one shell up, the dialog", (long)(this.originalShellCount + 1), (long)this.window.getDisplay().getShells().length);
    }

    protected void assertTwoShellsUp() {
        this.spinEventLoop();
        Assert.assertEquals((String)"There should two shells up, the dialog and the proposals dialog", (long)(this.originalShellCount + 2), (long)this.window.getDisplay().getShells().length);
    }

    protected void setControlContent(String text) {
        this.window.getControlContentAdapter().setControlContents(this.window.getFieldAssistControl(), text, text.length());
    }

    protected String getControlContent() {
        return this.window.getControlContentAdapter().getControlContents(this.window.getFieldAssistControl());
    }
}

