/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.fieldassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractFieldAssistWindow
extends Window {
    private Control fieldAssistControl;
    private IContentProposalProvider proposalProvider;
    private KeyStroke keyStroke = null;
    private char[] autoActivationCharacters = null;
    private int filterStyle = 1;
    private boolean propagateKeys = true;
    private int acceptance = 1;
    private int autoActivationDelay = 0;
    private ContentProposalAdapter adapter;

    public AbstractFieldAssistWindow() {
        super(null);
    }

    public Display getDisplay() {
        return this.getShell().getDisplay();
    }

    protected Control createContents(Composite parent) {
        Composite content = (Composite)super.createContents(parent);
        content.setLayout((Layout)new FillLayout());
        this.fieldAssistControl = this.createFieldAssistControl(parent);
        Assert.isNotNull((Object)this.fieldAssistControl);
        this.adapter = this.createContentProposalAdapter(this.fieldAssistControl);
        this.adapter.setAutoActivationDelay(this.autoActivationDelay);
        this.adapter.setFilterStyle(this.filterStyle);
        this.adapter.setPropagateKeys(this.propagateKeys);
        this.adapter.setProposalAcceptanceStyle(this.acceptance);
        this.createExtraControls(parent);
        return content;
    }

    protected void createExtraControls(Composite parent) {
    }

    protected Layout getLayout() {
        return new FillLayout();
    }

    protected ContentProposalAdapter createContentProposalAdapter(Control control) {
        return new ContentProposalAdapter(control, this.getControlContentAdapter(), this.getContentProposalProvider(), this.getKeyStroke(), this.getAutoActivationCharacters());
    }

    protected abstract IControlContentAdapter getControlContentAdapter();

    public Control getFieldAssistControl() {
        return this.fieldAssistControl;
    }

    protected abstract Control createFieldAssistControl(Composite var1);

    public void setAutoActivationDelay(int autoActivationDelay) {
        this.autoActivationDelay = autoActivationDelay;
    }

    public final int getAutoActivationDelay() {
        return this.autoActivationDelay;
    }

    protected boolean shouldFilterProposals() {
        return true;
    }

    protected String[] getProposals() {
        return new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};
    }

    protected char[] getAutoActivationCharacters() {
        return this.autoActivationCharacters;
    }

    public void setAutoActivationCharacters(char[] autoActivationCharacters) {
        this.autoActivationCharacters = autoActivationCharacters;
    }

    protected IContentProposalProvider createContentProposalProvider() {
        SimpleContentProposalProvider proposalProvider = new SimpleContentProposalProvider(this.getProposals());
        proposalProvider.setFiltering(this.shouldFilterProposals());
        return proposalProvider;
    }

    protected IContentProposalProvider getContentProposalProvider() {
        if (this.proposalProvider == null) {
            this.proposalProvider = this.createContentProposalProvider();
        }
        return this.proposalProvider;
    }

    protected ContentProposalAdapter getContentProposalAdapter() {
        return this.adapter;
    }

    public void setContentProposalProvider(IContentProposalProvider proposalProvider) {
        this.proposalProvider = proposalProvider;
    }

    public void setFilterStyle(int filterStyle) {
        this.filterStyle = filterStyle;
    }

    public void setPropagateKeys(boolean propagateKeys) {
        this.propagateKeys = propagateKeys;
    }

    public void setProposalAcceptanceStyle(int acceptance) {
        this.acceptance = acceptance;
    }

    protected KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
    }
}

