/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.fieldassist;

import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.tests.harness.util.TestRunLogUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class ContentProposalAdapterTest {
    @Rule
    public TestWatcher LOG_TESTRUN = TestRunLogUtil.LOG_TESTRUN;
    private Shell controlShell;
    private Text text;
    private ContentProposalAdapter contentProposalAdapter;
    private Display display;
    private boolean disposeDisplay;
    private int originalShellCount;

    @Test
    public void testBug520372AutoActivationDelayTab() throws Exception {
        this.sendKeyDownToControl('o');
        this.sendKeyDownToControl('\t');
        this.ensurePopupIsUp();
        this.assertOneShellUp();
    }

    @Test
    public void testBug520372AutoActivationDelayCR() throws Exception {
        this.sendKeyDownToControl('o');
        this.sendKeyDownToControl('\r');
        this.ensurePopupIsUp();
        this.assertOneShellUp();
    }

    @Test
    public void testBug520372AutoActivationDelayESC() throws Exception {
        this.sendKeyDownToControl('o');
        this.sendKeyDownToControl('\u001b');
        this.ensurePopupIsUp();
        this.assertOneShellUp();
    }

    @Before
    public final void setUp() throws Exception {
        Display display = this.getDisplay();
        this.originalShellCount = display.getShells().length;
        this.controlShell = new Shell(display);
        this.text = new Text((Composite)this.controlShell, 4);
        this.controlShell.open();
        this.spinEventLoop();
        this.contentProposalAdapter = ContentProposalAdapterTest.createContentProposalAdapter((Control)this.text);
        Assert.assertNotNull((Object)this.contentProposalAdapter);
    }

    @After
    public final void tearDown() throws Exception {
        if (this.controlShell != null) {
            this.spinEventLoop();
            this.controlShell.close();
        }
        if (this.display != null) {
            if (this.disposeDisplay) {
                this.display.dispose();
            }
            this.display = null;
        }
    }

    private Display getDisplay() {
        if (this.display == null) {
            Display newDisplay = Display.getCurrent();
            if (newDisplay == null) {
                newDisplay = new Display();
                this.disposeDisplay = true;
            }
            this.display = newDisplay;
        }
        return this.display;
    }

    private void sendFocusInToControl() {
        this.text.setFocus();
        this.spinEventLoop();
    }

    private void sendKeyDownToControl(char character) {
        this.sendFocusInToControl();
        Event event = new Event();
        event.type = 1;
        event.character = character;
        Assert.assertTrue((String)"unable to post event to display queue for test case", (boolean)this.text.getDisplay().post(event));
        this.spinEventLoop();
    }

    private void spinEventLoop() {
        Display disp = this.getDisplay();
        while (disp.readAndDispatch()) {
        }
    }

    private static ContentProposalAdapter createContentProposalAdapter(Control control) {
        ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter(control, (IControlContentAdapter)new TextContentAdapter(), ContentProposalAdapterTest.createContentProposalProvider(), null, null);
        contentProposalAdapter.setAutoActivationDelay(2000);
        return contentProposalAdapter;
    }

    private static IContentProposalProvider createContentProposalProvider() {
        return new SimpleContentProposalProvider(ContentProposalAdapterTest.getProposals());
    }

    private static String[] getProposals() {
        return new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};
    }

    private void ensurePopupIsUp() {
        if (this.contentProposalAdapter.getAutoActivationDelay() == 0) {
            this.spinEventLoop();
        } else {
            long time = System.currentTimeMillis();
            long target = time + (long)this.contentProposalAdapter.getAutoActivationDelay();
            while (target > time) {
                this.spinEventLoop();
                time = System.currentTimeMillis();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.spinEventLoop();
        }
    }

    private void assertOneShellUp() {
        this.spinEventLoop();
        Assert.assertEquals((String)"There should only be one shell up, the dialog", (long)(this.originalShellCount + 1), (long)this.text.getDisplay().getShells().length);
    }
}

