/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.fieldassist;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.tests.fieldassist.AbstractFieldAssistTestCase;
import org.eclipse.jface.tests.fieldassist.AbstractFieldAssistWindow;
import org.eclipse.jface.tests.fieldassist.TextFieldAssistWindow;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ControlDecorationTests
extends AbstractFieldAssistTestCase {
    private Text anotherControl;

    @Test
    public void testDecorationIsVisible() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.open();
        ControlDecoration decoration = new ControlDecoration(this.getFieldAssistWindow().getFieldAssistControl(), 131072);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        decoration.setDescriptionText("foo");
        window.open();
        Assert.assertTrue((String)"1.0", (boolean)decoration.isVisible());
        decoration.hide();
        Assert.assertFalse((String)"1.1", (boolean)decoration.isVisible());
        decoration.show();
        Assert.assertTrue((String)"1.2", (boolean)decoration.isVisible());
        window.getFieldAssistControl().setVisible(false);
        Assert.assertFalse((String)"1.3", (boolean)decoration.isVisible());
        window.getFieldAssistControl().setVisible(true);
        Assert.assertTrue((String)"1.4", (boolean)decoration.isVisible());
        decoration.setShowOnlyOnFocus(true);
        this.anotherControl.setFocus();
        this.spinEventLoop();
    }

    @Test
    public void testHoverVisibility() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.open();
        ControlDecoration decoration = new ControlDecoration(window.getFieldAssistControl(), 131072);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        decoration.setDescriptionText("foo");
        Assert.assertTrue((String)"1.0", (boolean)decoration.isVisible());
        this.assertOneShellUp();
        decoration.hide();
        decoration.showHoverText("Show me");
        this.assertOneShellUp();
        decoration.show();
        this.getFieldAssistWindow().getFieldAssistControl().setVisible(false);
        decoration.showHoverText("Show me");
        this.assertOneShellUp();
        this.getFieldAssistWindow().getFieldAssistControl().setVisible(true);
        decoration.showHoverText("Show me");
        this.assertTwoShellsUp();
    }

    @Test
    @Ignore(value="Disabled see Bug 418420 and bug 275393")
    public void testBug418420() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.open();
        ControlDecoration decoration = new ControlDecoration(window.getFieldAssistControl(), 131072);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        decoration.setDescriptionText("foo");
        decoration.setShowOnlyOnFocus(true);
        this.anotherControl.forceFocus();
        decoration.showHoverText("Show me");
        this.assertOneShellUp();
    }

    @Override
    protected AbstractFieldAssistWindow createFieldAssistWindow() {
        return new TextFieldAssistWindow(){

            @Override
            protected void createExtraControls(Composite parent) {
                ControlDecorationTests.this.anotherControl = new Text(parent, -1);
            }
        };
    }
}

