/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.fieldassist;

import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.tests.fieldassist.AbstractFieldAssistTestCase;
import org.eclipse.jface.tests.fieldassist.AbstractFieldAssistWindow;
import org.eclipse.jface.tests.fieldassist.TextFieldAssistWindow;
import org.junit.Assert;
import org.junit.Test;

public class FieldAssistAPITests
extends AbstractFieldAssistTestCase {
    private final String description = "Description";
    private final String label = "LabelForName";
    private final String content = "Name";
    private IContentProposal proposal;

    @Test
    public void testSimpleContentProposal() {
        this.proposal = new ContentProposal("Name");
        Assert.assertEquals((String)"1.0", (Object)"Name", (Object)this.proposal.getContent());
        Assert.assertEquals((String)"1.1", (Object)"Name", (Object)this.proposal.getLabel());
        Assert.assertNull((String)"1.2", (Object)this.proposal.getDescription());
        Assert.assertEquals((String)"1.3", (long)"Name".length(), (long)this.proposal.getCursorPosition());
    }

    @Test
    public void testContentProposalWithCursor() {
        this.proposal = new ContentProposal("Name", "LabelForName", "Description", 3);
        Assert.assertEquals((String)"3.0", (Object)"Name", (Object)this.proposal.getContent());
        Assert.assertEquals((String)"3.1", (Object)"LabelForName", (Object)this.proposal.getLabel());
        Assert.assertEquals((String)"3.2", (Object)"Description", (Object)this.proposal.getDescription());
        Assert.assertEquals((String)"3.3", (long)3L, (long)this.proposal.getCursorPosition());
    }

    @Test
    public void testContentProposalWithLabel() {
        this.proposal = new ContentProposal("Name", "LabelForName", "Description");
        Assert.assertEquals((String)"3.0", (Object)"Name", (Object)this.proposal.getContent());
        Assert.assertEquals((String)"3.1", (Object)"LabelForName", (Object)this.proposal.getLabel());
        Assert.assertEquals((String)"3.2", (Object)"Description", (Object)this.proposal.getDescription());
        Assert.assertEquals((String)"3.3", (long)"Name".length(), (long)this.proposal.getCursorPosition());
    }

    @Test
    public void testContentProposalWithDescription() {
        this.proposal = new ContentProposal("Name", "Description");
        Assert.assertEquals((String)"2.0", (Object)"Name", (Object)this.proposal.getContent());
        Assert.assertEquals((String)"2.1", (Object)"Name", (Object)this.proposal.getLabel());
        Assert.assertEquals((String)"2.2", (Object)"Description", (Object)this.proposal.getDescription());
        Assert.assertEquals((String)"2.3", (long)"Name".length(), (long)this.proposal.getCursorPosition());
    }

    public void testInitializationWithInvalidCursor() {
        try {
            this.proposal = new ContentProposal("Name", "LabelForName", "Description", 100);
            Assert.fail((String)"4.0");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNull((String)"It is expected to be null", (Object)this.proposal);
        }
    }

    @Override
    protected AbstractFieldAssistWindow createFieldAssistWindow() {
        return new TextFieldAssistWindow();
    }
}

