/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.fieldassist;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.tests.fieldassist.AbstractFieldAssistTestCase;
import org.eclipse.jface.tests.fieldassist.AbstractFieldAssistWindow;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Test;

public abstract class FieldAssistTestCase
extends AbstractFieldAssistTestCase {
    static final String SAMPLE_CONTENT = "s";
    static final char ACTIVATE_CHAR = 'i';
    static final char EXTRA_CHAR = 'b';

    @Test
    public void testAutoactivateNoDelay() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(false);
        window.setAutoActivationDelay(0);
        window.setAutoActivationCharacters(new char[]{'i'});
        window.open();
        this.setControlContent(SAMPLE_CONTENT);
        this.sendKeyDownToControl('i');
        this.ensurePopupIsUp();
        this.assertTwoShellsUp();
    }

    @Test
    public void testAutoactivateWithDelay() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(false);
        window.setAutoActivationDelay(600);
        window.setAutoActivationCharacters(new char[]{'i'});
        window.open();
        this.setControlContent(SAMPLE_CONTENT);
        this.sendKeyDownToControl('i');
        this.ensurePopupIsUp();
        this.assertTwoShellsUp();
    }

    @Test
    public void testExplicitActivate() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(false);
        KeyStroke stroke = KeyStroke.getInstance((int)0x100000D);
        window.setKeyStroke(stroke);
        window.open();
        this.sendKeyDownToControl(stroke);
        this.assertTwoShellsUp();
    }

    @Test
    public void testPopupDeactivates() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(false);
        window.setAutoActivationDelay(0);
        window.setAutoActivationCharacters(new char[]{'i'});
        window.open();
        this.setControlContent(SAMPLE_CONTENT);
        this.sendKeyDownToControl('i');
        this.ensurePopupIsUp();
        this.assertTwoShellsUp();
        this.sendFocusElsewhere();
        this.spinEventLoop();
        this.assertOneShellUp();
    }

    @Test
    public void testPropagateKeysOff() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(false);
        window.setAutoActivationCharacters(new char[]{'i'});
        window.open();
        this.setControlContent(SAMPLE_CONTENT);
        this.sendKeyDownToControl('i');
        this.ensurePopupIsUp();
        this.assertTwoShellsUp();
        this.sendKeyDownToControl('b');
        Assert.assertEquals((String)"1.0", (Object)(SAMPLE_CONTENT + new String(new char[]{'i'})), (Object)this.getControlContent());
    }

    @Test
    public void testPropagateKeysOn() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(true);
        window.setAutoActivationCharacters(new char[]{'i'});
        window.open();
        this.setControlContent(SAMPLE_CONTENT);
        this.sendKeyDownToControl('i');
        this.ensurePopupIsUp();
        this.assertTwoShellsUp();
        this.sendKeyDownToControl('b');
        Assert.assertEquals((String)"1.0", (Object)(SAMPLE_CONTENT + new String(new char[]{'i', 'b'})), (Object)this.getControlContent());
    }

    @Test
    public void testBug262022() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(false);
        window.setAutoActivationCharacters(new char[]{'i'});
        window.open();
        this.setControlContent(SAMPLE_CONTENT);
        this.sendKeyDownToControl('i');
        this.ensurePopupIsUp();
        this.assertTwoShellsUp();
        Event event = new Event();
        event.type = 1;
        event.keyCode = 0x1000003;
        window.getDisplay().post(event);
        window.getDisplay().asyncExec(this::closeFieldAssistWindow);
        this.spinEventLoop();
    }

    @Test
    public void testBug279953() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(false);
        window.setAutoActivationCharacters(new char[]{'i'});
        window.open();
        this.assertOneShellUp();
        ControlDecoration decoration = new ControlDecoration(this.getFieldAssistWindow().getFieldAssistControl(), 131072);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        decoration.setDescriptionText("");
        decoration.showHoverText("");
        this.assertOneShellUp();
    }

    @Test
    public void testDecorationIsVisible() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(false);
        window.setAutoActivationCharacters(new char[]{'i'});
        window.open();
        this.assertOneShellUp();
        ControlDecoration decoration = new ControlDecoration(this.getFieldAssistWindow().getFieldAssistControl(), 131072);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        decoration.setDescriptionText("foo");
        this.spinEventLoop();
        Assert.assertTrue((String)"1.0", (boolean)decoration.isVisible());
        decoration.hide();
        Assert.assertFalse((String)"1.1", (boolean)decoration.isVisible());
        decoration.setShowOnlyOnFocus(true);
        this.sendFocusElsewhere();
        this.sendFocusInToControl();
        this.spinEventLoop();
        Assert.assertFalse((String)"1.2", (boolean)decoration.isVisible());
        decoration.show();
        Assert.assertTrue((String)"1.3", (boolean)decoration.isVisible());
        this.sendFocusElsewhere();
        this.spinEventLoop();
        Assert.assertFalse((String)"1.4", (boolean)decoration.isVisible());
        decoration.setShowOnlyOnFocus(false);
        Assert.assertTrue((String)"1.5", (boolean)decoration.isVisible());
        window.getFieldAssistControl().setVisible(false);
        Assert.assertFalse((String)"1.6", (boolean)decoration.isVisible());
        decoration.hide();
        window.getFieldAssistControl().setVisible(true);
        Assert.assertFalse((String)"1.7", (boolean)decoration.isVisible());
        decoration.show();
        Assert.assertTrue((String)"1.8", (boolean)decoration.isVisible());
    }

    @Test
    public void testPopupFocus() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(false);
        KeyStroke stroke = KeyStroke.getInstance((int)0x100000D);
        window.setKeyStroke(stroke);
        window.open();
        this.sendKeyDownToControl(stroke);
        this.assertTwoShellsUp();
        window.getFieldAssistControl().setFocus();
        this.spinEventLoop();
        Assert.assertFalse((String)"1.0", (boolean)window.getContentProposalAdapter().hasProposalPopupFocus());
        window.getContentProposalAdapter().setProposalPopupFocus();
        this.spinEventLoop();
        Assert.assertTrue((String)"1.1", (boolean)window.getContentProposalAdapter().hasProposalPopupFocus());
        this.sendFocusElsewhere();
        this.spinEventLoop();
        this.assertOneShellUp();
        Assert.assertFalse((String)"1.2", (boolean)window.getContentProposalAdapter().hasProposalPopupFocus());
    }

    @Test
    public void testPopupIsOpen() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(false);
        KeyStroke stroke = KeyStroke.getInstance((int)0x100000D);
        window.setKeyStroke(stroke);
        window.open();
        Assert.assertFalse((String)"1.0", (boolean)window.getContentProposalAdapter().isProposalPopupOpen());
        this.sendKeyDownToControl(stroke);
        this.assertTwoShellsUp();
        Assert.assertTrue((String)"1.1", (boolean)window.getContentProposalAdapter().isProposalPopupOpen());
        this.sendFocusElsewhere();
        this.spinEventLoop();
        this.assertOneShellUp();
        Assert.assertFalse((String)"1.2", (boolean)window.getContentProposalAdapter().isProposalPopupOpen());
    }

    @Test
    public void testBug256651ReplaceMode() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(false);
        window.setAutoActivationCharacters(new char[]{'i'});
        window.setProposalAcceptanceStyle(2);
        window.open();
        Display display = this.getDisplay();
        Rectangle displayBounds = display.getBounds();
        window.getShell().setLocation(0, displayBounds.height - window.getShell().getBounds().height);
        this.assertOneShellUp();
        this.setControlContent(SAMPLE_CONTENT);
        this.sendKeyDownToControl('i');
        this.ensurePopupIsUp();
        this.assertTwoShellsUp();
        this.sendFocusToPopup();
        Shell popupShell = display.getActiveShell();
        Rectangle popupBounds = popupShell.getBounds();
        Rectangle controlBounds = this.getFieldAssistWindow().getFieldAssistControl().getBounds();
        controlBounds = this.getDisplay().map((Control)this.getFieldAssistWindow().getFieldAssistControl().getParent(), null, controlBounds);
        Assert.assertFalse((String)"Popup is blocking the control", (boolean)popupBounds.intersects(controlBounds));
    }

    @Test
    public void testDefaultPopupPositioningReplaceMode() {
        AbstractFieldAssistWindow window = this.getFieldAssistWindow();
        window.setPropagateKeys(false);
        window.setAutoActivationCharacters(new char[]{'i'});
        window.setProposalAcceptanceStyle(2);
        window.open();
        Display display = this.getDisplay();
        window.getShell().setLocation(0, 0);
        this.assertOneShellUp();
        this.setControlContent(SAMPLE_CONTENT);
        this.sendKeyDownToControl('i');
        this.ensurePopupIsUp();
        this.assertTwoShellsUp();
        this.sendFocusToPopup();
        Shell popupShell = display.getActiveShell();
        Rectangle popupBounds = popupShell.getBounds();
        Rectangle controlBounds = this.getFieldAssistWindow().getFieldAssistControl().getBounds();
        controlBounds = this.getDisplay().map((Control)this.getFieldAssistWindow().getFieldAssistControl().getParent(), null, controlBounds);
        Assert.assertFalse((String)"Popup is blocking the control", (boolean)popupBounds.intersects(controlBounds));
    }
}

