/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.images;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DecorationOverlayIconTest {
    private ImageDescriptor baseDescriptor1;
    private Image baseImage1;
    private ImageDescriptor baseDescriptor2;
    private Image baseImage2;
    private ImageDescriptor overlayDescriptor1;
    private ImageDescriptor overlayDescriptor2;

    @Before
    public void setUp() {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        this.baseImage1 = imageRegistry.get("dialog_help_image");
        Assert.assertNotNull((Object)this.baseImage1);
        this.baseDescriptor1 = imageRegistry.getDescriptor("dialog_help_image");
        Assert.assertNotNull((Object)this.baseDescriptor1);
        this.baseImage2 = imageRegistry.get("dialog_message_error_image");
        Assert.assertNotNull((Object)this.baseImage2);
        this.baseDescriptor2 = imageRegistry.getDescriptor("dialog_message_error_image");
        Assert.assertNotNull((Object)this.baseDescriptor2);
        this.overlayDescriptor1 = imageRegistry.getDescriptor("dialog_messasge_info_image");
        Assert.assertNotNull((Object)this.overlayDescriptor1);
        this.overlayDescriptor2 = imageRegistry.getDescriptor("dialog_messasge_warning_image");
        Assert.assertNotNull((Object)this.overlayDescriptor2);
    }

    @Test
    public void testEqualsAndHashCode() {
        DecorationOverlayIcon icon1 = new DecorationOverlayIcon(this.baseImage1, new ImageDescriptor[]{this.overlayDescriptor1, this.overlayDescriptor2});
        DecorationOverlayIcon icon2 = new DecorationOverlayIcon(this.baseImage1, new ImageDescriptor[]{this.overlayDescriptor1, this.overlayDescriptor2});
        Assert.assertTrue((boolean)icon1.equals((Object)icon2));
        Assert.assertEquals((long)icon1.hashCode(), (long)icon2.hashCode());
        icon1 = new DecorationOverlayIcon(this.baseDescriptor1, this.overlayDescriptor1, 0);
        icon2 = new DecorationOverlayIcon(this.baseDescriptor1, this.overlayDescriptor1, 0);
        Assert.assertTrue((boolean)icon1.equals((Object)icon2));
        Assert.assertEquals((long)icon1.hashCode(), (long)icon2.hashCode());
        icon1 = new DecorationOverlayIcon(this.baseImage1, new ImageDescriptor[]{this.overlayDescriptor2});
        icon2 = new DecorationOverlayIcon(this.baseImage1, new ImageDescriptor[]{this.overlayDescriptor1});
        Assert.assertFalse((boolean)icon1.equals((Object)icon2));
        Assert.assertNotEquals((long)icon1.hashCode(), (long)icon2.hashCode());
        icon1 = new DecorationOverlayIcon(this.baseDescriptor1, this.overlayDescriptor1, 0);
        icon2 = new DecorationOverlayIcon(this.baseDescriptor1, this.overlayDescriptor2, 0);
        Assert.assertFalse((boolean)icon1.equals((Object)icon2));
        Assert.assertNotEquals((long)icon1.hashCode(), (long)icon2.hashCode());
        icon1 = new DecorationOverlayIcon(this.baseImage1, new ImageDescriptor[]{this.overlayDescriptor2});
        icon2 = new DecorationOverlayIcon(this.baseImage2, new ImageDescriptor[]{this.overlayDescriptor2});
        Assert.assertFalse((boolean)icon1.equals((Object)icon2));
        Assert.assertNotEquals((long)icon1.hashCode(), (long)icon2.hashCode());
        icon1 = new DecorationOverlayIcon(this.baseDescriptor1, this.overlayDescriptor2, 0);
        icon2 = new DecorationOverlayIcon(this.baseDescriptor2, this.overlayDescriptor2, 0);
        Assert.assertFalse((boolean)icon1.equals((Object)icon2));
        Assert.assertNotEquals((long)icon1.hashCode(), (long)icon2.hashCode());
        icon1 = new DecorationOverlayIcon(this.baseImage1, this.overlayDescriptor2, 0);
        icon2 = new DecorationOverlayIcon(this.baseDescriptor1, this.overlayDescriptor2, 0);
        Assert.assertFalse((boolean)icon1.equals((Object)icon2));
        Assert.assertNotEquals((long)icon1.hashCode(), (long)icon2.hashCode());
    }

    @Test
    public void testEqualsAndHashCode2() {
        SimpleImageDescriptor equalButDifferent1 = new SimpleImageDescriptor("pretend_file_name");
        SimpleImageDescriptor equalButDifferent2 = new SimpleImageDescriptor("pretend_file_name");
        Assert.assertTrue((boolean)equalButDifferent1.equals((Object)equalButDifferent2));
        Assert.assertEquals((long)equalButDifferent1.hashCode(), (long)equalButDifferent2.hashCode());
        DecorationOverlayIcon equalButDifferentIcon1 = new DecorationOverlayIcon((ImageDescriptor)equalButDifferent1, this.overlayDescriptor1, 0);
        DecorationOverlayIcon equalButDifferentIcon2 = new DecorationOverlayIcon((ImageDescriptor)equalButDifferent2, this.overlayDescriptor1, 0);
        Assert.assertTrue((boolean)equalButDifferentIcon1.equals((Object)equalButDifferentIcon2));
        Assert.assertEquals((long)equalButDifferentIcon1.hashCode(), (long)equalButDifferentIcon2.hashCode());
    }

    private static class SimpleImageDescriptor
    extends ImageDescriptor {
        private final String pretendFileName;

        public SimpleImageDescriptor(String pretendFileName) {
            this.pretendFileName = pretendFileName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pretendFileName == null ? 0 : this.pretendFileName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SimpleImageDescriptor other = (SimpleImageDescriptor)((Object)obj);
            return !(this.pretendFileName == null ? other.pretendFileName != null : !this.pretendFileName.equals(other.pretendFileName));
        }
    }
}

