/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.images;

import java.net.URL;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.junit.Assert;
import org.junit.Test;

public class DeferredImageDescriptorTest {
    @Test
    public void testDeferredLoading() {
        ImageData empty = ImageDescriptor.getMissingImageDescriptor().getImageData(100);
        Assert.assertEquals((Object)empty, (Object)ImageDescriptor.createFromURLSupplier((boolean)true, () -> null).getImageData(100));
        Assert.assertNull((Object)ImageDescriptor.createFromURLSupplier((boolean)false, () -> null).getImageData(100));
        Assert.assertNotNull((Object)ImageDescriptor.createFromURLSupplier((boolean)false, () -> {
            throw new IllegalArgumentException("Should not happen");
        }));
        Assert.assertNotNull((Object)ImageDescriptor.createFromURLSupplier((boolean)false, () -> DeferredImageDescriptorTest.class.getResource("anything.gif")).getImageData(100));
    }

    @Test
    public void testCreateImage() {
        Assert.assertNotNull((Object)ImageDescriptor.createFromURLSupplier((boolean)true, () -> DeferredImageDescriptorTest.class.getResource("anything.gif")).createImage());
    }

    @Test
    public void testAdaptToURL() {
        ImageDescriptor descriptor = ImageDescriptor.createFromURLSupplier((boolean)false, () -> DeferredImageDescriptorTest.class.getResource("anything.gif"));
        URL url = (URL)Adapters.adapt((Object)descriptor, URL.class);
        Assert.assertNotNull((String)"DeferredImageDescriptor does not adapt to URL", (Object)url);
        ImageDescriptor descriptorFromUrl = ImageDescriptor.createFromURL((URL)url);
        ImageData imageDataOrig = descriptor.getImageData(100);
        Assert.assertNotNull((String)"Original URL does not return 100% image data", (Object)imageDataOrig);
        ImageData imageDataURL = descriptorFromUrl.getImageData(100);
        Assert.assertNotNull((String)"Adapted URL does not return 100% image data", (Object)imageDataURL);
        Assert.assertEquals((long)imageDataOrig.width, (long)imageDataURL.width);
        Assert.assertEquals((long)imageDataOrig.height, (long)imageDataURL.height);
    }
}

