/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.images;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FileImageDescriptorTest {
    protected static final String IMAGES_DIRECTORY = "/icons/imagetests";

    @Test
    public void testFileImageDescriptorWorkbench() throws IOException {
        Class missing = null;
        ArrayList<Image> images = new ArrayList<Image>();
        Bundle bundle = FrameworkUtil.getBundle(FileImageDescriptorTest.class);
        Enumeration bundleEntries = bundle.getEntryPaths(IMAGES_DIRECTORY);
        while (bundleEntries.hasMoreElements()) {
            URL[] files;
            String localImagePath = (String)bundleEntries.nextElement();
            URL[] uRLArray = files = FileLocator.findEntries((Bundle)bundle, (IPath)IPath.fromOSString((String)localImagePath));
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                URL file = uRLArray[n2];
                if (file.getPath().lastIndexOf(46) >= 0) {
                    ImageDescriptor descriptor = ImageDescriptor.createFromFile(missing, (String)FileLocator.toFileURL((URL)file).getFile());
                    Image image = descriptor.createImage();
                    images.add(image);
                }
                ++n2;
            }
        }
        for (Image image : images) {
            image.dispose();
        }
    }

    @Test
    public void testFileImageDescriptorLocal() {
        ImageDescriptor descriptor = ImageDescriptor.createFromFile(FileImageDescriptorTest.class, (String)"anything.gif");
        Image image = descriptor.createImage();
        Assert.assertNotNull((String)"Could not find image", (Object)image);
        image.dispose();
    }

    @Test
    public void testFileImageDescriptorMissing() {
        ImageDescriptor descriptor = ImageDescriptor.createFromFile(FileImageDescriptorTest.class, (String)"missing.gif");
        Image image = descriptor.createImage(false);
        Assert.assertNull((String)"Found an image but should be null", (Object)image);
    }

    @Test
    public void testFileImageDescriptorMissingWithDefault() {
        ImageDescriptor descriptor = ImageDescriptor.createFromFile(FileImageDescriptorTest.class, (String)"missing.gif");
        Image image = descriptor.createImage(true);
        Assert.assertNotNull((String)"Did not find default image", (Object)image);
    }

    @Test
    public void testDifferentImagesPerFileImageDescriptor() {
        ImageDescriptor descriptor = ImageDescriptor.createFromFile(FileImageDescriptorTest.class, (String)"anything.gif");
        Image image1 = descriptor.createImage();
        Assert.assertNotNull((String)"Could not find first image", (Object)image1);
        Image image2 = descriptor.createImage();
        Assert.assertNotNull((String)"Could not find second image", (Object)image2);
        Assert.assertNotEquals((String)"Found equal images for FileImageDescriptor", (Object)image1, (Object)image2);
        image1.dispose();
        image2.dispose();
    }

    @Test
    public void testGetxName() {
        ImageDescriptor descriptor = ImageDescriptor.createFromFile(FileImageDescriptorTest.class, (String)"/icons/imagetests/zoomIn.png");
        ImageData imageData = descriptor.getImageData(100);
        Assert.assertNotNull((Object)imageData);
        ImageData imageDataZoomed = descriptor.getImageData(200);
        Assert.assertNotNull((Object)imageDataZoomed);
        Assert.assertEquals((long)(imageData.width * 2), (long)imageDataZoomed.width);
    }

    @Test
    public void testGetxPath() {
        ImageDescriptor descriptor = ImageDescriptor.createFromFile(FileImageDescriptorTest.class, (String)"/icons/imagetests/16x16/zoomIn.png");
        ImageData imageData = descriptor.getImageData(100);
        Assert.assertNotNull((Object)imageData);
        ImageData imageDataZoomed = descriptor.getImageData(200);
        Assert.assertNotNull((Object)imageDataZoomed);
        Assert.assertEquals((long)(imageData.width * 2), (long)imageDataZoomed.width);
    }

    @Test
    public void testGetxPathRectangular() {
        ImageDescriptor descriptor = ImageDescriptor.createFromFile(FileImageDescriptorTest.class, (String)"/icons/imagetests/rectangular-57x16.png");
        ImageData imageData = descriptor.getImageData(100);
        Assert.assertNotNull((Object)imageData);
        ImageData imageDataZoomed = descriptor.getImageData(200);
        Assert.assertNotNull((Object)imageDataZoomed);
        Assert.assertEquals((long)(imageData.width * 2), (long)imageDataZoomed.width);
        Assert.assertEquals((long)(imageData.height * 2), (long)imageDataZoomed.height);
    }

    @Test
    public void testGetxPath150() {
        ImageDescriptor descriptor = ImageDescriptor.createFromFile(FileImageDescriptorTest.class, (String)"/icons/imagetests/rectangular-57x16.png");
        ImageData imageData = descriptor.getImageData(100);
        Assert.assertNotNull((Object)imageData);
        ImageData imageDataZoomed = descriptor.getImageData(150);
        Assert.assertNotNull((Object)imageDataZoomed);
        Assert.assertEquals((long)Math.round((double)imageData.width * 1.5), (long)imageDataZoomed.width);
        Assert.assertEquals((long)Math.round((double)imageData.height * 1.5), (long)imageDataZoomed.height);
    }

    @Test
    public void testImageFileNameProviderGetxPath() {
        ImageDescriptor descriptor = ImageDescriptor.createFromFile(FileImageDescriptorTest.class, (String)"/icons/imagetests/rectangular-57x16.png");
        ImageFileNameProvider fileNameProvider = (ImageFileNameProvider)Adapters.adapt((Object)descriptor, ImageFileNameProvider.class);
        Assert.assertNotNull((String)"FileImageDescriptor does not adapt to ImageFileNameProvider", (Object)fileNameProvider);
        ImageFileNameProvider fileNameProvider2nd = (ImageFileNameProvider)Adapters.adapt((Object)descriptor, ImageFileNameProvider.class);
        Assert.assertNotSame((String)"FileImageDescriptor does return identical ImageFileNameProvider", (Object)fileNameProvider, (Object)fileNameProvider2nd);
        String imagePath100 = fileNameProvider.getImagePath(100);
        Assert.assertNotNull((String)"FileImageDescriptor's ImageFileNameProvider does not return the 100% path", (Object)imagePath100);
        Assert.assertEquals((Object)IPath.fromOSString((String)imagePath100).lastSegment(), (Object)"rectangular-57x16.png");
        String imagePath200 = fileNameProvider.getImagePath(200);
        Assert.assertNotNull((String)"FileImageDescriptor's ImageFileNameProvider does not return the 200% path", (Object)imagePath200);
        Assert.assertEquals((Object)IPath.fromOSString((String)imagePath200).lastSegment(), (Object)"rectangular-114x32.png");
        String imagePath150 = fileNameProvider.getImagePath(150);
        Assert.assertNotNull((String)"FileImageDescriptor's ImageFileNameProvider does not return the 150% path", (Object)imagePath150);
        Assert.assertEquals((Object)IPath.fromOSString((String)imagePath150).lastSegment(), (Object)"rectangular-86x24.png");
        String imagePath250 = fileNameProvider.getImagePath(250);
        Assert.assertNull((String)"FileImageDescriptor's ImageFileNameProvider does return a 250% path", (Object)imagePath250);
    }

    @Test
    public void testImageFileNameProviderGetxName() {
        ImageDescriptor descriptor = ImageDescriptor.createFromFile(FileImageDescriptorTest.class, (String)"/icons/imagetests/zoomIn.png");
        ImageFileNameProvider fileNameProvider = (ImageFileNameProvider)Adapters.adapt((Object)descriptor, ImageFileNameProvider.class);
        Assert.assertNotNull((String)"FileImageDescriptor does not adapt to ImageFileNameProvider", (Object)fileNameProvider);
        String imagePath100 = fileNameProvider.getImagePath(100);
        Assert.assertNotNull((String)"FileImageDescriptor's ImageFileNameProvider does not return the 100% path", (Object)imagePath100);
        Assert.assertEquals((Object)IPath.fromOSString((String)imagePath100).lastSegment(), (Object)"zoomIn.png");
        String imagePath200 = fileNameProvider.getImagePath(200);
        Assert.assertNotNull((String)"FileImageDescriptor's ImageFileNameProvider does not return the @2x path", (Object)imagePath200);
        Assert.assertEquals((Object)IPath.fromOSString((String)imagePath200).lastSegment(), (Object)"zoomIn@2x.png");
        String imagePath150 = fileNameProvider.getImagePath(150);
        Assert.assertNull((String)"FileImageDescriptor's ImageFileNameProvider does return a @1.5x path", (Object)imagePath150);
    }

    @Test
    public void testAdaptToURL() {
        ImageDescriptor descriptor = ImageDescriptor.createFromFile(FileImageDescriptorTest.class, (String)"/icons/imagetests/rectangular-57x16.png");
        URL url = (URL)Adapters.adapt((Object)descriptor, URL.class);
        Assert.assertNotNull((String)"FileImageDescriptor does not adapt to URL", (Object)url);
        ImageDescriptor descriptorFromUrl = ImageDescriptor.createFromURL((URL)url);
        ImageData imageDataOrig = descriptor.getImageData(100);
        Assert.assertNotNull((String)"Original URL does not return 100% image data", (Object)imageDataOrig);
        ImageData imageDataURL = descriptorFromUrl.getImageData(100);
        Assert.assertNotNull((String)"Adapted URL does not return 100% image data", (Object)imageDataURL);
        Assert.assertEquals((long)imageDataOrig.width, (long)imageDataURL.width);
        Assert.assertEquals((long)imageDataOrig.height, (long)imageDataURL.height);
        ImageData imageDataOrig200 = descriptor.getImageData(200);
        Assert.assertNotNull((String)"Original URL does not return 200% image data", (Object)imageDataOrig200);
        ImageData imageDataURL200 = descriptorFromUrl.getImageData(200);
        Assert.assertEquals((long)imageDataOrig200.width, (long)imageDataURL200.width);
        Assert.assertEquals((long)imageDataOrig200.height, (long)imageDataURL200.height);
    }
}

