/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.images;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LazyResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.junit.Assert;
import org.junit.Test;

public class LazyResourceManagerTest {
    @Test
    public void testDefaultImage() {
        Dialog.getBlockedHandler();
        String[] imageNames = new String[]{"dialog_error_image", "dialog_info_imageg", "dialog_question_image", "dialog_warning_image", "dialog_message_error_image", "dialog_messasge_info_image", "dialog_messasge_warning_image"};
        ImageRegistry reg = JFaceResources.getImageRegistry();
        TestResourceManager tst = new TestResourceManager();
        LazyResourceManager mgr = new LazyResourceManager(2, tst, tst){
            {
                Assert.assertSame((Object)testResourceManager.getDefaultImage(), (Object)this.getDefaultImage());
            }
        };
        String[] stringArray = imageNames;
        int n = imageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String imageName = stringArray[n2];
            Image image = reg.get(imageName);
            tst.setDefaultImage(image);
            tst.setDevice(image.getDevice());
            ++n2;
        }
        Assert.assertNotNull((Object)tst.getDevice());
        Assert.assertSame((Object)tst.getDevice(), (Object)mgr.getDevice());
    }

    @Test
    public void testUncachable() {
        TestResourceManager tst = new TestResourceManager();
        LazyResourceManager mgr = new LazyResourceManager(2, (ResourceManager)tst);
        Assert.assertSame((Object)tst.getDevice(), (Object)mgr.getDevice());
        UncachableTestDescriptor descriptor1 = new UncachableTestDescriptor();
        Object created1 = mgr.create((DeviceResourceDescriptor)descriptor1);
        Object expected1 = tst.find(descriptor1);
        Assert.assertSame((Object)expected1, (Object)created1);
        Assert.assertSame((Object)expected1, (Object)mgr.find((DeviceResourceDescriptor)descriptor1));
        mgr.destroy((DeviceResourceDescriptor)descriptor1);
        this.assertDestroyed((AtomicReference<DeviceResourceDescriptor>)expected1, mgr, tst, descriptor1);
    }

    void assertCached(AtomicReference<DeviceResourceDescriptor> previousInstance, LazyResourceManager mgr, TestResourceManager tst, DeviceResourceDescriptor rd) {
        Assert.assertNotNull(previousInstance);
        Assert.assertNull((Object)mgr.find(rd));
        Assert.assertNotNull((Object)tst.find(rd));
        Object created = tst.find(rd);
        Assert.assertSame(previousInstance, (Object)created);
    }

    void assertAlife(AtomicReference<DeviceResourceDescriptor> previousInstance, LazyResourceManager mgr, TestResourceManager tst, DeviceResourceDescriptor rd) {
        Assert.assertNotNull(previousInstance);
        Assert.assertSame(previousInstance, (Object)mgr.find(rd));
        Assert.assertSame(previousInstance, (Object)tst.find(rd));
    }

    void assertDestroyed(AtomicReference<DeviceResourceDescriptor> previousInstance, LazyResourceManager mgr, TestResourceManager tst, DeviceResourceDescriptor rd) {
        Assert.assertNotNull(previousInstance);
        Assert.assertNull((Object)mgr.find(rd));
        Assert.assertNull((Object)tst.find(rd));
        Object created = tst.find(rd);
        Assert.assertNotSame(previousInstance, (Object)created);
    }

    @Test
    public void testLazyResourceManagerRefCounting() {
        TestResourceManager tst = new TestResourceManager();
        LazyResourceManager mgr = new LazyResourceManager(1, (ResourceManager)tst);
        Assert.assertSame((Object)tst.getDevice(), (Object)mgr.getDevice());
        CachableTestDescriptor descriptor1 = new CachableTestDescriptor();
        AtomicReference expected1 = (AtomicReference)mgr.create((DeviceResourceDescriptor)descriptor1);
        this.assertAlife(expected1, mgr, tst, descriptor1);
        mgr.create((DeviceResourceDescriptor)descriptor1);
        this.assertAlife(expected1, mgr, tst, descriptor1);
        mgr.destroy((DeviceResourceDescriptor)descriptor1);
        this.assertAlife(expected1, mgr, tst, descriptor1);
        mgr.destroy((DeviceResourceDescriptor)descriptor1);
        this.assertCached(expected1, mgr, tst, descriptor1);
        CachableTestDescriptor descriptor2 = new CachableTestDescriptor();
        mgr.create((DeviceResourceDescriptor)descriptor2);
        mgr.destroy((DeviceResourceDescriptor)descriptor2);
        this.assertDestroyed(expected1, mgr, tst, descriptor1);
        Object created1_ = mgr.create((DeviceResourceDescriptor)descriptor1);
        Object expected1_ = tst.find(descriptor1);
        Assert.assertNotSame((Object)expected1, (Object)expected1_);
        Assert.assertSame(expected1.get(), ((AtomicReference)expected1_).get());
        Assert.assertSame((Object)expected1_, (Object)created1_);
        this.assertAlife((AtomicReference<DeviceResourceDescriptor>)expected1_, mgr, tst, descriptor1);
        mgr.destroy((DeviceResourceDescriptor)descriptor1);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected1_, mgr, tst, descriptor1);
    }

    @Test
    public void testLazyResourceManager() {
        TestResourceManager tst = new TestResourceManager();
        LazyResourceManager mgr = new LazyResourceManager(2, (ResourceManager)tst);
        Assert.assertSame((Object)tst.getDevice(), (Object)mgr.getDevice());
        CachableTestDescriptor descriptor1 = new CachableTestDescriptor();
        Object created1 = mgr.create((DeviceResourceDescriptor)descriptor1);
        Object expected1 = tst.find(descriptor1);
        Assert.assertSame((Object)expected1, (Object)created1);
        Assert.assertSame((Object)expected1, (Object)mgr.find((DeviceResourceDescriptor)descriptor1));
        mgr.destroy((DeviceResourceDescriptor)descriptor1);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected1, mgr, tst, descriptor1);
        CachableTestDescriptor descriptor2 = new CachableTestDescriptor();
        Object created = mgr.create((DeviceResourceDescriptor)descriptor2);
        Object expected2 = tst.find(descriptor2);
        Assert.assertSame((Object)expected2, (Object)created);
        Assert.assertSame((Object)expected2, (Object)mgr.find((DeviceResourceDescriptor)descriptor2));
        mgr.destroy((DeviceResourceDescriptor)descriptor2);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected2, mgr, tst, descriptor2);
        mgr.create((DeviceResourceDescriptor)descriptor2);
        mgr.destroy((DeviceResourceDescriptor)descriptor2);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected2, mgr, tst, descriptor2);
        mgr.create((DeviceResourceDescriptor)descriptor2);
        mgr.destroy((DeviceResourceDescriptor)descriptor2);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected2, mgr, tst, descriptor2);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected1, mgr, tst, descriptor1);
        CachableTestDescriptor descriptor3 = new CachableTestDescriptor();
        Object created2 = mgr.create((DeviceResourceDescriptor)descriptor3);
        Object expected3 = tst.find(descriptor3);
        Assert.assertSame((Object)expected3, (Object)created2);
        Assert.assertSame((Object)expected3, (Object)mgr.find((DeviceResourceDescriptor)descriptor3));
        mgr.destroy((DeviceResourceDescriptor)descriptor3);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected3, mgr, tst, descriptor3);
        this.assertDestroyed((AtomicReference<DeviceResourceDescriptor>)expected1, mgr, tst, descriptor1);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected2, mgr, tst, descriptor2);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected3, mgr, tst, descriptor3);
        Object created1_ = mgr.create((DeviceResourceDescriptor)descriptor1);
        Object expected1_ = tst.find(descriptor1);
        Assert.assertNotSame((Object)expected1, (Object)expected1_);
        Assert.assertSame(((AtomicReference)expected1).get(), ((AtomicReference)expected1_).get());
        Assert.assertSame((Object)expected1_, (Object)created1_);
        Assert.assertSame((Object)expected1_, (Object)mgr.find((DeviceResourceDescriptor)descriptor1));
        mgr.destroy((DeviceResourceDescriptor)descriptor1);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected1_, mgr, tst, descriptor1);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected3, mgr, tst, descriptor3);
        this.assertDestroyed((AtomicReference<DeviceResourceDescriptor>)expected2, mgr, tst, descriptor2);
    }

    @Test
    public void testLazyResourceManagerLRU() {
        TestResourceManager tst = new TestResourceManager();
        LazyResourceManager mgr = new LazyResourceManager(2, (ResourceManager)tst);
        Assert.assertSame((Object)tst.getDevice(), (Object)mgr.getDevice());
        CachableTestDescriptor descriptor1 = new CachableTestDescriptor();
        Object created1 = mgr.create((DeviceResourceDescriptor)descriptor1);
        Object expected1 = tst.find(descriptor1);
        Assert.assertSame((Object)expected1, (Object)created1);
        Assert.assertSame((Object)expected1, (Object)mgr.find((DeviceResourceDescriptor)descriptor1));
        mgr.destroy((DeviceResourceDescriptor)descriptor1);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected1, mgr, tst, descriptor1);
        CachableTestDescriptor descriptor2 = new CachableTestDescriptor();
        Object created = mgr.create((DeviceResourceDescriptor)descriptor2);
        Object expected2 = tst.find(descriptor2);
        Assert.assertSame((Object)expected2, (Object)created);
        Assert.assertSame((Object)expected2, (Object)mgr.find((DeviceResourceDescriptor)descriptor2));
        mgr.destroy((DeviceResourceDescriptor)descriptor2);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected2, mgr, tst, descriptor2);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected1, mgr, tst, descriptor1);
        CachableTestDescriptor descriptor3 = new CachableTestDescriptor();
        Object created2 = mgr.create((DeviceResourceDescriptor)descriptor3);
        Object expected3 = tst.find(descriptor3);
        Assert.assertSame((Object)expected3, (Object)created2);
        Assert.assertSame((Object)expected3, (Object)mgr.find((DeviceResourceDescriptor)descriptor3));
        mgr.destroy((DeviceResourceDescriptor)descriptor3);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected3, mgr, tst, descriptor3);
        created2 = mgr.create((DeviceResourceDescriptor)descriptor2);
        Object expected = tst.find(descriptor2);
        Assert.assertSame((Object)expected, (Object)created2);
        Assert.assertSame((Object)expected, (Object)mgr.find((DeviceResourceDescriptor)descriptor2));
        mgr.destroy((DeviceResourceDescriptor)descriptor2);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected, mgr, tst, descriptor2);
        this.assertDestroyed((AtomicReference<DeviceResourceDescriptor>)expected1, mgr, tst, descriptor1);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected2, mgr, tst, descriptor2);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected3, mgr, tst, descriptor3);
        Object created1_ = mgr.create((DeviceResourceDescriptor)descriptor1);
        Object expected1_ = tst.find(descriptor1);
        Assert.assertSame((Object)expected1_, (Object)created1_);
        Assert.assertSame((Object)expected1_, (Object)mgr.find((DeviceResourceDescriptor)descriptor1));
        mgr.destroy((DeviceResourceDescriptor)descriptor1);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected1_, mgr, tst, descriptor1);
        this.assertDestroyed((AtomicReference<DeviceResourceDescriptor>)expected3, mgr, tst, descriptor3);
        this.assertCached((AtomicReference<DeviceResourceDescriptor>)expected2, mgr, tst, descriptor2);
    }

    @Test
    public void testNullDescriptor() {
        TestResourceManager tst = new TestResourceManager();
        LazyResourceManager mgr = new LazyResourceManager(2, (ResourceManager)tst);
        DeviceResourceDescriptor nullDescriptor = null;
        AtomicReference expected = (AtomicReference)mgr.create(nullDescriptor);
        this.assertAlife(expected, mgr, tst, nullDescriptor);
        mgr.destroy(nullDescriptor);
        this.assertDestroyed(expected, mgr, tst, nullDescriptor);
        ResourceManager real = JFaceResources.getResources();
        mgr = new LazyResourceManager(2, real);
        Image created = mgr.createImageWithDefault(nullDescriptor);
        Assert.assertNotNull((Object)created);
        mgr.destroy(nullDescriptor);
    }

    private static class CachableTestDescriptor
    extends DeviceResourceDescriptor<Object> {
        CachableTestDescriptor() {
            super(true);
        }

        public Object createResource(Device device) {
            return null;
        }

        public void destroyResource(Object previouslyCreatedObject) {
        }
    }

    private static class TestResourceManager
    extends ResourceManager {
        private Device device;
        private final Map<DeviceResourceDescriptor, AtomicReference<DeviceResourceDescriptor>> objects = new HashMap<DeviceResourceDescriptor, AtomicReference<DeviceResourceDescriptor>>();
        private final Map<DeviceResourceDescriptor, Integer> refCount = new HashMap<DeviceResourceDescriptor, Integer>();
        private Image defaultImage;

        private TestResourceManager() {
        }

        public Device getDevice() {
            return this.device;
        }

        public AtomicReference<DeviceResourceDescriptor> create(DeviceResourceDescriptor descriptor) {
            AtomicReference<DeviceResourceDescriptor> newInstance = new AtomicReference<DeviceResourceDescriptor>(descriptor);
            AtomicReference<DeviceResourceDescriptor> previous = this.objects.putIfAbsent(descriptor, newInstance);
            this.refCount.compute(descriptor, (k, refs) -> (refs == null ? 0 : refs) + 1);
            return previous == null ? newInstance : previous;
        }

        public void destroy(DeviceResourceDescriptor descriptor) {
            if (!this.refCount.containsKey(descriptor)) {
                throw new RuntimeException("not created");
            }
            int refs = this.refCount.get(descriptor);
            this.refCount.put(descriptor, --refs);
            if (refs == 0) {
                this.objects.remove(descriptor);
            }
        }

        protected Image getDefaultImage() {
            return this.defaultImage;
        }

        public AtomicReference<DeviceResourceDescriptor> find(DeviceResourceDescriptor descriptor) {
            return this.objects.get(descriptor);
        }

        public void setDevice(Device device) {
            this.device = device;
        }

        public void setDefaultImage(Image defaultImage) {
            this.defaultImage = defaultImage;
        }
    }

    private static class UncachableTestDescriptor
    extends DeviceResourceDescriptor<Object> {
        UncachableTestDescriptor() {
            super(false);
        }

        public Object createResource(Device device) {
            return null;
        }

        public void destroyResource(Object previouslyCreatedObject) {
        }
    }
}

