/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.images;

import java.util.Objects;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceManagerTest {
    private DeviceResourceDescriptor<?>[] descriptors;
    private Image testImage;
    private Image testImage2;
    private Color testColor;
    private Color testColor2;
    private int numDupes;
    private DeviceResourceManager globalResourceManager;

    private static ImageDescriptor getImage(String path) {
        return ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.jface.tests", (String)path).orElse(null);
    }

    @Before
    public void setUp() throws Exception {
        TestDescriptor.refCount = 0;
        Display display = Display.getCurrent();
        this.globalResourceManager = new DeviceResourceManager((Device)display);
        this.testImage = ResourceManagerTest.getImage("icons/anything.gif").createImage((Device)display);
        this.testImage2 = ResourceManagerTest.getImage("icons/binary_co.gif").createImage((Device)display);
        this.testColor = new Color((Device)display, new RGB(10, 40, 20));
        this.testColor2 = new Color((Device)display, new RGB(230, 100, 26));
        this.descriptors = new DeviceResourceDescriptor[]{new TestDescriptor(ResourceManagerTest.getImage("icons/anything.gif")), new TestDescriptor(ResourceManagerTest.getImage("icons/anything.gif")), new TestDescriptor(ResourceManagerTest.getImage("icons/binary_co.gif")), new TestDescriptor(ResourceManagerTest.getImage("icons/binary_co.gif")), new TestDescriptor(ResourceManagerTest.getImage("icons/mockeditorpart1.gif")), new TestDescriptor(ResourceManagerTest.getImage("icons/view.gif")), new TestDescriptor(ImageDescriptor.createFromImage((Image)this.testImage2)), new TestDescriptor(ImageDescriptor.createFromImage((Image)this.testImage)), new TestDescriptor(ImageDescriptor.createFromImage((Image)this.testImage)), new TestDescriptor(ImageDescriptor.createFromImage((Image)this.testImage)), new TestDescriptor(ImageDescriptor.createFromImage((Image)this.testImage)), new TestDescriptor(ImageDescriptor.createFromImage((Image)this.testImage2)), new TestDescriptor(ColorDescriptor.createFrom((RGB)new RGB(10, 200, 54))), new TestDescriptor(ColorDescriptor.createFrom((RGB)new RGB(10, 200, 54))), new TestDescriptor(ColorDescriptor.createFrom((RGB)new RGB(200, 220, 54))), new TestDescriptor(ColorDescriptor.createFrom((Color)this.testColor)), new TestDescriptor(ColorDescriptor.createFrom((Color)this.testColor)), new TestDescriptor(ColorDescriptor.createFrom((Color)this.testColor2)), new TestDescriptor(ColorDescriptor.createFrom((Color)this.testColor)), new TestDescriptor(ColorDescriptor.createFrom((Color)this.testColor)), new TestDescriptor(ColorDescriptor.createFrom((Color)this.testColor2)), new TestDescriptor(ImageDescriptor.createFromImageDataProvider((ImageDataProvider)new MyImageDataProvider("1"))), new TestDescriptor(ImageDescriptor.createFromImageDataProvider((ImageDataProvider)new MyImageDataProvider("1"))), new TestDescriptor(ImageDescriptor.createFromImageDataProvider((ImageDataProvider)new MyImageDataProvider("2")))};
        this.numDupes = 12;
    }

    @After
    public void tearDown() throws Exception {
        this.globalResourceManager.dispose();
        Assert.assertEquals((String)"Detected leaks", (long)0L, (long)TestDescriptor.refCount);
        this.testImage.dispose();
        this.testImage2.dispose();
    }

    protected void validateResource(Object resource) throws Exception {
        Assert.assertNotNull((String)"Allocated resource was null", (Object)resource);
        if (resource instanceof Image) {
            Image image = (Image)resource;
            Assert.assertFalse((String)"Image is disposed", (boolean)image.isDisposed());
            return;
        }
    }

    @Test
    public void testDescriptorAllocations() throws Exception {
        DeviceResourceDescriptor<?> next;
        Display display = Display.getCurrent();
        Object[] resources = new Object[this.descriptors.length];
        int i = 0;
        while (i < this.descriptors.length) {
            next = this.descriptors[i];
            Object resource = next.createResource((Device)display);
            this.validateResource(resource);
            resources[i] = resource;
            ++i;
        }
        Assert.assertEquals((String)"Expecting one resource to be allocated per descriptor", (long)this.descriptors.length, (long)TestDescriptor.refCount);
        i = 0;
        while (i < this.descriptors.length) {
            next = this.descriptors[i];
            next.destroyResource(resources[i]);
            ++i;
        }
    }

    @Test
    public void testDeviceManagerAllocations() throws Exception {
        Object[] resources = new Object[this.descriptors.length];
        int i = 0;
        while (i < this.descriptors.length) {
            DeviceResourceDescriptor<?> next = this.descriptors[i];
            Object resource = this.globalResourceManager.create(next);
            this.validateResource(resource);
            resources[i] = resource;
            ++i;
        }
        Assert.assertEquals((String)"Descriptors created from Images should not reallocate Images when the original can be reused", (Object)this.testImage, (Object)resources[9]);
        Assert.assertEquals((String)"Duplicate descriptors should be reused", (long)(this.descriptors.length - this.numDupes), (long)TestDescriptor.refCount);
        DeviceResourceDescriptor<?>[] deviceResourceDescriptorArray = this.descriptors;
        int n = this.descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceResourceDescriptor<?> next = deviceResourceDescriptorArray[n2];
            this.globalResourceManager.destroy(next);
            ++n2;
        }
    }

    private void allocateResources(ResourceManager mgr, int[] toAllocate) throws Exception {
        int[] nArray = toAllocate;
        int n = toAllocate.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            this.validateResource(mgr.create(this.descriptors[j]));
            ++n2;
        }
    }

    private void deallocateResources(ResourceManager mgr, int[] toDeallocate) {
        int[] nArray = toDeallocate;
        int n = toDeallocate.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            mgr.destroy(this.descriptors[j]);
            ++n2;
        }
    }

    @Test
    public void testLocalManagerAllocations() throws Exception {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 5;
        nArray[3] = 3;
        nArray[4] = 7;
        nArray[5] = 12;
        nArray[6] = 13;
        nArray[7] = 14;
        int[] gResources = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 2;
        nArray2[2] = 3;
        nArray2[3] = 4;
        nArray2[4] = 11;
        nArray2[5] = 12;
        nArray2[6] = 13;
        nArray2[7] = 15;
        int[] lm1Resources = nArray2;
        int[] nArray3 = new int[8];
        nArray3[1] = 1;
        nArray3[2] = 6;
        nArray3[3] = 7;
        nArray3[4] = 8;
        nArray3[5] = 12;
        nArray3[6] = 14;
        nArray3[7] = 16;
        int[] lm2Resources = nArray3;
        LocalResourceManager lm1 = new LocalResourceManager((ResourceManager)this.globalResourceManager);
        LocalResourceManager lm2 = new LocalResourceManager((ResourceManager)this.globalResourceManager);
        this.allocateResources((ResourceManager)this.globalResourceManager, gResources);
        int initialCount = TestDescriptor.refCount;
        this.allocateResources((ResourceManager)lm1, lm1Resources);
        int lm1Count = TestDescriptor.refCount;
        this.allocateResources((ResourceManager)lm2, lm2Resources);
        this.deallocateResources((ResourceManager)lm2, lm2Resources);
        Assert.assertEquals((long)lm1Count, (long)TestDescriptor.refCount);
        lm2.dispose();
        Assert.assertEquals((long)lm1Count, (long)TestDescriptor.refCount);
        lm1.dispose();
        Assert.assertEquals((long)initialCount, (long)TestDescriptor.refCount);
    }

    @Test
    public void testImageDataResourceAllocations() throws Exception {
        int[] gResources = new int[]{21, 22, 23};
        this.allocateResources((ResourceManager)this.globalResourceManager, gResources);
        Assert.assertEquals((long)2L, (long)TestDescriptor.refCount);
    }

    @Test
    public void testResourceManagerFind() throws Exception {
        DeviceResourceDescriptor<?> descriptor = this.descriptors[0];
        Object resource = this.globalResourceManager.find(descriptor);
        Assert.assertNull((String)"Resource should be null since it is not allocated", (Object)resource);
        resource = this.globalResourceManager.create(descriptor);
        this.validateResource(resource);
        Object foundResource = this.globalResourceManager.find(descriptor);
        Assert.assertNotNull((String)"Found resource should not be null", (Object)foundResource);
        Assert.assertTrue((String)"Found resource should be an image", (boolean)(foundResource instanceof Image));
        this.globalResourceManager.destroy(descriptor);
    }

    private static class MyImageDataProvider
    implements ImageDataProvider {
        private final String id;

        public MyImageDataProvider(String id) {
            this.id = id;
        }

        public ImageData getImageData(int zoom) {
            PaletteData paletteData = new PaletteData(new RGB[]{new RGB(255, 0, 0), new RGB(0, 255, 0)});
            ImageData imageData = new ImageData(48, 48, 1, paletteData);
            int x = 11;
            while (x < 35) {
                int y = 11;
                while (y < 35) {
                    imageData.setPixel(x, y, 1);
                    ++y;
                }
                ++x;
            }
            return imageData;
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MyImageDataProvider other = (MyImageDataProvider)obj;
            return Objects.equals(this.id, other.id);
        }
    }

    private static final class TestDescriptor<R>
    extends DeviceResourceDescriptor<R> {
        DeviceResourceDescriptor<R> toWrap;
        public static int refCount = 0;

        public TestDescriptor(DeviceResourceDescriptor<R> toWrap) {
            this.toWrap = toWrap;
        }

        public Object createResource(Device device) throws DeviceResourceException {
            Object result = this.toWrap.createResource(device);
            ++refCount;
            return result;
        }

        public void destroyResource(Object previouslyCreatedObject) {
            --refCount;
            this.toWrap.destroyResource(previouslyCreatedObject);
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof TestDescriptor) {
                TestDescriptor td = (TestDescriptor)((Object)arg0);
                return td.toWrap.equals(this.toWrap);
            }
            return false;
        }

        public int hashCode() {
            return this.toWrap.hashCode();
        }
    }
}

