/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.images;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.tests.images.FileImageDescriptorTest;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UrlImageDescriptorTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testDifferentImagesPerUrlImageDescriptor() {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)FileImageDescriptorTest.class.getResource("/icons/imagetests/anything.gif"));
        Image image1 = descriptor.createImage();
        Assert.assertNotNull((String)"Could not find first image", (Object)image1);
        Image image2 = descriptor.createImage();
        Assert.assertNotNull((String)"Could not find second image", (Object)image2);
        Assert.assertNotEquals((String)"Found equal images for URLImageDescriptor", (Object)image1, (Object)image2);
        image1.dispose();
        image2.dispose();
    }

    @Test
    public void testGetxName() {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)FileImageDescriptorTest.class.getResource("/icons/imagetests/zoomIn.png"));
        ImageData imageData = descriptor.getImageData(100);
        Assert.assertNotNull((Object)imageData);
        ImageData imageDataZoomed = descriptor.getImageData(200);
        Assert.assertNotNull((Object)imageDataZoomed);
        Assert.assertEquals((long)(imageData.width * 2), (long)imageDataZoomed.width);
    }

    @Test
    public void testGetxPath() {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)FileImageDescriptorTest.class.getResource("/icons/imagetests/16x16/zoomIn.png"));
        ImageData imageData = descriptor.getImageData(100);
        Assert.assertNotNull((Object)imageData);
        ImageData imageDataZoomed = descriptor.getImageData(200);
        Assert.assertNotNull((Object)imageDataZoomed);
        Assert.assertEquals((long)(imageData.width * 2), (long)imageDataZoomed.width);
    }

    @Test
    public void testImageFileNameProviderGetxPath() {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)FileImageDescriptorTest.class.getResource("/icons/imagetests/rectangular-57x16.png"));
        ImageFileNameProvider fileNameProvider = (ImageFileNameProvider)Adapters.adapt((Object)descriptor, ImageFileNameProvider.class);
        Assert.assertNotNull((String)"URLImageDescriptor does not adapt to ImageFileNameProvider", (Object)fileNameProvider);
        ImageFileNameProvider fileNameProvider2nd = (ImageFileNameProvider)Adapters.adapt((Object)descriptor, ImageFileNameProvider.class);
        Assert.assertNotSame((String)"URLImageDescriptor does return identical ImageFileNameProvider", (Object)fileNameProvider, (Object)fileNameProvider2nd);
        String imagePath100 = fileNameProvider.getImagePath(100);
        Assert.assertNotNull((String)"URLImageDescriptor ImageFileNameProvider does not return the 100% path", (Object)imagePath100);
        Assert.assertEquals((Object)IPath.fromOSString((String)imagePath100).lastSegment(), (Object)"rectangular-57x16.png");
        String imagePath200 = fileNameProvider.getImagePath(200);
        Assert.assertNotNull((String)"URLImageDescriptor ImageFileNameProvider does not return the 200% path", (Object)imagePath200);
        Assert.assertEquals((Object)IPath.fromOSString((String)imagePath200).lastSegment(), (Object)"rectangular-114x32.png");
        String imagePath150 = fileNameProvider.getImagePath(150);
        Assert.assertNotNull((String)"URLImageDescriptor ImageFileNameProvider does not return the 150% path", (Object)imagePath150);
        Assert.assertEquals((Object)IPath.fromOSString((String)imagePath150).lastSegment(), (Object)"rectangular-86x24.png");
        String imagePath250 = fileNameProvider.getImagePath(250);
        Assert.assertNull((String)"URLImageDescriptor's ImageFileNameProvider does return a 250% path", (Object)imagePath250);
    }

    @Test
    public void testImageFileNameProviderGetxName() {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)FileImageDescriptorTest.class.getResource("/icons/imagetests/zoomIn.png"));
        ImageFileNameProvider fileNameProvider = (ImageFileNameProvider)Adapters.adapt((Object)descriptor, ImageFileNameProvider.class);
        Assert.assertNotNull((String)"URLImageDescriptor does not adapt to ImageFileNameProvider", (Object)fileNameProvider);
        String imagePath100 = fileNameProvider.getImagePath(100);
        Assert.assertNotNull((String)"URLImageDescriptor ImageFileNameProvider does not return the 100% path", (Object)imagePath100);
        Assert.assertEquals((Object)IPath.fromOSString((String)imagePath100).lastSegment(), (Object)"zoomIn.png");
        String imagePath200 = fileNameProvider.getImagePath(200);
        Assert.assertNotNull((String)"URLImageDescriptor ImageFileNameProvider does not return the @2x path", (Object)imagePath200);
        Assert.assertEquals((Object)IPath.fromOSString((String)imagePath200).lastSegment(), (Object)"zoomIn@2x.png");
        String imagePath150 = fileNameProvider.getImagePath(150);
        Assert.assertNull((String)"URLImageDescriptor's ImageFileNameProvider does return a @1.5x path", (Object)imagePath150);
    }

    @Test
    public void testImageFileNameProviderGetxName_forFileURL() throws IOException {
        this.testImageFileNameProviderGetxName_forFileURL(true);
    }

    @Test
    public void testImageFileNameProviderGetxName_forFileURL_noOSGi() throws IOException {
        this.testImageFileNameProviderGetxName_forFileURL(false);
    }

    private void testImageFileNameProviderGetxName_forFileURL(boolean osgiAvailable) throws IOException {
        boolean oldOsgiAvailable = InternalPolicy.OSGI_AVAILABLE;
        InternalPolicy.OSGI_AVAILABLE = osgiAvailable;
        try {
            URL imageFileURL = this.tempFolder.newFile("image.png").toURI().toURL();
            this.tempFolder.newFile("image@2x.png");
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)imageFileURL);
            ImageFileNameProvider fileNameProvider = (ImageFileNameProvider)Adapters.adapt((Object)descriptor, ImageFileNameProvider.class);
            Assert.assertNotNull((String)"URLImageDescriptor does not adapt to ImageFileNameProvider", (Object)fileNameProvider);
            String imagePath100 = fileNameProvider.getImagePath(100);
            Assert.assertNotNull((String)"URLImageDescriptor ImageFileNameProvider does not return the 100% path", (Object)imagePath100);
            Assert.assertEquals((Object)IPath.fromOSString((String)imagePath100).lastSegment(), (Object)"image.png");
            String imagePath200 = fileNameProvider.getImagePath(200);
            Assert.assertNotNull((String)"URLImageDescriptor ImageFileNameProvider does not return the @2x path", (Object)imagePath200);
            Assert.assertEquals((Object)IPath.fromOSString((String)imagePath200).lastSegment(), (Object)"image@2x.png");
            String imagePath150 = fileNameProvider.getImagePath(150);
            Assert.assertNull((String)"URLImageDescriptor's ImageFileNameProvider does return a @1.5x path", (Object)imagePath150);
        }
        finally {
            InternalPolicy.OSGI_AVAILABLE = oldOsgiAvailable;
        }
    }

    @Test
    public void testImageFileNameProviderGetxName_forFileURL_WhiteSpace() throws IOException {
        File imageFolder = this.tempFolder.newFolder("folder with spaces");
        File imageFile = new File(imageFolder, "image with spaces.png");
        imageFile.createNewFile();
        URL imageFileURL = new URL("file", null, imageFile.getPath());
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)imageFileURL);
        ImageFileNameProvider fileNameProvider = (ImageFileNameProvider)Adapters.adapt((Object)descriptor, ImageFileNameProvider.class);
        Assert.assertNotNull((String)"URLImageDescriptor does not adapt to ImageFileNameProvider", (Object)fileNameProvider);
        String imagePath100 = fileNameProvider.getImagePath(100);
        Assert.assertNotNull((String)"URLImageDescriptor ImageFileNameProvider does not return the 100% path", (Object)imagePath100);
    }

    @Test
    public void testAdaptToURL() {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)FileImageDescriptorTest.class.getResource("/icons/imagetests/rectangular-57x16.png"));
        URL url = (URL)Adapters.adapt((Object)descriptor, URL.class);
        Assert.assertNotNull((String)"URLImageDescriptor does not adapt to URL", (Object)url);
        ImageDescriptor descriptorFromUrl = ImageDescriptor.createFromURL((URL)url);
        ImageData imageDataOrig = descriptor.getImageData(100);
        Assert.assertNotNull((String)"Original URL does not return 100% image data", (Object)imageDataOrig);
        ImageData imageDataURL = descriptorFromUrl.getImageData(100);
        Assert.assertNotNull((String)"Adapted URL does not return 100% image data", (Object)imageDataURL);
        Assert.assertEquals((long)imageDataOrig.width, (long)imageDataURL.width);
        Assert.assertEquals((long)imageDataOrig.height, (long)imageDataURL.height);
        ImageData imageDataOrig200 = descriptor.getImageData(200);
        Assert.assertNotNull((String)"Original URL does not return 200% image data", (Object)imageDataOrig200);
        ImageData imageDataURL200 = descriptorFromUrl.getImageData(200);
        Assert.assertEquals((long)imageDataOrig200.width, (long)imageDataURL200.width);
        Assert.assertEquals((long)imageDataOrig200.height, (long)imageDataURL200.height);
    }
}

