/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.labelProviders;

import org.eclipse.jface.tests.labelProviders.CompositeLabelProviderTest;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.junit.Assert;
import org.junit.Test;

public class CompositeLabelProviderTableTest
extends CompositeLabelProviderTest {
    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.initializeColors((Control)parent);
        TableViewer v = new TableViewer(parent);
        v.setContentProvider((IContentProvider)new CompositeLabelProviderTest.LabelTableContentProvider(this));
        v.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        v.getTable().setLinesVisible(true);
        return v;
    }

    @Test
    public void testColorsAndFonts() {
        Table table = (Table)this.fViewer.getControl();
        TableItem item = table.getItem(0);
        Assert.assertEquals((String)"Background was not set", (Object)item.getBackground(0), (Object)this.background);
        Assert.assertEquals((String)"Foreground was not set", (Object)item.getForeground(0), (Object)this.foreground);
        Assert.assertEquals((String)"Font was not set", (Object)item.getFont(0), (Object)this.font);
    }

    class MyLabelProvider
    extends LabelProvider
    implements IColorProvider,
    IViewerLabelProvider,
    IFontProvider {
        MyLabelProvider() {
        }

        public Color getForeground(Object element) {
            return CompositeLabelProviderTableTest.this.foreground;
        }

        public Color getBackground(Object element) {
            return CompositeLabelProviderTableTest.this.background;
        }

        public void updateLabel(ViewerLabel label, Object element) {
            label.setText(this.getText(element));
        }

        public Font getFont(Object element) {
            return CompositeLabelProviderTableTest.this.font;
        }
    }
}

