/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.labelProviders;

import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.tests.viewers.ViewerTestCase;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DecoratingStyledCellLabelProviderTest
extends ViewerTestCase {
    private CountryEntry[] entries;
    protected String changeMe = "OLD";
    private static int COLUMN_COUNT = 3;

    @Override
    @Before
    public void setUp() {
        this.entries = new CountryEntry[3];
        this.entries[0] = new AustriaEntry();
        this.entries[1] = new GermanyEntry();
        this.entries[2] = new EnglandEntry();
        super.setUp();
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 65536);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return DecoratingStyledCellLabelProviderTest.this.entries;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        DecoratingStyledCellLabelProviderTest.createColumns(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        viewer.setSelection((ISelection)new StructuredSelection((Object)this.entries[1]));
        return viewer;
    }

    private DecoratingStyledCellLabelProvider createLabelProvider() {
        return new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TestCellLabelProvider(), this.getDecorator(), DecoratingStyledCellLabelProviderTest.getContext());
    }

    private static IDecorationContext getContext() {
        return new IDecorationContext(){

            public String[] getProperties() {
                return null;
            }

            public Object getProperty(String property) {
                return null;
            }
        };
    }

    private ILabelDecorator getDecorator() {
        return new TestLabelDecorator();
    }

    private ILabelProviderListener getListener() {
        return event -> {
            String string = this.changeMe = "been changed";
        };
    }

    private static void createColumns(TableViewer viewer) {
        TableLayout layout = new TableLayout();
        Table table = viewer.getTable();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int i = 0;
        while (i < COLUMN_COUNT) {
            TableColumn tc = new TableColumn(table, 0, i);
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
            tc.setText(DecoratingStyledCellLabelProviderTest.getTitleFor(i));
            ++i;
        }
    }

    @Override
    protected void setInput() {
        this.fViewer.setInput((Object)this);
    }

    @Test
    public void testGetDecorationContext() {
        Assert.assertNotNull((Object)this.getDecoratingStyledLabelProvider().getDecorationContext());
    }

    @Test
    public void testSetDecorationContext() {
        try {
            this.getDecoratingStyledLabelProvider().setDecorationContext(null);
            Assert.fail((String)"DecoratingStyledCellLabelProvider.setDecorationContext did not throw an exception when passed null");
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdate() {
        Table table = ((TableViewer)this.fViewer).getTable();
        String before = table.getItem(0).toString();
        this.entries[0].name = "Updated";
        this.fViewer.refresh();
        Assert.assertNotSame((Object)before, (Object)table.getItem(0).toString());
    }

    @Test
    public void testGetForeground() {
    }

    @Test
    public void testGetBackground() {
    }

    @Test
    public void testGetFont() {
    }

    @Test
    public void testGetImage() {
        Table table = ((TableViewer)this.fViewer).getTable();
        Assert.assertEquals((Object)table.getItem(0).getImage(), (Object)this.getDecoratingStyledLabelProvider().getImage((Object)table.getItem(0)));
    }

    @Test
    public void testGetLabelDecorator() {
        Assert.assertNotNull((Object)this.getDecoratingStyledLabelProvider().getLabelDecorator());
        this.getDecoratingStyledLabelProvider().setLabelDecorator(null);
        Assert.assertNull((Object)this.getDecoratingStyledLabelProvider().getLabelDecorator());
    }

    @Test
    public void testSetLabelDecorator() {
        ILabelDecorator labelDecorator = this.getDecorator();
        this.getDecoratingStyledLabelProvider().setLabelDecorator(labelDecorator);
        Assert.assertEquals((Object)labelDecorator, (Object)this.getDecoratingStyledLabelProvider().getLabelDecorator());
    }

    @Test
    public void testAddListener() {
        String old = this.changeMe;
        ILabelProviderListener listener = this.getListener();
        this.getDecoratingStyledLabelProvider().addListener(listener);
        this.getDecoratingStyledLabelProvider().setLabelDecorator(this.getDecorator());
        Assert.assertNotSame((Object)old, (Object)this.changeMe);
    }

    @Test
    public void testRemoveListener() {
        this.changeMe = "OLD";
        String old = "OLD";
        ILabelProviderListener listener = this.getListener();
        this.getDecoratingStyledLabelProvider().addListener(listener);
        this.getDecoratingStyledLabelProvider().removeListener(listener);
        this.getDecoratingStyledLabelProvider().setLabelDecorator(this.getDecorator());
        Assert.assertEquals((Object)old, (Object)this.changeMe);
    }

    @Test
    public void testIsLabelProperty() {
        boolean check = this.getDecoratingStyledLabelProvider().isLabelProperty((Object)"element", "property");
        Assert.assertTrue((boolean)check);
    }

    @Test
    public void testDispose() {
        this.fShell.dispose();
        Assert.assertFalse((boolean)(this.fViewer.getLabelProvider() instanceof DecoratingStyledCellLabelProvider));
    }

    private DecoratingStyledCellLabelProvider getDecoratingStyledLabelProvider() {
        return (DecoratingStyledCellLabelProvider)this.fViewer.getLabelProvider();
    }

    private static String getTitleFor(int i) {
        switch (i) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Flag";
            }
            case 2: {
                return "World Cup Year";
            }
        }
        return "Unknown";
    }

    private class AustriaEntry
    extends CountryEntry {
        AustriaEntry() {
            super("\u00d6sterreich", "Austria", "TBD");
        }

        @Override
        protected void drawFlag(Event event) {
            Rectangle bounds = event.getBounds();
            bounds.width += 100;
            int stripeHeight = bounds.height / 3;
            Rectangle stripe = new Rectangle(bounds.x, bounds.y, bounds.width, stripeHeight);
            event.gc.setBackground(DecoratingStyledCellLabelProviderTest.this.fViewer.getControl().getDisplay().getSystemColor(3));
            event.gc.fillRectangle(stripe);
            stripe.y += stripeHeight;
            event.gc.setBackground(DecoratingStyledCellLabelProviderTest.this.fViewer.getControl().getDisplay().getSystemColor(1));
            event.gc.fillRectangle(stripe);
            stripe.y += stripeHeight;
            event.gc.setBackground(DecoratingStyledCellLabelProviderTest.this.fViewer.getControl().getDisplay().getSystemColor(3));
            event.gc.fillRectangle(stripe);
        }
    }

    class CountryEntry {
        String name;
        String cupYear;
        private final String baseName;

        CountryEntry(String countryName, String englishName, String worldCupYear) {
            this.name = countryName;
            this.cupYear = worldCupYear;
            this.baseName = englishName;
        }

        public String toString() {
            return this.name + " " + this.cupYear + " " + this.baseName;
        }

        public int getHeight(Event event) {
            switch (event.index) {
                case 0: {
                    return event.gc.textExtent((String)this.name).y;
                }
                case 1: {
                    return 50;
                }
                case 2: {
                    return event.gc.textExtent((String)this.cupYear).y;
                }
            }
            return 10;
        }

        public int getWidth(Event event) {
            switch (event.index) {
                case 0: {
                    return event.gc.textExtent((String)this.getDisplayString().toString()).x + 4;
                }
                case 1: {
                    return 200;
                }
                case 2: {
                    return event.gc.textExtent((String)this.cupYear).x + 5;
                }
            }
            return 10;
        }

        protected void drawFlag(Event event) {
            event.gc.setBackground(DecoratingStyledCellLabelProviderTest.this.fViewer.getControl().getDisplay().getSystemColor(9));
            Rectangle bounds = event.getBounds();
            bounds.width += 100;
            event.gc.fillRectangle(bounds);
        }

        private void drawCupYear(Event event) {
            event.gc.drawText(this.cupYear, event.x, event.y);
        }

        protected void drawName(Event event) {
            StringBuilder buffer = this.getDisplayString();
            Display display = DecoratingStyledCellLabelProviderTest.this.fViewer.getControl().getDisplay();
            TextLayout layout = new TextLayout((Device)display);
            layout.setText(buffer.toString());
            TextStyle plain = new TextStyle(JFaceResources.getFont((String)"org.eclipse.jface.defaultfont"), display.getSystemColor(24), display.getSystemColor(25));
            TextStyle italic = new TextStyle(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"), display.getSystemColor(9), display.getSystemColor(25));
            layout.setStyle(plain, 0, this.name.length() - 1);
            layout.setStyle(italic, this.name.length(), buffer.length() - 1);
            layout.draw(event.gc, event.x, event.y);
            layout.dispose();
        }

        private StringBuilder getDisplayString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.name);
            buffer.append(" (");
            buffer.append(this.baseName);
            buffer.append(")");
            return buffer;
        }

        public void draw(Event event) {
            switch (event.index) {
                case 0: {
                    this.drawName(event);
                    break;
                }
                case 1: {
                    this.drawFlag(event);
                    break;
                }
                case 2: {
                    this.drawCupYear(event);
                    break;
                }
            }
        }
    }

    private class EnglandEntry
    extends CountryEntry {
        EnglandEntry() {
            super("Blighty", "England", "1966");
        }

        @Override
        protected void drawFlag(Event event) {
            Rectangle bounds = event.getBounds();
            bounds.width += 100;
            event.gc.setBackground(DecoratingStyledCellLabelProviderTest.this.fViewer.getControl().getDisplay().getSystemColor(3));
            event.gc.fillRectangle(new Rectangle(bounds.width / 2 + bounds.x - 5, bounds.y, 10, bounds.height));
            event.gc.fillRectangle(new Rectangle(bounds.x, bounds.height / 2 + bounds.y - 5, bounds.width, 10));
        }
    }

    private class GermanyEntry
    extends CountryEntry {
        GermanyEntry() {
            super("Deutschland", "Germany", "1990");
        }

        @Override
        protected void drawFlag(Event event) {
            Rectangle bounds = event.getBounds();
            bounds.width += 100;
            int stripeHeight = bounds.height / 3;
            Rectangle stripe = new Rectangle(bounds.x, bounds.y, bounds.width, stripeHeight);
            event.gc.setBackground(DecoratingStyledCellLabelProviderTest.this.fViewer.getControl().getDisplay().getSystemColor(2));
            event.gc.fillRectangle(stripe);
            stripe.y += stripeHeight;
            event.gc.setBackground(DecoratingStyledCellLabelProviderTest.this.fViewer.getControl().getDisplay().getSystemColor(7));
            event.gc.fillRectangle(stripe);
            stripe.y += stripeHeight;
            event.gc.setBackground(DecoratingStyledCellLabelProviderTest.this.fViewer.getControl().getDisplay().getSystemColor(3));
            event.gc.fillRectangle(stripe);
        }
    }

    private class TestCellLabelProvider
    extends CellLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    IFontProvider {
        private TestCellLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            cell.setText(element == null ? "" : element.toString());
            cell.setImage(this.getImage(element));
            cell.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
            cell.setForeground(cell.getControl().getDisplay().getSystemColor(9));
            cell.setBackground(cell.getControl().getDisplay().getSystemColor(3));
        }

        public Image getImage(Object element) {
            return DecoratingStyledCellLabelProviderTest.this.fViewer.getControl().getDisplay().getSystemImage(8);
        }

        public StyledString getStyledText(Object element) {
            return new StyledString(element.toString(), StyledString.COUNTER_STYLER);
        }

        public Font getFont(Object element) {
            return JFaceResources.getFont((String)"org.eclipse.jface.bannerfont");
        }
    }

    private class TestLabelDecorator
    implements ILabelDecorator,
    IColorDecorator {
        private TestLabelDecorator() {
        }

        public Image decorateImage(Image image, Object element) {
            return image;
        }

        public String decorateText(String text, Object element) {
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color decorateBackground(Object element) {
            return DecoratingStyledCellLabelProviderTest.this.fViewer.getControl().getDisplay().getSystemColor(3);
        }

        public Color decorateForeground(Object element) {
            return DecoratingStyledCellLabelProviderTest.this.fViewer.getControl().getDisplay().getSystemColor(9);
        }
    }
}

