/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.labelProviders;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.tests.viewers.StructuredViewerTest;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.junit.Assert;
import org.junit.Test;

public class LabelProviderLambdaTest {
    protected static Shell initializeShell() {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        return shell;
    }

    protected static StructuredViewer initializeViewer(Shell shell) {
        TableViewer viewer = new TableViewer((Composite)shell);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setInput((Object)LabelProviderLambdaTest.createModel());
        return viewer;
    }

    protected static Integer[] createModel() {
        Integer[] model = new Integer[10];
        int i = 0;
        while (i < 10) {
            model[i] = i;
            ++i;
        }
        return model;
    }

    @Test
    public void testCreateTextProvider() {
        Shell shell = LabelProviderLambdaTest.initializeShell();
        StructuredViewer viewer = LabelProviderLambdaTest.initializeViewer(shell);
        viewer.setLabelProvider((IBaseLabelProvider)LabelProvider.createTextProvider(Object::toString));
        shell.open();
        Table table = (Table)viewer.getControl();
        String firstElementText = table.getItem(0).getText();
        Assert.assertEquals((String)"rendered label", (Object)Integer.valueOf(0).toString(), (Object)firstElementText);
    }

    @Test
    public void testCreateTextImageProvider() {
        Shell shell = LabelProviderLambdaTest.initializeShell();
        StructuredViewer viewer = LabelProviderLambdaTest.initializeViewer(shell);
        Image fgImage = ImageDescriptor.createFromFile(StructuredViewerTest.TestLabelProvider.class, (String)"images/java.gif").createImage();
        viewer.setLabelProvider((IBaseLabelProvider)LabelProvider.createTextImageProvider(Object::toString, inputElement -> fgImage));
        shell.open();
        Table table = (Table)viewer.getControl();
        String firstElementText = table.getItem(0).getText();
        LabelProvider provider = (LabelProvider)viewer.getLabelProvider();
        Assert.assertEquals((String)"same label text", (Object)Integer.valueOf(0).toString(), (Object)firstElementText);
        Assert.assertEquals((String)"same image", (Object)fgImage, (Object)provider.getImage((Object)table.getItem(0)));
    }

    @Test
    public void testCreateImageProvider() {
        Shell shell = LabelProviderLambdaTest.initializeShell();
        StructuredViewer viewer = LabelProviderLambdaTest.initializeViewer(shell);
        Image fgImage = ImageDescriptor.createFromFile(StructuredViewerTest.TestLabelProvider.class, (String)"images/java.gif").createImage();
        viewer.setLabelProvider((IBaseLabelProvider)LabelProvider.createImageProvider(inputElement -> fgImage));
        shell.open();
        Table table = (Table)viewer.getControl();
        LabelProvider provider = (LabelProvider)viewer.getLabelProvider();
        String firstElementText = table.getItem(0).getText();
        Assert.assertEquals((String)"same label text", (Object)Integer.valueOf(0).toString(), (Object)firstElementText);
        Assert.assertEquals((String)"same image", (Object)fgImage, (Object)provider.getImage((Object)table.getItem(0)));
    }
}

