/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.labelProviders;

import java.util.function.Function;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class LabelProviderTest {
    private static final Car HORCH = new Car("Horch");
    private static Image horchImage = new Image((Device)Display.getDefault(), (gc, width, height) -> {}, 50, 10);
    private static Image defaultImage = new Image((Device)Display.getDefault(), (gc, width, height) -> {}, 1, 1);
    private final Function<Object, String> textFunction = o -> o instanceof Car ? ((Car)o).getMake() : "unknown";
    private final Function<Object, Image> imageFunction = o -> o instanceof Car ? horchImage : defaultImage;

    @AfterClass
    public static void classTeardown() {
        horchImage.dispose();
        defaultImage.dispose();
    }

    @Test
    public void getTextGivesEmptyTextOnNull() {
        Assert.assertEquals((Object)"", (Object)new LabelProvider().getText(null));
    }

    @Test
    public void getTextGivesToString() {
        Assert.assertEquals((Object)"Make: Horch", (Object)new LabelProvider().getText((Object)HORCH));
    }

    @Test
    public void getImageGivesNullOnNull() {
        Assert.assertNull((Object)new LabelProvider().getImage(null));
    }

    @Test
    public void textProviderGivesTexts() {
        LabelProvider labelProvider = LabelProvider.createTextProvider(this.textFunction);
        Assert.assertEquals((Object)"Horch", (Object)labelProvider.getText((Object)HORCH));
        Assert.assertEquals((Object)"unknown", (Object)labelProvider.getText(new Object()));
        Assert.assertNull((Object)labelProvider.getImage((Object)HORCH));
    }

    @Test
    public void imageProviderGivesImages() {
        LabelProvider labelProvider = LabelProvider.createImageProvider(this.imageFunction);
        Assert.assertEquals((Object)horchImage, (Object)labelProvider.getImage((Object)HORCH));
        Assert.assertEquals((Object)defaultImage, (Object)labelProvider.getImage(new Object()));
        Assert.assertEquals((Object)"Make: Horch", (Object)labelProvider.getText((Object)HORCH));
    }

    @Test
    public void textImageProviderGivesBoth() {
        LabelProvider labelProvider = LabelProvider.createTextImageProvider(this.textFunction, this.imageFunction);
        Assert.assertEquals((Object)horchImage, (Object)labelProvider.getImage((Object)HORCH));
        Assert.assertEquals((Object)defaultImage, (Object)labelProvider.getImage(new Object()));
        Assert.assertEquals((Object)"Horch", (Object)labelProvider.getText((Object)HORCH));
        Assert.assertEquals((Object)"unknown", (Object)labelProvider.getText(new Object()));
    }

    @Test(expected=NullPointerException.class)
    public void throwsExceptionOnNullTextProvider() {
        LabelProvider.createTextProvider(null);
    }

    @Test(expected=NullPointerException.class)
    public void throwsExceptionOnNullImageProvider() {
        LabelProvider.createImageProvider(null);
    }

    @Test(expected=NullPointerException.class)
    public void throwsExceptionOnNullTextProviderInTextImageProvider() {
        LabelProvider.createTextImageProvider(null, this.imageFunction);
    }

    @Test(expected=NullPointerException.class)
    public void throwsExceptionOnNullImageProviderInTextImageProvider() {
        LabelProvider.createTextImageProvider(this.textFunction, null);
    }

    static class Car {
        private final String make;

        public Car(String make) {
            this.make = make;
        }

        public String getMake() {
            return this.make;
        }

        public String toString() {
            return "Make: " + this.make;
        }
    }
}

