/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.layout;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class AbstractColumnLayoutTest {
    Display display;
    Shell shell;

    @Before
    public void setUp() throws Exception {
        this.display = Display.getCurrent();
        if (this.display == null) {
            this.display = new Display();
        }
        this.shell = new Shell(this.display, 1264);
        this.shell.setSize(500, 500);
        this.shell.setLayout((Layout)new FillLayout());
    }

    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
    }

    @Test
    public void testIgnoreMinimumSize() {
        Composite composite = new Composite((Composite)this.shell, 0);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        Table table = new Table(composite, 2816);
        TableColumn col1 = new TableColumn(table, 16384);
        TableColumn col2 = new TableColumn(table, 16384);
        TableColumn col3 = new TableColumn(table, 16384);
        TableColumn col4 = new TableColumn(table, 16384);
        layout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(2, 100));
        layout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(2));
        layout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(1, 30));
        layout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnPixelData(1));
        composite.layout(true, true);
        this.shell.open();
        Assert.assertTrue((col1.getWidth() > 100 ? 1 : 0) != 0);
        Assert.assertEquals((long)col1.getWidth(), (long)col2.getWidth());
        Assert.assertTrue((Math.abs(col1.getWidth() - 2 * col3.getWidth()) <= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testRecalculatePreferredSize() {
        Composite composite = new Composite((Composite)this.shell, 0);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        Table table = new Table(composite, 2816);
        TableColumn col1 = new TableColumn(table, 16384);
        TableColumn col2 = new TableColumn(table, 16384);
        TableColumn col3 = new TableColumn(table, 16384);
        TableColumn col4 = new TableColumn(table, 16384);
        layout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(4, 40));
        layout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(1, 200));
        layout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(2, 30));
        layout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnPixelData(1));
        composite.layout(true, true);
        this.shell.open();
        Assert.assertTrue((col1.getWidth() >= 40 ? 1 : 0) != 0);
        Assert.assertTrue((col2.getWidth() >= 200 ? 1 : 0) != 0);
        Assert.assertTrue((col3.getWidth() >= 30 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(col1.getWidth() - 2 * col3.getWidth()) <= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testComputeSize() {
        Composite composite = new Composite((Composite)this.shell, 0);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        Table table = new Table(composite, 2816);
        TableColumn col1 = new TableColumn(table, 16384);
        TableColumn col2 = new TableColumn(table, 16384);
        layout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(1, 40));
        layout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(1, 200));
        this.shell.pack();
        this.shell.open();
        Assert.assertTrue((col1.getWidth() >= 40 ? 1 : 0) != 0);
        Assert.assertTrue((col2.getWidth() >= 200 ? 1 : 0) != 0);
        int width1 = col1.getWidth();
        int width2 = col2.getWidth();
        this.shell.pack();
        Assert.assertEquals((long)width1, (long)col1.getWidth());
        Assert.assertEquals((long)width2, (long)col2.getWidth());
    }
}

