/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.layout;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.junit.Assert;
import org.junit.Test;

public class GridDataFactoryTest {
    @Test
    public void testToStringWithAllOverrides() {
        GridDataFactory factory = GridDataFactory.fillDefaults().grab(true, false).align(16384, 4).indent(15, 23).span(1, 2).minSize(20, 30).hint(100, -1);
        Assert.assertEquals((Object)"GridDataFactory.fillDefaults()\n    .grab(true, false)\n    .align(SWT.LEFT, SWT.FILL)\n    .indent(15, 23)\n    .span(1, 2)\n    .minSize(20, 30)\n    .hint(100, SWT.DEFAULT)\n", (Object)factory.toString());
    }

    @Test
    public void testToStringGrab() {
        GridDataFactory factory = GridDataFactory.fillDefaults().grab(false, true);
        Assert.assertEquals((Object)"GridDataFactory.fillDefaults()\n    .grab(false, true)\n", (Object)factory.toString());
    }

    @Test
    public void testToStringAlign() {
        GridDataFactory factory = GridDataFactory.fillDefaults().align(4, 1024);
        Assert.assertEquals((Object)"GridDataFactory.fillDefaults()\n    .align(SWT.FILL, SWT.BOTTOM)\n", (Object)factory.toString());
    }

    @Test
    public void testToStringIndent() {
        GridDataFactory factory = GridDataFactory.fillDefaults().indent(10, 39);
        Assert.assertEquals((Object)"GridDataFactory.fillDefaults()\n    .indent(10, 39)\n", (Object)factory.toString());
    }

    @Test
    public void testToStringSpan() {
        GridDataFactory factory = GridDataFactory.fillDefaults().span(2, 3);
        Assert.assertEquals((Object)"GridDataFactory.fillDefaults()\n    .span(2, 3)\n", (Object)factory.toString());
    }

    @Test
    public void testToStringMinSize() {
        GridDataFactory factory = GridDataFactory.fillDefaults().minSize(30, 10);
        Assert.assertEquals((Object)"GridDataFactory.fillDefaults()\n    .minSize(30, 10)\n", (Object)factory.toString());
    }

    @Test
    public void testToStringHint() {
        GridDataFactory factory = GridDataFactory.fillDefaults().hint(-1, 310);
        Assert.assertEquals((Object)"GridDataFactory.fillDefaults()\n    .hint(SWT.DEFAULT, 310)\n", (Object)factory.toString());
    }

    @Test
    public void testToNoOverrides() {
        GridDataFactory factory = GridDataFactory.fillDefaults();
        Assert.assertEquals((Object)"GridDataFactory.fillDefaults()\n", (Object)factory.toString());
    }

    @Test
    public void testGridDataCreate() {
        GridData actual = GridDataFactory.create((int)768).create();
        GridData expected = new GridData(768);
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }
}

