/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.preferences;

import java.lang.reflect.Field;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BooleanFieldEditorTest {
    private Shell shell;
    private BooleanFieldEditor bfEditorWithSameLabel;
    private BooleanFieldEditor bfEditorWithSeparateLabel;
    private boolean otherThreadEventOccurred = false;
    private final Object lock = new Object();

    @Before
    public void setUp() throws Exception {
        this.shell = new Shell();
        this.bfEditorWithSameLabel = new BooleanFieldEditor("name", "label", (Composite)this.shell);
        this.bfEditorWithSeparateLabel = new BooleanFieldEditor("name2", "label", 1, (Composite)this.shell);
    }

    @Test
    public void testSetLabelText() {
        this.bfEditorWithSameLabel.setLabelText("label text");
        Assert.assertEquals((Object)"label text", (Object)this.bfEditorWithSameLabel.getLabelText());
        this.bfEditorWithSeparateLabel.setLabelText("label text");
        Assert.assertEquals((Object)"label text", (Object)this.bfEditorWithSameLabel.getLabelText());
    }

    @Test
    public void testLoad() {
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.bfEditorWithSameLabel.setPreferenceName("name");
        this.bfEditorWithSameLabel.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setDefault("name", true);
        myPreferenceStore.setValue("name", false);
        this.bfEditorWithSameLabel.load();
        Assert.assertFalse((boolean)this.bfEditorWithSameLabel.getBooleanValue());
        myPreferenceStore.setDefault("name", false);
        myPreferenceStore.setValue("name", true);
        this.bfEditorWithSameLabel.load();
        Assert.assertTrue((boolean)this.bfEditorWithSameLabel.getBooleanValue());
    }

    @Test
    public void testLoadDefault() {
        this.bfEditorWithSameLabel.setPropertyChangeListener(event -> this.otherThreadEventOccurred());
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.bfEditorWithSameLabel.setPreferenceName("name");
        this.bfEditorWithSameLabel.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setDefault("name", false);
        myPreferenceStore.setValue("name", true);
        this.bfEditorWithSameLabel.loadDefault();
        Assert.assertFalse((boolean)this.bfEditorWithSameLabel.getBooleanValue());
        myPreferenceStore.setDefault("name", true);
        myPreferenceStore.setValue("name", false);
        this.bfEditorWithSameLabel.loadDefault();
        Assert.assertTrue((boolean)this.bfEditorWithSameLabel.getBooleanValue());
        this.waitForEventInOtherThread();
        Assert.assertTrue((boolean)this.otherThreadEventOccurred);
    }

    @Test
    public void testGetBooleanValue() {
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.bfEditorWithSameLabel.setPreferenceName("name");
        this.bfEditorWithSameLabel.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setValue("name", true);
        this.bfEditorWithSameLabel.load();
        Assert.assertTrue((boolean)this.bfEditorWithSameLabel.getBooleanValue());
        Button button = BooleanFieldEditorTest.getButton(this.bfEditorWithSameLabel);
        button.setSelection(false);
        Assert.assertFalse((boolean)this.bfEditorWithSameLabel.getBooleanValue());
        button.setSelection(true);
        Assert.assertTrue((boolean)this.bfEditorWithSameLabel.getBooleanValue());
    }

    @Test
    public void testStore() {
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.bfEditorWithSameLabel.setPreferenceName("name");
        this.bfEditorWithSameLabel.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setValue("name", true);
        this.bfEditorWithSameLabel.load();
        Assert.assertTrue((boolean)this.bfEditorWithSameLabel.getBooleanValue());
        Button button = BooleanFieldEditorTest.getButton(this.bfEditorWithSameLabel);
        button.setSelection(false);
        Assert.assertTrue((boolean)myPreferenceStore.getBoolean("name"));
        this.bfEditorWithSameLabel.store();
        Assert.assertFalse((boolean)myPreferenceStore.getBoolean("name"));
        button.setSelection(true);
        Assert.assertTrue((boolean)this.bfEditorWithSameLabel.getBooleanValue());
        Assert.assertFalse((boolean)myPreferenceStore.getBoolean("name"));
        this.bfEditorWithSameLabel.store();
        Assert.assertTrue((boolean)myPreferenceStore.getBoolean("name"));
    }

    @Test
    public void testValueChanged() {
        this.bfEditorWithSameLabel.setPropertyChangeListener(event -> this.otherThreadEventOccurred());
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.bfEditorWithSameLabel.setPreferenceName("name");
        this.bfEditorWithSameLabel.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setValue("name", false);
        this.bfEditorWithSameLabel.load();
        Assert.assertFalse((boolean)this.bfEditorWithSameLabel.getBooleanValue());
        Button button = BooleanFieldEditorTest.getButton(this.bfEditorWithSameLabel);
        button.setSelection(true);
        Assert.assertFalse((boolean)this.otherThreadEventOccurred);
        button.notifyListeners(13, null);
        Assert.assertTrue((boolean)this.bfEditorWithSameLabel.getBooleanValue());
        this.waitForEventInOtherThread();
        Assert.assertTrue((boolean)this.otherThreadEventOccurred);
    }

    @Test
    public void testSetFocus() {
        this.bfEditorWithSameLabel = new BooleanFieldEditor("name", "label", (Composite)this.shell){

            protected Button getChangeControl(Composite parent) {
                return new Button(parent, 32){

                    protected void checkSubclass() {
                    }

                    public boolean setFocus() {
                        BooleanFieldEditorTest.this.otherThreadEventOccurred();
                        return super.setFocus();
                    }
                };
            }
        };
        Assert.assertFalse((boolean)this.otherThreadEventOccurred);
        this.bfEditorWithSameLabel.setFocus();
        this.waitForEventInOtherThread();
        Assert.assertTrue((boolean)this.otherThreadEventOccurred);
    }

    @Test
    public void testSetEnabled() {
        Button buttonWithSameLabel = BooleanFieldEditorTest.getButton(this.bfEditorWithSameLabel);
        this.bfEditorWithSameLabel.setEnabled(true, (Composite)this.shell);
        Assert.assertTrue((boolean)buttonWithSameLabel.isEnabled());
        this.bfEditorWithSameLabel.setEnabled(false, (Composite)this.shell);
        Assert.assertFalse((boolean)buttonWithSameLabel.isEnabled());
        this.bfEditorWithSameLabel.setEnabled(true, (Composite)this.shell);
        Assert.assertTrue((boolean)buttonWithSameLabel.isEnabled());
        Button buttonWithSeparateLabel = BooleanFieldEditorTest.getButton(this.bfEditorWithSeparateLabel);
        Label separateLabel = this.bfEditorWithSeparateLabel.getLabelControl((Composite)this.shell);
        this.bfEditorWithSeparateLabel.setEnabled(true, (Composite)this.shell);
        Assert.assertTrue((boolean)buttonWithSeparateLabel.isEnabled());
        Assert.assertTrue((boolean)separateLabel.isEnabled());
        this.bfEditorWithSeparateLabel.setEnabled(false, (Composite)this.shell);
        Assert.assertFalse((boolean)buttonWithSeparateLabel.isEnabled());
        Assert.assertFalse((boolean)separateLabel.isEnabled());
        this.bfEditorWithSeparateLabel.setEnabled(true, (Composite)this.shell);
        Assert.assertTrue((boolean)buttonWithSeparateLabel.isEnabled());
        Assert.assertTrue((boolean)separateLabel.isEnabled());
    }

    @Test
    public void testAdjustForNumColumns() {
        final BooleanFieldEditor[] editors = new BooleanFieldEditor[2];
        FieldEditorPreferencePage page = new FieldEditorPreferencePage(1){

            protected void createFieldEditors() {
                Composite parent = this.getFieldEditorParent();
                BooleanFieldEditor bfEditorWithSameLabel = new BooleanFieldEditor("name", "label", parent);
                BooleanFieldEditor bfEditorWithSeparateLabel = new BooleanFieldEditor("name2", "label", 1, parent);
                editors[0] = bfEditorWithSameLabel;
                editors[1] = bfEditorWithSeparateLabel;
                this.addField((FieldEditor)bfEditorWithSameLabel);
                this.addField((FieldEditor)bfEditorWithSeparateLabel);
            }
        };
        page.createControl((Composite)this.shell);
        BooleanFieldEditor bfEditorWithSameLabel = editors[0];
        BooleanFieldEditor bfEditorWithSeparateLabel = editors[1];
        Button buttonWithSameLabel = BooleanFieldEditorTest.getButton(bfEditorWithSameLabel);
        Button buttonWithSeparateLabel = BooleanFieldEditorTest.getButton(bfEditorWithSeparateLabel);
        int withLabelSpan = ((GridData)buttonWithSameLabel.getLayoutData()).horizontalSpan;
        int separateLabelSpan = ((GridData)buttonWithSeparateLabel.getLayoutData()).horizontalSpan;
        Assert.assertEquals((long)(withLabelSpan - 1), (long)separateLabelSpan);
    }

    private static Button getButton(BooleanFieldEditor booleanFieldEditor) {
        try {
            Field f = BooleanFieldEditor.class.getDeclaredField("checkBox");
            f.setAccessible(true);
            return (Button)f.get(booleanFieldEditor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void otherThreadEventOccurred() {
        Object object = this.lock;
        synchronized (object) {
            this.otherThreadEventOccurred = true;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEventInOtherThread() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.otherThreadEventOccurred) {
                try {
                    this.lock.wait(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

