/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntegerFieldEditorTest {
    private Shell shell;
    private IntegerFieldEditor integerFieldEditor;

    @Before
    public void setUp() throws Exception {
        this.shell = new Shell();
        this.integerFieldEditor = new IntegerFieldEditor("name", "label", (Composite)this.shell);
        this.integerFieldEditor.setValidRange(0, 500);
        this.integerFieldEditor.setValidateStrategy(0);
    }

    @Test
    public void testLoad() {
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.integerFieldEditor.setPreferenceName("name");
        this.integerFieldEditor.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setDefault("name", 5);
        this.integerFieldEditor.load();
        Assert.assertEquals((long)this.integerFieldEditor.getIntValue(), (long)5L);
        myPreferenceStore.setDefault("name", 5);
        myPreferenceStore.setValue("name", 6);
        this.integerFieldEditor.load();
        Assert.assertEquals((long)this.integerFieldEditor.getIntValue(), (long)6L);
    }

    @Test
    public void testLoadDefault() {
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.integerFieldEditor.setPreferenceName("name");
        this.integerFieldEditor.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setDefault("name", 5);
        myPreferenceStore.setValue("name", 6);
        this.integerFieldEditor.loadDefault();
        Assert.assertEquals((long)this.integerFieldEditor.getIntValue(), (long)5L);
    }

    @Test
    public void testSetValueInWidget() {
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.integerFieldEditor.setPreferenceName("name");
        this.integerFieldEditor.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setValue("name", 5);
        this.integerFieldEditor.load();
        Assert.assertEquals((long)this.integerFieldEditor.getIntValue(), (long)5L);
        Text text = this.integerFieldEditor.getTextControl((Composite)this.shell);
        text.setText("6");
        Assert.assertEquals((long)this.integerFieldEditor.getIntValue(), (long)6L);
    }

    @Test
    public void testSetValueInEditor() {
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.integerFieldEditor.setPreferenceName("name");
        this.integerFieldEditor.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setValue("name", 5);
        this.integerFieldEditor.load();
        Assert.assertEquals((long)this.integerFieldEditor.getIntValue(), (long)5L);
        this.integerFieldEditor.setStringValue("6");
        Text text = this.integerFieldEditor.getTextControl((Composite)this.shell);
        Assert.assertEquals((Object)text.getText(), (Object)"6");
        Assert.assertEquals((long)this.integerFieldEditor.getIntValue(), (long)6L);
    }

    @Test
    public void testValidate() {
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.integerFieldEditor.setPreferenceName("name");
        this.integerFieldEditor.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setValue("name", 5000);
        this.integerFieldEditor.load();
        Assert.assertFalse((boolean)this.integerFieldEditor.isValid());
    }
}

