/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.ScaleFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScaleFieldEditorTest {
    private static final String PREFKEY = "scaleValue";
    private Shell shell;
    private ScaleFieldEditor editor;

    @Before
    public void setUp() {
        this.shell = new Shell(0);
        this.editor = new ScaleFieldEditor(PREFKEY, "Test Scale", (Composite)this.shell);
    }

    @After
    public void tearDown() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    @Test
    public void testConstructorArgs() {
        Scale scale = new Scale((Composite)this.shell, 0);
        int defaultMax = scale.getMaximum();
        scale.dispose();
        int newMin = defaultMax + 1;
        int newMax = defaultMax + 100;
        this.editor.dispose();
        this.editor = new ScaleFieldEditor(PREFKEY, "Test Scale", (Composite)this.shell, newMin, newMax, 3, 9);
        Assert.assertEquals((long)newMin, (long)this.editor.getMinimum());
        Assert.assertEquals((long)newMin, (long)this.editor.getScaleControl().getMinimum());
        Assert.assertEquals((long)newMax, (long)this.editor.getMaximum());
        Assert.assertEquals((long)newMax, (long)this.editor.getScaleControl().getMaximum());
        Assert.assertEquals((long)3L, (long)this.editor.getIncrement());
        Assert.assertEquals((long)3L, (long)this.editor.getScaleControl().getIncrement());
        Assert.assertEquals((long)9L, (long)this.editor.getScaleControl().getPageIncrement());
        Assert.assertEquals((long)9L, (long)this.editor.getPageIncrement());
    }

    @Test
    public void testGetterAndSetter() {
        Scale widget = this.editor.getScaleControl();
        Assert.assertNotNull((Object)widget);
        Assert.assertEquals((long)10L, (long)this.editor.getMaximum());
        Assert.assertEquals((long)10L, (long)widget.getMaximum());
        this.editor.setMaximum(999);
        Assert.assertEquals((long)999L, (long)this.editor.getMaximum());
        Assert.assertEquals((long)999L, (long)widget.getMaximum());
        Assert.assertEquals((long)0L, (long)this.editor.getMinimum());
        Assert.assertEquals((long)0L, (long)widget.getMinimum());
        this.editor.setMinimum(99);
        Assert.assertEquals((long)99L, (long)this.editor.getMinimum());
        Assert.assertEquals((long)99L, (long)widget.getMinimum());
        Assert.assertEquals((long)1L, (long)this.editor.getIncrement());
        Assert.assertEquals((long)1L, (long)widget.getIncrement());
        this.editor.setIncrement(9);
        Assert.assertEquals((long)9L, (long)this.editor.getIncrement());
        Assert.assertEquals((long)9L, (long)widget.getIncrement());
        Assert.assertEquals((long)1L, (long)this.editor.getPageIncrement());
        Assert.assertEquals((long)1L, (long)widget.getPageIncrement());
        this.editor.setPageIncrement(99);
        Assert.assertEquals((long)99L, (long)this.editor.getPageIncrement());
        Assert.assertEquals((long)99L, (long)widget.getPageIncrement());
        Assert.assertTrue((boolean)this.editor.getLabelControl((Composite)this.shell).isEnabled());
        Assert.assertTrue((boolean)widget.isEnabled());
        this.editor.setEnabled(false, (Composite)this.shell);
        Assert.assertFalse((boolean)this.editor.getLabelControl((Composite)this.shell).isEnabled());
        Assert.assertFalse((boolean)widget.isEnabled());
    }

    @Test
    public void testLoad() {
        Scale widget = this.editor.getScaleControl();
        Assert.assertEquals((long)0L, (long)widget.getSelection());
        PreferenceStore prefStoreWithDefault = new PreferenceStore();
        prefStoreWithDefault.setDefault(PREFKEY, 2);
        this.editor.setPreferenceStore((IPreferenceStore)prefStoreWithDefault);
        this.editor.load();
        Assert.assertEquals((long)2L, (long)widget.getSelection());
        PreferenceStore prefStoreWithDefaultAndValue = new PreferenceStore();
        prefStoreWithDefaultAndValue.setDefault(PREFKEY, 2);
        prefStoreWithDefaultAndValue.setValue(PREFKEY, 4);
        this.editor.setPreferenceStore((IPreferenceStore)prefStoreWithDefaultAndValue);
        this.editor.load();
        Assert.assertEquals((long)4L, (long)widget.getSelection());
    }

    @Test
    public void testLoadDefault() {
        Scale widget = this.editor.getScaleControl();
        Assert.assertEquals((long)0L, (long)widget.getSelection());
        PreferenceStore prefStoreWithDefaultAndValue = new PreferenceStore();
        prefStoreWithDefaultAndValue.setDefault(PREFKEY, 2);
        prefStoreWithDefaultAndValue.setValue(PREFKEY, 4);
        this.editor.setPreferenceStore((IPreferenceStore)prefStoreWithDefaultAndValue);
        this.editor.load();
        Assert.assertEquals((long)4L, (long)widget.getSelection());
        this.editor.loadDefault();
        Assert.assertEquals((long)2L, (long)widget.getSelection());
    }

    @Test
    public void testSetValueInWidget() {
        Scale widget = this.editor.getScaleControl();
        Assert.assertEquals((long)0L, (long)widget.getSelection());
        int min = 100;
        int max = 103;
        this.editor.setMinimum(100);
        this.editor.setMaximum(103);
        Assert.assertEquals((long)100L, (long)widget.getSelection());
        widget.setSelection(99);
        Assert.assertEquals((long)100L, (long)widget.getSelection());
        widget.setSelection(100);
        Assert.assertEquals((long)100L, (long)widget.getSelection());
        widget.setSelection(101);
        Assert.assertEquals((long)101L, (long)widget.getSelection());
        widget.setSelection(103);
        Assert.assertEquals((long)103L, (long)widget.getSelection());
        widget.setSelection(104);
        Assert.assertEquals((long)103L, (long)widget.getSelection());
    }
}

