/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringFieldEditorTest {
    private Shell shell;
    private StringFieldEditor stringFieldEditor;

    @Before
    public void setUp() throws Exception {
        this.shell = new Shell();
        this.stringFieldEditor = new StringFieldEditor("name", "label", (Composite)this.shell);
    }

    @Test
    public void testSetLabelText() {
        this.stringFieldEditor.setLabelText("label text");
        Assert.assertEquals((Object)"label text", (Object)this.stringFieldEditor.getLabelText());
        this.stringFieldEditor.setLabelText("label text");
        Assert.assertEquals((Object)"label text", (Object)this.stringFieldEditor.getLabelText());
    }

    @Test
    public void testLoad() {
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.stringFieldEditor.setPreferenceName("name");
        this.stringFieldEditor.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setDefault("name", "foo");
        this.stringFieldEditor.load();
        Assert.assertEquals((Object)this.stringFieldEditor.getStringValue(), (Object)"foo");
        myPreferenceStore.setDefault("name", "foo");
        myPreferenceStore.setValue("name", "bar");
        this.stringFieldEditor.load();
        Assert.assertEquals((Object)this.stringFieldEditor.getStringValue(), (Object)"bar");
    }

    @Test
    public void testLoadDefault() {
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.stringFieldEditor.setPreferenceName("name");
        this.stringFieldEditor.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setDefault("name", "foo");
        myPreferenceStore.setValue("name", "bar");
        this.stringFieldEditor.loadDefault();
        Assert.assertEquals((Object)this.stringFieldEditor.getStringValue(), (Object)"foo");
    }

    @Test
    public void testSetValueInWidget() {
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.stringFieldEditor.setPreferenceName("name");
        this.stringFieldEditor.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setValue("name", "foo");
        this.stringFieldEditor.load();
        Assert.assertEquals((Object)this.stringFieldEditor.getStringValue(), (Object)"foo");
        Text text = this.stringFieldEditor.getTextControl((Composite)this.shell);
        text.setText("bar");
        Assert.assertEquals((Object)this.stringFieldEditor.getStringValue(), (Object)"bar");
    }

    @Test
    public void testSetValueInEditor() {
        PreferenceStore myPreferenceStore = new PreferenceStore();
        this.stringFieldEditor.setPreferenceName("name");
        this.stringFieldEditor.setPreferenceStore((IPreferenceStore)myPreferenceStore);
        myPreferenceStore.setValue("name", "foo");
        this.stringFieldEditor.load();
        Assert.assertEquals((Object)this.stringFieldEditor.getStringValue(), (Object)"foo");
        this.stringFieldEditor.setStringValue("bar");
        Text text = this.stringFieldEditor.getTextControl((Composite)this.shell);
        Assert.assertEquals((Object)text.getText(), (Object)"bar");
        Assert.assertEquals((Object)this.stringFieldEditor.getStringValue(), (Object)"bar");
    }

    @Test
    public void testBug289599() {
        PreferenceStore store = new PreferenceStore();
        store.setDefault("foo", "bar");
        Assert.assertEquals((Object)"bar", (Object)store.getString("foo"));
        store.setValue("foo", "???");
        Assert.assertEquals((Object)"???", (Object)store.getString("foo"));
        IPropertyChangeListener listener = event -> {
            Assert.assertEquals((Object)"foo", (Object)event.getProperty());
            Assert.assertEquals((Object)"???", (Object)event.getOldValue());
            Assert.assertEquals((Object)"bar", (Object)event.getNewValue());
        };
        store.addPropertyChangeListener(listener);
        store.setToDefault("foo");
        store.removePropertyChangeListener(listener);
        Assert.assertEquals((Object)"bar", (Object)store.getString("foo"));
        IPropertyChangeListener failingListener = event -> Assert.fail((String)"1.0");
        store.addPropertyChangeListener(failingListener);
        store.setToDefault("foo");
        store.removePropertyChangeListener(failingListener);
        Assert.assertEquals((Object)"bar", (Object)store.getString("foo"));
    }
}

