/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.resources;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class FontRegistryTest {
    @Test
    public void testBug544026() {
        Object[] fontData = JFaceResources.getDefaultFont().getFontData();
        fontData[0].setHeight(fontData[0].getHeight() + 1);
        Font temp = new Font((Device)Display.getCurrent(), (FontData[])fontData);
        fontData = temp.getFontData();
        temp.dispose();
        JFaceResources.getFontRegistry().put("org.eclipse.jface.defaultfont", (FontData[])fontData);
        Assert.assertArrayEquals((Object[])fontData, (Object[])JFaceResources.getDefaultFont().getFontData());
    }

    @Test
    public void multipleDisplayDispose() {
        Assume.assumeTrue((String)"multiple Display instance only allowed on Windows", (boolean)Platform.OS.isWindows());
        FontRegistry fontRegistry = new FontRegistry();
        Display secondDisplay = FontRegistryTest.initializeDisplayInSeparateThread();
        Font fontOnSecondDisplay = (Font)secondDisplay.syncCall(() -> ((FontRegistry)fontRegistry).defaultFont());
        Font fontOnThisDisplayBeforeSecondDisplayDispose = fontRegistry.defaultFont();
        Device displayOfFontOnSecondDisplay = fontOnSecondDisplay.getDevice();
        Assert.assertEquals((Object)secondDisplay, (Object)displayOfFontOnSecondDisplay);
        Assert.assertEquals((Object)fontOnThisDisplayBeforeSecondDisplayDispose, (Object)fontOnSecondDisplay);
        secondDisplay.syncExec(() -> ((Display)secondDisplay).dispose());
        Assert.assertTrue((boolean)fontOnSecondDisplay.isDisposed());
        Font fontOnThisDisplayAfterSecondDisplayDispose = fontRegistry.defaultFont();
        Assert.assertNotEquals((Object)fontOnThisDisplayAfterSecondDisplayDispose, (Object)fontOnSecondDisplay);
    }

    private static Display initializeDisplayInSeparateThread() {
        AtomicReference<Display> displayReference = new AtomicReference<Display>();
        new Thread(() -> {
            Display display = new Display();
            displayReference.set(display);
            while (!display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }, "async display creation").start();
        FontRegistryTest.waitForDisplayInstantiation(displayReference);
        return displayReference.get();
    }

    private static void waitForDisplayInstantiation(AtomicReference<Display> displayReference) {
        Instant maximumEndTime = Instant.now().plus(Duration.ofSeconds(10L));
        while (displayReference.get() == null) {
            Assert.assertFalse((String)"display was not instantiated in time", (boolean)Instant.now().isAfter(maximumEndTime));
            Thread.yield();
        }
    }
}

