/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import org.eclipse.jface.tests.viewers.StructuredItemViewerTest;
import org.eclipse.jface.tests.viewers.StructuredViewerTest;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelChange;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTreeViewerTest
extends StructuredItemViewerTest {
    AbstractTreeViewer fTreeViewer;

    @Override
    protected void assertSelectionEquals(String message, TestElement expected) {
        IStructuredSelection selection = this.fViewer.getStructuredSelection();
        ArrayList<TestElement> expectedList = new ArrayList<TestElement>();
        expectedList.add(expected);
        Assert.assertEquals((String)("selectionEquals - " + message), expectedList, (Object)selection.toList());
    }

    protected abstract int getItemCount(TestElement var1);

    @Test
    public void testBulkExpand() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement first2 = first.getFirstChild();
        TestElement last = this.fRootElement.getLastChild();
        this.fTreeViewer.expandToLevel((Object)first, 2);
        this.fTreeViewer.expandToLevel((Object)first2, 2);
        this.fTreeViewer.expandToLevel((Object)last, 2);
        Object[] list1 = this.fTreeViewer.getExpandedElements();
        this.setInput();
        this.processEvents();
        this.fTreeViewer.collapseAll();
        this.fTreeViewer.expandToLevel((Object)first, 2);
        this.fTreeViewer.expandToLevel((Object)first2, 2);
        this.fTreeViewer.expandToLevel((Object)last, 2);
        Object[] list2 = this.fTreeViewer.getExpandedElements();
        Assert.assertArrayEquals((String)"old and new expand state are the same", (Object[])list1, (Object[])list2);
    }

    @Test
    public void testDeleteChildExpanded() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement first2 = first.getFirstChild();
        this.fTreeViewer.expandToLevel((Object)first2, 0);
        Assert.assertNotNull((String)"first child is visible", (Object)this.fViewer.testFindItem((Object)first2));
        first.deleteChild(first2);
        Assert.assertNull((String)"first child is not visible", (Object)this.fViewer.testFindItem((Object)first2));
    }

    @Test
    public void testDeleteChildren() {
        TestElement first = this.fRootElement.getFirstChild();
        first.deleteChildren();
        Assert.assertEquals((String)"no children", (long)0L, (long)this.getItemCount(first));
    }

    @Test
    public void testDeleteChildrenExpanded() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement first2 = first.getFirstChild();
        this.fTreeViewer.expandToLevel((Object)first2, 0);
        Assert.assertNotNull((String)"first child is visible", (Object)this.fViewer.testFindItem((Object)first2));
        first.deleteChildren();
        Assert.assertEquals((String)"no children", (long)0L, (long)this.getItemCount(first));
    }

    @Test
    public void testExpand() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement first2 = first.getFirstChild();
        Assert.assertNull((String)"first child is not visible", (Object)this.fViewer.testFindItem((Object)first2));
        this.fTreeViewer.expandToLevel((Object)first2, 0);
        Assert.assertNotNull((String)"first child is visible", (Object)this.fViewer.testFindItem((Object)first2));
    }

    @Test
    public void testExpandElement() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement first2 = first.getFirstChild();
        TestElement first3 = first2.getFirstChild();
        this.fTreeViewer.expandToLevel((Object)first3, 0);
        Assert.assertNotNull((String)"first3 is visible", (Object)this.fViewer.testFindItem((Object)first3));
        Assert.assertNotNull((String)"first2 is visible", (Object)this.fViewer.testFindItem((Object)first2));
    }

    @Test
    public void testExpandElementAgain() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement first2 = first.getFirstChild();
        TestElement first3 = first2.getFirstChild();
        this.fTreeViewer.expandToLevel((Object)first3, 0);
        Assert.assertTrue((String)"first is expanded", (boolean)this.fTreeViewer.getExpandedState((Object)first));
        Assert.assertTrue((String)"first2 is expanded", (boolean)this.fTreeViewer.getExpandedState((Object)first2));
        Assert.assertNotNull((String)"first3 is visible", (Object)this.fViewer.testFindItem((Object)first3));
        this.fTreeViewer.setExpandedState((Object)first, false);
        this.fTreeViewer.expandToLevel((Object)first3, 0);
        Assert.assertTrue((String)"first is expanded", (boolean)this.fTreeViewer.getExpandedState((Object)first));
        Assert.assertTrue((String)"first2 is expanded", (boolean)this.fTreeViewer.getExpandedState((Object)first2));
        Assert.assertNotNull((String)"first3 is visible", (Object)this.fViewer.testFindItem((Object)first3));
    }

    @Test
    public void testExpandToLevel() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement first2 = first.getFirstChild();
        TestElement first3 = first2.getFirstChild();
        this.fTreeViewer.expandToLevel(3);
        DisplayHelper.waitAndAssertCondition((Display)this.fShell.getDisplay(), () -> {
            Assert.assertNotNull((Object)this.fViewer.testFindItem((Object)first2));
            Assert.assertNotNull((Object)this.fViewer.testFindItem((Object)first3));
        });
        Assert.assertNotNull((String)"first2 is visible", (Object)this.fViewer.testFindItem((Object)first2));
        Assert.assertNotNull((String)"first3 is visible", (Object)this.fViewer.testFindItem((Object)first3));
    }

    @Test
    public void testAutoExpandOnSingleChild() {
        TestElement modelRoot = TestElement.createModel(5, 1);
        TestElement trivialPathRoot = modelRoot.getFirstChild();
        this.fViewer.setInput((Object)modelRoot);
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(2);
        this.fTreeViewer.setExpandedStateWithAutoExpandOnSingleChild((Object)trivialPathRoot, true);
        Assert.assertTrue((String)"The expanded widget child is not expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot));
        Assert.assertTrue((String)"The first child of the trivial path was not auto-expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild()));
        Assert.assertFalse((String)"Trivial path is expanded further than specified depth ", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild().getFirstChild()));
    }

    @Test
    public void testAutoExpandOnSingleChildDeeperDownPath() {
        TestElement modelRoot = TestElement.createModel(6, 1);
        TestElement trivialPathRoot = modelRoot.getFirstChild();
        this.fViewer.setInput((Object)modelRoot);
        this.fTreeViewer.setExpandedState((Object)modelRoot, true);
        this.fTreeViewer.setExpandedState((Object)trivialPathRoot, true);
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(2);
        this.fTreeViewer.setExpandedStateWithAutoExpandOnSingleChild((Object)trivialPathRoot.getFirstChild(), true);
        Assert.assertTrue((String)"The first child of the trivial path was not auto-expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild()));
        Assert.assertTrue((String)"The second child of the trivial path was not auto-expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild().getFirstChild()));
        Assert.assertFalse((String)"Trivial path is expanded further than specified depth ", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild().getFirstChild().getFirstChild()));
    }

    @Test
    public void testAutoExpandOnSingleChildFromRoot() {
        TestElement modelRoot;
        TestElement trivialPathRoot = modelRoot = TestElement.createModel(5, 5);
        this.fViewer.setInput((Object)modelRoot);
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(2);
        this.fTreeViewer.setExpandedStateWithAutoExpandOnSingleChild((Object)trivialPathRoot, true);
        Assert.assertFalse((String)"The first child of the trivial path was auto-expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild()));
    }

    @Test
    public void testAutoExpandOnSingleChildFromRootWithSensibleTrivialPath() {
        TestElement modelRoot;
        TestElement trivialPathRoot = modelRoot = TestElement.createModel(5, 1);
        this.fViewer.setInput((Object)modelRoot);
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(2);
        this.fTreeViewer.setExpandedStateWithAutoExpandOnSingleChild((Object)trivialPathRoot, true);
        Assert.assertTrue((String)"The first child of the trivial path was auto-expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild()));
    }

    @Test
    public void testAutoExpandOnSingleChildSmallerThanAutoExpandDepth() {
        TestElement modelRoot = TestElement.createModel(2, 1);
        TestElement trivialPathRoot = modelRoot.getFirstChild();
        this.fViewer.setInput((Object)modelRoot);
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(10);
        this.fTreeViewer.setExpandedStateWithAutoExpandOnSingleChild((Object)trivialPathRoot, true);
        Assert.assertTrue((String)"The expanded widget child is not expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot));
        Assert.assertFalse((String)"The first child of the trivial path was auto-expanded although it contains zero children", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild()));
    }

    @Test
    public void testSetAutoExpandOnSingleChildLevels() {
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(0);
        Assert.assertEquals((String)"Setting an auto-expansion level of NO_EXPAND works", (long)this.fTreeViewer.getAutoExpandOnSingleChildLevels(), (long)0L);
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(4);
        Assert.assertEquals((String)"Setting a non-trivial auto-expansion level works", (long)this.fTreeViewer.getAutoExpandOnSingleChildLevels(), (long)4L);
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(0);
        Assert.assertEquals((String)"Setting an auto-expansion level of NO_EXPAND works", (long)this.fTreeViewer.getAutoExpandOnSingleChildLevels(), (long)0L);
    }

    @Test
    public void testAutoExpandOnSingleChildManualDisable() {
        TestElement modelRoot = TestElement.createModel(5, 1);
        TestElement trivialPathRoot = modelRoot.getFirstChild();
        this.fViewer.setInput((Object)modelRoot);
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(0);
        this.fTreeViewer.setExpandedStateWithAutoExpandOnSingleChild((Object)trivialPathRoot, true);
        Assert.assertTrue((String)"The expanded widget child is not expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot));
        Assert.assertFalse((String)"The first child of the trivial path was auto-expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild()));
    }

    public void testAutoExpandOnSingleChildManualEnableAndThenDisable() {
        TestElement modelRoot = TestElement.createModel(5, 1);
        TestElement trivialPathRoot = modelRoot.getFirstChild();
        this.fViewer.setInput((Object)modelRoot);
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(2);
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(0);
        this.fTreeViewer.setExpandedStateWithAutoExpandOnSingleChild((Object)trivialPathRoot, true);
        Assert.assertTrue((String)"The expanded widget child is not expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot));
        Assert.assertFalse((String)"The first child of the trivial path was auto-expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild()));
    }

    @Test
    public void testAutoExpandOnSingleChildInfiniteExpand() {
        TestElement modelRoot = TestElement.createModel(5, 1);
        TestElement trivialPathRoot = modelRoot.getFirstChild();
        this.fViewer.setInput((Object)modelRoot);
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(-1);
        this.fTreeViewer.setExpandedStateWithAutoExpandOnSingleChild((Object)trivialPathRoot, true);
        Assert.assertTrue((String)"The expanded widget child is not expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot));
        TestElement child = trivialPathRoot.getFirstChild();
        int depth = 1;
        while (child != null) {
            Assert.assertTrue((String)("The " + depth + ". child of the trivial path was not auto-expanded"), (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild()));
            child = child.getFirstChild();
            ++depth;
        }
    }

    public void testFilterExpanded() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement first2 = first.getFirstChild();
        this.fTreeViewer.expandToLevel((Object)first2, 0);
        this.fTreeViewer.addFilter((ViewerFilter)new StructuredViewerTest.TestLabelFilter());
        Assert.assertEquals((String)"filtered count", (long)5L, (long)this.getItemCount());
    }

    @Test
    public void testInsertChildReveal() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement newElement = first.addChild(17);
        Assert.assertNotNull((String)"new sibling is visible", (Object)this.fViewer.testFindItem((Object)newElement));
    }

    @Test
    public void testInsertChildRevealSelect() {
        TestElement last = this.fRootElement.getLastChild();
        TestElement newElement = last.addChild(49);
        Assert.assertNotNull((String)"new sibling is visible", (Object)this.fViewer.testFindItem((Object)newElement));
        this.assertSelectionEquals("new element is selected", newElement);
    }

    @Test
    public void testInsertChildRevealSelectExpanded() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement newElement = first.addChild(49);
        Assert.assertNotNull((String)"new sibling is visible", (Object)this.fViewer.testFindItem((Object)newElement));
        this.assertSelectionEquals("new element is selected", newElement);
    }

    @Test
    public void testRefreshWithAddedChildren() {
        TestElement parent = this.fRootElement.addChild(1);
        TestElement child = parent.addChild(1);
        ((AbstractTreeViewer)this.fViewer).setExpandedState((Object)parent, true);
        parent.deleteChild(child);
        child = parent.addChild(3);
        this.waitForJobs(300L, 1000L);
        this.processEvents();
        if (((AbstractTreeViewer)this.fViewer).getExpandedState((Object)parent)) {
            Assert.assertNotNull((String)"new child is visible", (Object)this.fViewer.testFindItem((Object)child));
        }
    }

    @Test
    public void testRefreshWithDuplicateChild() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement newElement = (TestElement)first.clone();
        this.fRootElement.addChild(newElement, new TestModelChange(3, this.fRootElement));
        Assert.assertNotNull((String)"new sibling is visible", (Object)this.fViewer.testFindItem((Object)newElement));
    }

    @Test
    public void testRefreshWithReusedItems() {
    }

    @Test
    public void testRenameChildElement() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement first2 = first.getFirstChild();
        this.fTreeViewer.expandToLevel((Object)first2, 0);
        Assert.assertNotNull((String)"first child is visible", (Object)this.fViewer.testFindItem((Object)first2));
        String newLabel = first2.getLabel() + " changed";
        first2.setLabel(newLabel);
        Widget widget = this.fViewer.testFindItem((Object)first2);
        Assert.assertTrue((boolean)(widget instanceof Item));
        Assert.assertEquals((String)"changed label", (Object)(first2.getID() + " " + newLabel), (Object)((Item)widget).getText());
    }

    @Test
    public void testSetExpandedWithCycle() {
        TestElement first = this.fRootElement.getFirstChild();
        first.addChild(first, new TestModelChange(1, first, first));
        this.fTreeViewer.setExpandedElements(new Object[]{first});
    }

    @Test
    public void testSetDuplicateChild() {
        TestElement parent = this.fRootElement.addChild(1);
        TestElement child = parent.addChild(1);
        int initialCount = this.getItemCount(parent);
        this.fRootElement.addChild(child, new TestModelChange(1, this.fRootElement, child));
        int postCount = this.getItemCount(parent);
        Assert.assertEquals((String)"Same element added to a parent twice.", (long)initialCount, (long)postCount);
    }

    @Test
    public void testChildIsNotDuplicatedWhenCompareEquals() {
        this.fTreeViewer.setComparator((ViewerComparator)new StructuredViewerTest.TestLabelComparator());
        this.fRootElement.deleteChildren();
        TestElement child1 = this.fRootElement.addChild(1);
        child1.setLabel("1");
        TestElement child2 = this.fRootElement.addChild(1);
        child2.setLabel("1");
        TestElement child3 = this.fRootElement.addChild(1);
        child3.setLabel("0");
        this.fRootElement.addChild(child1, new TestModelChange(1, this.fRootElement, child1));
        this.fRootElement.addChild(child2, new TestModelChange(1, this.fRootElement, child2));
        this.fRootElement.addChild(child3, new TestModelChange(1, this.fRootElement, child3));
        Tree tree = (Tree)this.fTreeViewer.getControl();
        Assert.assertEquals((String)"Same element added to parent twice.", (long)3L, (long)tree.getItems().length);
    }

    @Test
    public void testContains() {
        Assert.assertFalse((String)"element must not be available on the viewer", (boolean)this.fTreeViewer.contains((Object)this.fRootElement, (Object)""));
        Assert.assertTrue((String)"element must be available on the viewer", (boolean)this.fTreeViewer.contains((Object)this.fRootElement, (Object)this.fRootElement.getFirstChild()));
        Assert.assertTrue((String)"element must be available on the viewer", (boolean)this.fTreeViewer.contains((Object)this.fRootElement, (Object)this.fRootElement.getLastChild()));
        Assert.assertFalse((String)"element must not be available on the viewer", (boolean)this.fTreeViewer.contains((Object)this.fRootElement.getFirstChild(), (Object)this.fRootElement.getFirstChild().getFirstChild()));
        this.fTreeViewer.expandAll();
        Assert.assertTrue((String)"element must be available on the viewer", (boolean)this.fTreeViewer.contains((Object)this.fRootElement.getFirstChild(), (Object)this.fRootElement.getFirstChild().getFirstChild()));
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.fTreeViewer = null;
    }
}

