/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.tests.viewers.ViewerTestCase;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class BaseLimitBasedViewerTest
extends ViewerTestCase {
    List<DataModel> rootModel;
    protected static final int VIEWER_LIMIT = 4;
    protected static final int DEFAULT_ELEMENTS_COUNT = 40;

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        return null;
    }

    protected static List<DataModel> createModel(int maxCount) {
        ArrayList<DataModel> rootModel = new ArrayList<DataModel>();
        int i = 0;
        while (i < maxCount) {
            if (i % 2 == 0) {
                DataModel rootLevel = new DataModel(i);
                int j = 0;
                while (j < maxCount) {
                    if (j % 2 == 0) {
                        DataModel level1 = new DataModel(j);
                        level1.parent = rootLevel;
                        int k = 0;
                        while (k < maxCount) {
                            if (k % 2 == 0) {
                                DataModel level2 = new DataModel(k);
                                level2.parent = level1;
                                level1.addChild(level2);
                            }
                            ++k;
                        }
                        rootLevel.addChild(level1);
                    }
                    ++j;
                }
                rootModel.add(rootLevel);
            }
            ++i;
        }
        return rootModel;
    }

    protected static class DataModel {
        public Integer id;
        public List<DataModel> children;
        public DataModel parent;

        public DataModel(Integer id) {
            this.id = id;
            this.children = new ArrayList<DataModel>();
        }

        public void addChild(DataModel child) {
            this.children.add(child);
        }

        public String toString() {
            return "Item " + String.valueOf(this.id);
        }
    }

    protected static class TestComparator
    extends ViewerComparator {
        protected TestComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof DataModel) {
                DataModel mod1 = (DataModel)e1;
                if (e2 instanceof DataModel) {
                    DataModel mod2 = (DataModel)e2;
                    return mod1.id.compareTo(mod2.id);
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }

    public static class TestViewerFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parent, Object element) {
            return ((DataModel)element).id > 10;
        }
    }
}

