/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.tests.viewers.ViewerTestCase;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Test;

public class Bug201002TableViewerTest
extends ViewerTestCase {
    @Override
    protected StructuredViewer createViewer(Composite parent) {
        TableViewer tableViewer = new TableViewer(parent, 65536);
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)tableViewer.getTable())});
        tableViewer.setColumnProperties(new String[]{"0"});
        tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                return "";
            }

            public void modify(Object element, String property, Object value) {
            }
        });
        new TableColumn(tableViewer.getTable(), 0).setWidth(200);
        return tableViewer;
    }

    @Override
    protected void setUpModel() {
    }

    @Override
    protected void setInput() {
        String[] ar = new String[100];
        int i = 0;
        while (i < ar.length) {
            ar[i] = "" + i;
            ++i;
        }
        this.getTableViewer().setInput((Object)ar);
    }

    private TableViewer getTableViewer() {
        return (TableViewer)this.fViewer;
    }

    @Test
    public void testBug201002() {
        this.getTableViewer().getTable().setTopIndex(0);
        this.waitForTopIndexUpdate(true);
        this.getTableViewer().editElement(this.getTableViewer().getElementAt(90), 0);
        this.waitForTopIndexUpdate(false);
        int topIndex = this.getTableViewer().getTable().getTopIndex();
        Assert.assertNotEquals((String)"TableViewer top index shouldn't be 0", (long)0L, (long)topIndex);
    }

    private void waitForTopIndexUpdate(final boolean isTopZero) {
        new DisplayHelper(){

            protected boolean condition() {
                while (Bug201002TableViewerTest.this.getTableViewer().getTable().getDisplay().readAndDispatch()) {
                }
                return isTopZero == (Bug201002TableViewerTest.this.getTableViewer().getTable().getTopIndex() == 0);
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L);
    }
}

